/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.error.OAuthTokenErrorCode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u001b\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/hub/auth/OAuthTokenValidationException;", "Lcom/intellij/hub/auth/OAuthValidationException;", "code", "Lcom/intellij/hub/auth/oauth2/error/OAuthTokenErrorCode;", "description", "", "(Lcom/intellij/hub/auth/oauth2/error/OAuthTokenErrorCode;Ljava/lang/String;)V", "cause", "", "(Lcom/intellij/hub/auth/oauth2/error/OAuthTokenErrorCode;Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "com.intellij.hub.auth"})
public final class OAuthTokenValidationException
extends OAuthValidationException {
    private static final String DOC_PREFIX = "token";
    public static final Companion Companion = new Companion(null);

    private OAuthTokenValidationException(OAuthTokenErrorCode code, String description) {
        super(code, description, DOC_PREFIX);
    }

    /* synthetic */ OAuthTokenValidationException(OAuthTokenErrorCode oAuthTokenErrorCode, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(oAuthTokenErrorCode, string);
    }

    private OAuthTokenValidationException(OAuthTokenErrorCode code, String description, Throwable cause) {
        super(code, description, DOC_PREFIX, cause);
    }

    public /* synthetic */ OAuthTokenValidationException(@NotNull OAuthTokenErrorCode code, @Nullable String description, DefaultConstructorMarker $constructor_marker) {
        this(code, description);
    }

    public /* synthetic */ OAuthTokenValidationException(@NotNull OAuthTokenErrorCode code, @NotNull String description, @NotNull Throwable cause, DefaultConstructorMarker $constructor_marker) {
        this(code, description, cause);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0006J\u0019\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0004J\u0006\u0010!\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/hub/auth/OAuthTokenValidationException$Companion;", "", "()V", "DOC_PREFIX", "", "bannedUser", "Lcom/intellij/hub/auth/OAuthValidationException;", "inaccessibleScope", "invalidAuthCode", "invalidAuthHeader", "cause", "", "invalidCredentials", "invalidGrant", "invalidScope", "Lcom/intellij/hub/auth/OAuthTokenValidationException;", "message", "invalidServiceSecret", "missingAuthHeader", "missingParameter", "parameterName", "twoFactorAuthenticationRequired", "unknownAuthCode", "unknownRefreshToken", "unknownScope", "scope", "", "([Ljava/lang/String;)Lcom/intellij/hub/auth/OAuthTokenValidationException;", "unknownService", "clientServiceId", "userEmailIsNotVerified", "userHasNoLicense", "clientServiceName", "wrongClient", "com.intellij.hub.auth"})
    public static final class Companion {
        @NotNull
        public final OAuthValidationException missingParameter(@NotNull String parameterName) {
            Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_REQUEST, "Parameter '" + parameterName + "' is required", null);
        }

        @NotNull
        public final OAuthTokenValidationException invalidScope(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_SCOPE, message, null);
        }

        @NotNull
        public final OAuthTokenValidationException unknownScope(@NotNull String[] scope2) {
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            return this.invalidScope("Scope " + ArraysKt.toList((Object[])scope2) + " doesn't match any Service");
        }

        @NotNull
        public final OAuthValidationException userHasNoLicense(@NotNull String clientServiceName) {
            Intrinsics.checkParameterIsNotNull((Object)clientServiceName, (String)"clientServiceName");
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_SCOPE, "Logged in user has no license for the service '" + clientServiceName + '\'', null);
        }

        @NotNull
        public final OAuthValidationException missingAuthHeader() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_CLIENT, "Authorization header was not passed", null);
        }

        @NotNull
        public final OAuthValidationException invalidGrant() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.UNSUPPORTED_GRANT_TYPE, null, 2, null);
        }

        @NotNull
        public final OAuthValidationException invalidServiceSecret() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Invalid service secret", null);
        }

        @NotNull
        public final OAuthValidationException unknownAuthCode() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Unknown authorization code", null);
        }

        @NotNull
        public final OAuthValidationException invalidAuthCode() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Invalid authorization code", null);
        }

        @NotNull
        public final OAuthValidationException wrongClient() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Refresh token is issued to another client", null);
        }

        @NotNull
        public final OAuthValidationException unknownRefreshToken() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Unknown refresh token", null);
        }

        @NotNull
        public final OAuthValidationException inaccessibleScope() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Requested scope does not match allowed by access token", null);
        }

        @NotNull
        public final OAuthValidationException invalidCredentials() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Invalid resource owner credentials", null);
        }

        @NotNull
        public final OAuthTokenValidationException userEmailIsNotVerified() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Email of authenticated user is not verified", null);
        }

        @NotNull
        public final OAuthTokenValidationException twoFactorAuthenticationRequired() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.SECOND_FACTOR_REQUIRED, null, 2, null);
        }

        @NotNull
        public final OAuthValidationException invalidAuthHeader(@NotNull Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_CLIENT, "Invalid authorization header", cause, null);
        }

        @NotNull
        public final OAuthValidationException unknownService(@NotNull String clientServiceId2) {
            Intrinsics.checkParameterIsNotNull((Object)clientServiceId2, (String)"clientServiceId");
            return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_CLIENT, "Service with id \"" + clientServiceId2 + "\" was not found", null);
        }

        @NotNull
        public final OAuthValidationException bannedUser() {
            return new OAuthTokenValidationException(OAuthTokenErrorCode.BANNED_USER, null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

