/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.core;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/hub/core/URIHelper;", "", "()V", "API_PATH", "", "DOCUMENTATION_PROPERTIES", "Ljava/util/ResourceBundle;", "kotlin.jvm.PlatformType", "SLASH", "hubDocsRestURI", "getHubDocsRestURI", "()Ljava/lang/String;", "hubDocsURI", "getHubDocsURI", "getHubDocsOAuthErrorURI", "docPrefix", "code", "toApiUri", "Ljava/net/URI;", "given", "com.intellij.hub.core"})
public final class URIHelper {
    private static final String API_PATH = "api";
    private static final String SLASH = "/";
    private static final ResourceBundle DOCUMENTATION_PROPERTIES;
    public static final URIHelper INSTANCE;

    @NotNull
    public final String getHubDocsURI() {
        String string = DOCUMENTATION_PROPERTIES.getString("hub.documentation.url");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DOCUMENTATION_PROPERTIES\u2026(\"hub.documentation.url\")");
        return StringsKt.replace$default((String)string, (String)"@doc.version.suffix@", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getHubDocsRestURI() {
        String string = DOCUMENTATION_PROPERTIES.getString("hub.documentation.rest.url");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DOCUMENTATION_PROPERTIES\u2026.documentation.rest.url\")");
        return StringsKt.replace$default((String)string, (String)"@doc.version.suffix@", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final URI toApiUri(@NotNull URI given) {
        URI uRI;
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)given, (String)"given");
        String string = given.getPath();
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        Collection $receiver$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{SLASH}, (boolean)false, (int)0, (int)6, null);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                CharSequence charSequence = it;
                if (charSequence.length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $receiver$iv = list2;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] pathElements = objectArray;
        String lastPathElement = (String)ArraysKt.lastOrNull((Object[])pathElements);
        if (!StringsKt.equals((String)lastPathElement, (String)API_PATH, (boolean)true)) {
            StringBuilder stringBuilder;
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            $receiver.append(SLASH);
            SequencesKt.joinTo$default((Sequence)SequencesKt.plus((Sequence)SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])pathElements), (int)1), (Object)API_PATH), (Appendable)$receiver, (CharSequence)SLASH, null, null, (int)0, null, null, (int)124, null);
            String string3 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            String path = string3;
            uRI = new URI(given.getScheme(), given.getAuthority(), path, given.getQuery(), given.getFragment());
        } else {
            uRI = given;
        }
        return uRI;
    }

    @JvmStatic
    @NotNull
    public static final String getHubDocsOAuthErrorURI(@NotNull String docPrefix, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)docPrefix, (String)"docPrefix");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        String string = DOCUMENTATION_PROPERTIES.getString("hub.documentation.oauth.error.url");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DOCUMENTATION_PROPERTIES\u2026ntation.oauth.error.url\")");
        String errorURLFormat = StringsKt.replace$default((String)string, (String)"@doc.version.suffix@", (String)"", (boolean)false, (int)4, null);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{docPrefix, code};
        String string2 = String.format(errorURLFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    private URIHelper() {
    }

    static {
        URIHelper uRIHelper;
        INSTANCE = uRIHelper = new URIHelper();
        DOCUMENTATION_PROPERTIES = ResourceBundle.getBundle("com.intellij.hub.core.Documentation");
    }
}

