/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.hub;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.intellij.hub.core.URIHelper;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.ext.ContextResolver;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import jetbrains.jetpass.api.APIVersion;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.ImmutableAccountsClient;
import jetbrains.jetpass.client.accounts.ServiceCredentialsValidationResult;
import jetbrains.jetpass.client.hub.HubJsonSubtypesKt;
import jetbrains.jetpass.client.hub.HubURLBuilder;
import jetbrains.jetpass.client.oauth2.OAuth2Client;
import jetbrains.jetpass.client.oauth2.token.OAuth2ClientFlow;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017J3\u0010\u0014\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001b\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Ljetbrains/jetpass/client/hub/HubClient;", "", "jerseyClient", "Ljavax/ws/rs/client/Client;", "baseUri", "Ljava/net/URI;", "(Ljavax/ws/rs/client/Client;Ljava/net/URI;)V", "getBaseUri", "()Ljava/net/URI;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "getJerseyClient", "()Ljavax/ws/rs/client/Client;", "rootResource", "Ljavax/ws/rs/client/WebTarget;", "kotlin.jvm.PlatformType", "getRootResource", "()Ljavax/ws/rs/client/WebTarget;", "getAccountsClient", "Ljetbrains/jetpass/client/accounts/BaseAccountsClient;", "holder", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "serviceId", "serviceSecret", "scope", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljetbrains/jetpass/client/accounts/BaseAccountsClient;", "getOAuthClient", "Ljetbrains/jetpass/client/oauth2/OAuth2Client;", "getURLBuilder", "Ljetbrains/jetpass/client/hub/HubURLBuilder;", "Companion", "HubClientBuilder", "jetbrains.jetpass.client.accounts"})
public final class HubClient {
    private final WebTarget rootResource;
    @NotNull
    private final Client jerseyClient;
    @NotNull
    private final URI baseUri;
    public static final Companion Companion = new Companion(null);

    public final WebTarget getRootResource() {
        return this.rootResource;
    }

    @NotNull
    public final String getBaseUrl() {
        String string = this.baseUri.toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseUri.toASCIIString()");
        return string;
    }

    @NotNull
    public final HubURLBuilder getURLBuilder() {
        String string = this.baseUri.toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseUri.toASCIIString()");
        return new HubURLBuilder(string);
    }

    @NotNull
    public final BaseAccountsClient getAccountsClient() {
        return this.getAccountsClient(null);
    }

    @NotNull
    public final BaseAccountsClient getAccountsClient(@Nullable String serviceId, @Nullable String serviceSecret, String ... scope2) {
        OAuth2ClientFlow oAuth2ClientFlow;
        String string;
        String it;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        String string2 = serviceId;
        if (string2 != null && (string2 = (charSequence = (CharSequence)(it = (string = string2))).length() > 0 ? string : null) != null) {
            it = string = string2;
            OAuth2Client authClient = this.getOAuthClient();
            oAuth2ClientFlow = ((OAuth2ClientFlow.Builder)((OAuth2ClientFlow.Builder)((OAuth2ClientFlow.Builder)((OAuth2ClientFlow.Builder)authClient.clientFlow().clientId(serviceId)).clientSecret(serviceSecret)).scope(Arrays.copyOf(scope2, scope2.length))).addScope(authClient.getHubScope())).build();
        } else {
            oAuth2ClientFlow = null;
        }
        OAuth2ClientFlow flow = oAuth2ClientFlow;
        return this.getAccountsClient(flow);
    }

    @NotNull
    public final BaseAccountsClient getAccountsClient(@Nullable TokenHolder<?> holder) {
        return new ImmutableAccountsClient(this, holder);
    }

    @NotNull
    public final OAuth2Client getOAuthClient() {
        return OAuth2Client.Companion.builder(this.jerseyClient).baseUrl(this.baseUri).build();
    }

    @NotNull
    public final Client getJerseyClient() {
        return this.jerseyClient;
    }

    @NotNull
    public final URI getBaseUri() {
        return this.baseUri;
    }

    private HubClient(Client jerseyClient, URI baseUri) {
        this.jerseyClient = jerseyClient;
        this.baseUri = baseUri;
        this.rootResource = this.jerseyClient.target(URIHelper.INSTANCE.toApiUri(this.baseUri));
    }

    public /* synthetic */ HubClient(@NotNull Client jerseyClient, @NotNull URI baseUri, DefaultConstructorMarker $constructor_marker) {
        this(jerseyClient, baseUri);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0005\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012J\u0015\u0010\u0016\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Ljetbrains/jetpass/client/hub/HubClient$HubClientBuilder;", "", "builder", "Ljavax/ws/rs/client/ClientBuilder;", "(Ljavax/ws/rs/client/ClientBuilder;)V", "baseUrl", "Ljava/net/URI;", "baseUrl$annotations", "()V", "client", "Ljavax/ws/rs/client/Client;", "getClient", "()Ljavax/ws/rs/client/Client;", "apiVersion", "version", "Ljetbrains/jetpass/api/APIVersion;", "baseUri", "Ljava/net/URL;", "", "build", "Ljetbrains/jetpass/client/hub/HubClient;", "baseURL", "connectTimeout", "timeout", "", "(Ljava/lang/Integer;)Ljetbrains/jetpass/client/hub/HubClient$HubClientBuilder;", "readTimeout", "APIVersionClientRequestFilter", "JAXBContextResolver", "JacksonProvider", "jetbrains.jetpass.client.accounts"})
    public static final class HubClientBuilder {
        @NotNull
        private final Client client;
        private URI baseUrl;

        @NotNull
        public final Client getClient() {
            return this.client;
        }

        @Deprecated(message="")
        private static /* synthetic */ void baseUrl$annotations() {
        }

        @Deprecated(message="Pass buildURL to build() method instead")
        @NotNull
        public final HubClientBuilder baseUrl(@Nullable String baseUrl) {
            URI uRI;
            HubClientBuilder hubClientBuilder = this;
            String string = baseUrl;
            if (string != null) {
                String string2 = string;
                HubClientBuilder hubClientBuilder2 = hubClientBuilder;
                String it = string2;
                URI uRI2 = URI.create(it);
                hubClientBuilder = hubClientBuilder2;
                uRI = uRI2;
            } else {
                uRI = null;
            }
            return hubClientBuilder.baseUrl(uRI);
        }

        @Deprecated(message="Pass buildURL to build() method instead")
        @NotNull
        public final HubClientBuilder baseUrl(@Nullable URL baseUrl) {
            URL uRL = baseUrl;
            return this.baseUrl(uRL != null ? uRL.toString() : null);
        }

        @Deprecated(message="Pass buildURL to build() method instead")
        @NotNull
        public final HubClientBuilder baseUrl(@Nullable URI baseUri) {
            HubClientBuilder hubClientBuilder;
            HubClientBuilder $receiver = hubClientBuilder = this;
            $receiver.baseUrl = baseUri;
            return hubClientBuilder;
        }

        @NotNull
        public final HubClientBuilder apiVersion(@NotNull APIVersion version) {
            HubClientBuilder hubClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
            HubClientBuilder $receiver = hubClientBuilder = this;
            $receiver.client.property("jetbrains.hub.apiVersion", (Object)version);
            return hubClientBuilder;
        }

        @NotNull
        public final HubClientBuilder connectTimeout(@Nullable Integer timeout) {
            HubClientBuilder hubClientBuilder;
            HubClientBuilder $receiver = hubClientBuilder = this;
            $receiver.client.property("jersey.config.client.connectTimeout", (Object)timeout);
            return hubClientBuilder;
        }

        @NotNull
        public final HubClientBuilder readTimeout(@Nullable Integer timeout) {
            HubClientBuilder hubClientBuilder;
            HubClientBuilder $receiver = hubClientBuilder = this;
            $receiver.client.property("jersey.config.client.readTimeout", (Object)timeout);
            return hubClientBuilder;
        }

        @NotNull
        public final HubClient build(@NotNull URI baseURL) {
            Intrinsics.checkParameterIsNotNull((Object)baseURL, (String)"baseURL");
            return new HubClient(this.client, baseURL, null);
        }

        @NotNull
        public final HubClient build(@NotNull String baseURL) {
            Intrinsics.checkParameterIsNotNull((Object)baseURL, (String)"baseURL");
            URI uRI = URI.create(baseURL);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(baseURL)");
            return this.build(uRI);
        }

        @Deprecated(message="Use build(baseURL) instead")
        @NotNull
        public final HubClient build() {
            URI uRI = this.baseUrl;
            if (uRI == null) {
                throw (Throwable)new IllegalStateException(ServiceCredentialsValidationResult.Status.EMPTY_URL.getMessage());
            }
            return this.build(uRI);
        }

        public HubClientBuilder(@NotNull ClientBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            builder.register(APIVersionClientRequestFilter.class);
            builder.register(JacksonProvider.class);
            builder.register(JAXBContextResolver.class);
            Client client = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)client, (String)"builder.build()");
            this.client = client;
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ljetbrains/jetpass/client/hub/HubClient$HubClientBuilder$APIVersionClientRequestFilter;", "Ljavax/ws/rs/client/ClientRequestFilter;", "()V", "filter", "", "requestContext", "Ljavax/ws/rs/client/ClientRequestContext;", "jetbrains.jetpass.client.accounts"})
        public static final class APIVersionClientRequestFilter
        implements ClientRequestFilter {
            public void filter(@NotNull ClientRequestContext requestContext) {
                block0: {
                    Object object;
                    Object apiVersion;
                    Intrinsics.checkParameterIsNotNull((Object)requestContext, (String)"requestContext");
                    Client client = requestContext.getClient();
                    Intrinsics.checkExpressionValueIsNotNull((Object)client, (String)"requestContext.client");
                    Object object2 = apiVersion = client.getConfiguration().getProperty("jetbrains.hub.apiVersion");
                    if (object2 == null) break block0;
                    Object it = object = object2;
                    requestContext.getHeaders().add((Object)"Hub-API-Version", it);
                }
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\"\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0082\b\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/client/hub/HubClient$HubClientBuilder$JAXBContextResolver;", "Ljavax/ws/rs/ext/ContextResolver;", "Ljavax/xml/bind/JAXBContext;", "()V", "getContext", "clazz", "Ljava/lang/Class;", "runWithThisClassLoader", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "jetbrains.jetpass.client.accounts"})
        public static final class JAXBContextResolver
        implements ContextResolver<JAXBContext> {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public JAXBContext getContext(@NotNull Class<?> clazz) {
                JAXBContext jAXBContext;
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                JAXBContextResolver this_$iv = this;
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                ClassLoader original$iv = thread.getContextClassLoader();
                try {
                    Thread thread2 = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
                    thread2.setContextClassLoader(this_$iv.getClass().getClassLoader());
                    try {
                        Collection $receiver$iv;
                        Collection collection = $receiver$iv = (Collection)SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])HubJsonSubtypesKt.getINHERITED_JSONS()), clazz));
                        if (collection == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                        }
                        Collection thisCollection$iv = collection;
                        Class[] classArray = thisCollection$iv.toArray(new Class[0]);
                        if (classArray == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        jAXBContext = JAXBContext.newInstance((Class[])Arrays.copyOf(classArray, classArray.length));
                    }
                    catch (JAXBException e) {
                        e.printStackTrace();
                        jAXBContext = null;
                    }
                }
                finally {
                    Thread thread3 = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread3, (String)"Thread.currentThread()");
                    thread3.setContextClassLoader(original$iv);
                }
                return jAXBContext;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final <T> T runWithThisClassLoader(Function0<? extends T> body) {
                Object object;
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                ClassLoader original = thread.getContextClassLoader();
                try {
                    Thread thread2 = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
                    thread2.setContextClassLoader(this.getClass().getClassLoader());
                    object = body.invoke();
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    Thread thread3 = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread3, (String)"Thread.currentThread()");
                    thread3.setContextClassLoader(original);
                    InlineMarker.finallyEnd((int)1);
                }
                return (T)object;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/client/hub/HubClient$HubClientBuilder$JacksonProvider;", "Lcom/fasterxml/jackson/jaxrs/json/JacksonJsonProvider;", "()V", "jetbrains.jetpass.client.accounts"})
        public static final class JacksonProvider
        extends JacksonJsonProvider {
            public JacksonProvider() {
                ObjectMapper objectMapper = new ObjectMapper();
                JacksonProvider jacksonProvider = this;
                ObjectMapper $receiver = objectMapper;
                $receiver.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                $receiver.setAnnotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()), (AnnotationIntrospector)new JacksonAnnotationIntrospector()));
                HubJsonSubtypesKt.registerHubSubtypes($receiver);
                ObjectMapper objectMapper2 = objectMapper;
                jacksonProvider.setMapper(objectMapper2);
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Ljetbrains/jetpass/client/hub/HubClient$Companion;", "", "()V", "builder", "Ljetbrains/jetpass/client/hub/HubClient$HubClientBuilder;", "Ljavax/ws/rs/client/ClientBuilder;", "jetbrains.jetpass.client.accounts"})
    public static final class Companion {
        @JvmOverloads
        @NotNull
        public final HubClientBuilder builder(@NotNull ClientBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            return new HubClientBuilder(builder);
        }

        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ HubClientBuilder builder$default(Companion companion, ClientBuilder clientBuilder, int n, Object object) {
            if ((n & 1) != 0) {
                ClientBuilder clientBuilder2 = ClientBuilder.newBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)clientBuilder2, (String)"ClientBuilder.newBuilder()");
                clientBuilder = clientBuilder2;
            }
            return companion.builder(clientBuilder);
        }

        @JvmOverloads
        @NotNull
        public final HubClientBuilder builder() {
            return jetbrains.jetpass.client.hub.HubClient$Companion.builder$default(this, null, 1, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

