/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.oauth2;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.request.AuthRequestParameter;
import com.intellij.hub.auth.request.Header;
import com.intellij.hub.core.URIHelper;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import jetbrains.jetpass.api.authority.auth.TokenInfo;
import jetbrains.jetpass.client.oauth2.OAuth2Path;
import jetbrains.jetpass.client.oauth2.auth.OAuth2CodeFlow;
import jetbrains.jetpass.client.oauth2.auth.OAuth2ImplicitFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2ClientFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2RefreshTokenFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2ResourceOwnerFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2TokenFlow;
import jetbrains.jetpass.rest.dto.TokenInfoJSON;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u000278BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J.\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJX\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\b\u0010 \u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\"2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\fJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,JN\u0010+\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\b\u0010 \u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\"2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\fJ\u0006\u0010.\u001a\u00020/J6\u0010.\u001a\u0002002\u0006\u00101\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0006\u00102\u001a\u000203JH\u00102\u001a\u0002042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u001a\u001a\u00020\u001bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ljetbrains/jetpass/client/oauth2/OAuth2Client;", "", "client", "Ljavax/ws/rs/client/Client;", "authURI", "Ljava/net/URI;", "tokenURI", "hubScopeURI", "publicKeyURI", "tokenInfoURI", "(Ljavax/ws/rs/client/Client;Ljava/net/URI;Ljava/net/URI;Ljava/net/URI;Ljava/net/URI;Ljava/net/URI;)V", "hubScope", "", "getHubScope", "()Ljava/lang/String;", "publicKey", "getPublicKey", "checkURI", "uri", "clientFlow", "Ljetbrains/jetpass/client/oauth2/token/OAuth2ClientFlow$Builder;", "Ljetbrains/jetpass/client/oauth2/token/OAuth2ClientFlow;", "clientId", "clientSecret", "scope", "", "clientAuth", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;", "codeFlow", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2CodeFlow$Builder;", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2CodeFlow;", "redirectUri", "state", "requestRefreshToken", "", "credentialsRequest", "Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;", "forceApproval", "message", "getTokenInfo", "Ljetbrains/jetpass/api/authority/auth/TokenInfo;", "token", "Lcom/intellij/hub/auth/AuthToken;", "implicitFlow", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2ImplicitFlow$Builder;", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2ImplicitFlow;", "refreshTokenFlow", "Ljetbrains/jetpass/client/oauth2/token/OAuth2RefreshTokenFlow$Builder;", "Ljetbrains/jetpass/client/oauth2/token/OAuth2RefreshTokenFlow;", "refreshToken", "resourceOwnerFlow", "Ljetbrains/jetpass/client/oauth2/token/OAuth2ResourceOwnerFlow$Builder;", "Ljetbrains/jetpass/client/oauth2/token/OAuth2ResourceOwnerFlow;", "username", "password", "Companion", "OAuth2ClientBuilder", "jetbrains.jetpass.client.oauth2"})
public final class OAuth2Client {
    private final Client client;
    private final URI authURI;
    private final URI tokenURI;
    private final URI hubScopeURI;
    private final URI publicKeyURI;
    private final URI tokenInfoURI;
    public static final Companion Companion = new Companion(null);

    private final URI checkURI(URI uri) {
        boolean bl;
        boolean bl2 = bl = uri != null;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        URI uRI = uri;
        if (uRI == null) {
            Intrinsics.throwNpe();
        }
        return uRI;
    }

    @NotNull
    public final String getHubScope() throws WebApplicationException {
        Object object = this.client.target(this.checkURI(this.hubScopeURI)).request().get(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"client.target(checkURI(h\u2026).get(String::class.java)");
        return (String)object;
    }

    @NotNull
    public final String getPublicKey() throws WebApplicationException {
        Object object = this.client.target(this.checkURI(this.publicKeyURI)).request().get(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"client.target(checkURI(p\u2026).get(String::class.java)");
        return (String)object;
    }

    @NotNull
    public final TokenInfo getTokenInfo(@NotNull AuthToken token) throws WebApplicationException {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Header header2 = Header.Companion.authorization(token);
        Object object = this.client.target(this.checkURI(this.tokenInfoURI)).request().header(header2.getName(), (Object)header2.getValue()).get(TokenInfoJSON.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"client.target(checkURI(t\u2026okenInfoJSON::class.java)");
        return (TokenInfo)object;
    }

    @NotNull
    public final OAuth2ClientFlow.Builder clientFlow() {
        return new OAuth2ClientFlow.Builder(this.client, this.checkURI(this.tokenURI));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2ClientFlow clientFlow(@NotNull String clientId, @NotNull String clientSecret, @NotNull List<String> scope2, @NotNull OAuth2TokenFlow.ClientAuth clientAuth) {
        String[] stringArray;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull(scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)clientAuth), (String)"clientAuth");
        Collection collection = scope2;
        OAuth2ClientFlow.Builder builder = this.clientFlow();
        void thisCollection$iv = $receiver$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        return ((OAuth2ClientFlow.Builder)((OAuth2ClientFlow.Builder)((OAuth2ClientFlow.Builder)((OAuth2ClientFlow.Builder)builder.scope(Arrays.copyOf(stringArray3, stringArray3.length))).clientId(clientId)).clientSecret(clientSecret)).clientAuth(clientAuth)).build();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OAuth2ClientFlow clientFlow$default(OAuth2Client oAuth2Client, String string, String string2, List list2, OAuth2TokenFlow.ClientAuth clientAuth, int n, Object object) {
        if ((n & 8) != 0) {
            clientAuth = OAuth2TokenFlow.ClientAuth.HEADER;
        }
        return oAuth2Client.clientFlow(string, string2, list2, clientAuth);
    }

    @NotNull
    public final OAuth2CodeFlow.Builder codeFlow() {
        return new OAuth2CodeFlow.Builder(this.client, this.checkURI(this.authURI), this.checkURI(this.tokenURI));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2CodeFlow codeFlow(@NotNull String clientId, @NotNull URI redirectUri, @NotNull List<String> scope2, @Nullable String state, boolean requestRefreshToken, @NotNull AuthRequestParameter.RequestCredentials credentialsRequest, boolean forceApproval, @Nullable String message) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkParameterIsNotNull(scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)credentialsRequest), (String)"credentialsRequest");
        Object object2 = scope2;
        OAuth2CodeFlow.Builder builder = (OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)this.codeFlow().clientId(clientId)).redirectUri(redirectUri);
        void thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object3 = stringArray;
        OAuth2CodeFlow.Builder builder2 = (OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)builder.scope(Arrays.copyOf(object3, ((String[])object3).length))).state(state)).accessType(requestRefreshToken ? AuthRequestParameter.AccessType.OFFLINE : AuthRequestParameter.AccessType.ONLINE).credentials(credentialsRequest);
        if (forceApproval) {
            object2 = "force";
            builder = builder2;
            String string = ((String)object2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            object3 = string;
            builder2 = builder;
            object = object3;
        } else {
            object = null;
        }
        return ((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)builder2.approval((String)object)).message(message)).build();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OAuth2CodeFlow codeFlow$default(OAuth2Client oAuth2Client, String string, URI uRI, List list2, String string2, boolean bl, AuthRequestParameter.RequestCredentials requestCredentials, boolean bl2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            requestCredentials = AuthRequestParameter.RequestCredentials.DEFAULT;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            string3 = null;
        }
        return oAuth2Client.codeFlow(string, uRI, list2, string2, bl, requestCredentials, bl2, string3);
    }

    @NotNull
    public final OAuth2ImplicitFlow.Builder implicitFlow() {
        return new OAuth2ImplicitFlow.Builder(this.client, this.checkURI(this.authURI));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2ImplicitFlow implicitFlow(@NotNull String clientId, @NotNull URI redirectUri, @NotNull List<String> scope2, @Nullable String state, @NotNull AuthRequestParameter.RequestCredentials credentialsRequest, boolean forceApproval, @Nullable String message) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkParameterIsNotNull(scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)credentialsRequest), (String)"credentialsRequest");
        Object object2 = scope2;
        OAuth2ImplicitFlow.Builder builder = (OAuth2ImplicitFlow.Builder)((OAuth2ImplicitFlow.Builder)this.implicitFlow().clientId(clientId)).redirectUri(redirectUri);
        void thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object3 = stringArray;
        OAuth2ImplicitFlow.Builder builder2 = (OAuth2ImplicitFlow.Builder)((OAuth2ImplicitFlow.Builder)((OAuth2ImplicitFlow.Builder)builder.scope(Arrays.copyOf(object3, ((String[])object3).length))).state(state)).credentials(credentialsRequest);
        if (forceApproval) {
            object2 = "force";
            builder = builder2;
            String string = ((String)object2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            object3 = string;
            builder2 = builder;
            object = object3;
        } else {
            object = null;
        }
        return ((OAuth2ImplicitFlow.Builder)((OAuth2ImplicitFlow.Builder)builder2.approval((String)object)).message(message)).build();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OAuth2ImplicitFlow implicitFlow$default(OAuth2Client oAuth2Client, String string, URI uRI, List list2, String string2, AuthRequestParameter.RequestCredentials requestCredentials, boolean bl, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            requestCredentials = AuthRequestParameter.RequestCredentials.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        return oAuth2Client.implicitFlow(string, uRI, list2, string2, requestCredentials, bl, string3);
    }

    @NotNull
    public final OAuth2ResourceOwnerFlow.Builder resourceOwnerFlow() {
        return new OAuth2ResourceOwnerFlow.Builder(this.client, this.checkURI(this.tokenURI));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2ResourceOwnerFlow resourceOwnerFlow(@NotNull String clientId, @NotNull String clientSecret, @NotNull String username, @NotNull String password, @NotNull List<String> scope2, boolean requestRefreshToken, @NotNull OAuth2TokenFlow.ClientAuth clientAuth) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull(scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)clientAuth), (String)"clientAuth");
        Collection collection = scope2;
        OAuth2ResourceOwnerFlow.Builder builder = ((OAuth2ResourceOwnerFlow.Builder)((OAuth2ResourceOwnerFlow.Builder)this.resourceOwnerFlow().clientId(clientId)).clientSecret(clientSecret)).username(username).password(password);
        void thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        return ((OAuth2ResourceOwnerFlow.Builder)((OAuth2ResourceOwnerFlow.Builder)builder.scope(Arrays.copyOf(stringArray2, stringArray2.length))).accessType(requestRefreshToken ? AuthRequestParameter.AccessType.OFFLINE : AuthRequestParameter.AccessType.ONLINE).clientAuth(clientAuth)).build();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OAuth2ResourceOwnerFlow resourceOwnerFlow$default(OAuth2Client oAuth2Client, String string, String string2, String string3, String string4, List list2, boolean bl, OAuth2TokenFlow.ClientAuth clientAuth, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            clientAuth = OAuth2TokenFlow.ClientAuth.HEADER;
        }
        return oAuth2Client.resourceOwnerFlow(string, string2, string3, string4, list2, bl, clientAuth);
    }

    @NotNull
    public final OAuth2RefreshTokenFlow.Builder refreshTokenFlow() {
        return new OAuth2RefreshTokenFlow.Builder(this.client, this.checkURI(this.tokenURI));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2RefreshTokenFlow refreshTokenFlow(@NotNull String refreshToken, @NotNull String clientId, @NotNull String clientSecret, @NotNull List<String> scope2, @NotNull OAuth2TokenFlow.ClientAuth clientAuth) {
        String[] stringArray;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull(scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)clientAuth), (String)"clientAuth");
        Collection collection = scope2;
        OAuth2RefreshTokenFlow.Builder builder = (OAuth2RefreshTokenFlow.Builder)((OAuth2RefreshTokenFlow.Builder)this.refreshTokenFlow().token(refreshToken).clientId(clientId)).clientSecret(clientSecret);
        void thisCollection$iv = $receiver$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        return ((OAuth2RefreshTokenFlow.Builder)((OAuth2RefreshTokenFlow.Builder)builder.scope(Arrays.copyOf(stringArray3, stringArray3.length))).clientAuth(clientAuth)).build();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OAuth2RefreshTokenFlow refreshTokenFlow$default(OAuth2Client oAuth2Client, String string, String string2, String string3, List list2, OAuth2TokenFlow.ClientAuth clientAuth, int n, Object object) {
        if ((n & 0x10) != 0) {
            clientAuth = OAuth2TokenFlow.ClientAuth.HEADER;
        }
        return oAuth2Client.refreshTokenFlow(string, string2, string3, list2, clientAuth);
    }

    public OAuth2Client(@NotNull Client client, @Nullable URI authURI, @Nullable URI tokenURI, @Nullable URI hubScopeURI, @Nullable URI publicKeyURI, @Nullable URI tokenInfoURI) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        this.authURI = authURI;
        this.tokenURI = tokenURI;
        this.hubScopeURI = hubScopeURI;
        this.publicKeyURI = publicKeyURI;
        this.tokenInfoURI = tokenInfoURI;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OAuth2ClientBuilder builder(@NotNull Client client) {
        return Companion.builder(client);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OAuth2ClientBuilder builder() {
        return jetbrains.jetpass.client.oauth2.OAuth2Client$Companion.builder$default(Companion, null, 1, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/client/oauth2/OAuth2Client$OAuth2ClientBuilder;", "", "client", "Ljavax/ws/rs/client/Client;", "(Ljavax/ws/rs/client/Client;)V", "authURI", "Ljava/net/URI;", "getClient", "()Ljavax/ws/rs/client/Client;", "hubScopeURI", "publicKeyURI", "tokenInfoURI", "tokenURI", "authServerURI", "", "baseUrl", "baseUri", "build", "Ljetbrains/jetpass/client/oauth2/OAuth2Client;", "jetbrains.jetpass.client.oauth2"})
    public static final class OAuth2ClientBuilder {
        private URI authURI;
        private URI tokenURI;
        private URI hubScopeURI;
        private URI publicKeyURI;
        private URI tokenInfoURI;
        @NotNull
        private final Client client;

        @NotNull
        public final OAuth2ClientBuilder baseUrl(@NotNull String baseUri) {
            Intrinsics.checkParameterIsNotNull((Object)baseUri, (String)"baseUri");
            URI uRI = URI.create(baseUri);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(baseUri)");
            return this.baseUrl(uRI);
        }

        @NotNull
        public final OAuth2ClientBuilder baseUrl(@NotNull URI baseUri) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)baseUri, (String)"baseUri");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            URI uRI = UriBuilder.fromUri((URI)URIHelper.INSTANCE.toApiUri(baseUri)).path("rest").path("oauth2").build(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(URIHe\u2026\").path(\"oauth2\").build()");
            $receiver.authServerURI(uRI);
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder authServerURI(@NotNull String authServerURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)authServerURI, (String)"authServerURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            URI uRI = URI.create(authServerURI);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(authServerURI)");
            $receiver.authServerURI(uRI);
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder authServerURI(@NotNull URI authServerURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)authServerURI, (String)"authServerURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            WebTarget webTarget = $receiver.client.target(authServerURI).path(OAuth2Path.AUTH.getPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"client.target(authServer\u2026ath(OAuth2Path.AUTH.path)");
            $receiver.authURI = webTarget.getUri();
            WebTarget webTarget2 = $receiver.client.target(authServerURI).path(OAuth2Path.TOKEN.getPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget2, (String)"client.target(authServer\u2026th(OAuth2Path.TOKEN.path)");
            $receiver.tokenURI = webTarget2.getUri();
            WebTarget webTarget3 = $receiver.client.target(authServerURI).path(OAuth2Path.HUB_SCOPE.getPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget3, (String)"client.target(authServer\u2026Auth2Path.HUB_SCOPE.path)");
            $receiver.hubScopeURI = webTarget3.getUri();
            WebTarget webTarget4 = $receiver.client.target(authServerURI).path(OAuth2Path.PUBLIC_KEY.getPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget4, (String)"client.target(authServer\u2026uth2Path.PUBLIC_KEY.path)");
            $receiver.publicKeyURI = webTarget4.getUri();
            WebTarget webTarget5 = $receiver.client.target(authServerURI).path(OAuth2Path.TOKEN_INFO.getPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget5, (String)"client.target(authServer\u2026uth2Path.TOKEN_INFO.path)");
            $receiver.tokenInfoURI = webTarget5.getUri();
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder authURI(@NotNull String authURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)authURI, (String)"authURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            $receiver.authURI = URI.create(authURI);
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder authURI(@NotNull URI authURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)authURI, (String)"authURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            $receiver.authURI = authURI;
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder tokenURI(@NotNull String tokenURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)tokenURI, (String)"tokenURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            $receiver.tokenURI = URI.create(tokenURI);
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder tokenURI(@NotNull URI tokenURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)tokenURI, (String)"tokenURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            $receiver.tokenURI = tokenURI;
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder tokenInfoURI(@NotNull String tokenInfoURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)tokenInfoURI, (String)"tokenInfoURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            $receiver.tokenInfoURI = URI.create(tokenInfoURI);
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2ClientBuilder tokenInfoURI(@NotNull URI tokenInfoURI) {
            OAuth2ClientBuilder oAuth2ClientBuilder;
            Intrinsics.checkParameterIsNotNull((Object)tokenInfoURI, (String)"tokenInfoURI");
            OAuth2ClientBuilder $receiver = oAuth2ClientBuilder = this;
            $receiver.tokenInfoURI = tokenInfoURI;
            return oAuth2ClientBuilder;
        }

        @NotNull
        public final OAuth2Client build() {
            return new OAuth2Client(this.client, this.authURI, this.tokenURI, this.hubScopeURI, this.publicKeyURI, this.tokenInfoURI);
        }

        @NotNull
        public final Client getClient() {
            return this.client;
        }

        public OAuth2ClientBuilder(@NotNull Client client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            this.client = client;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Ljetbrains/jetpass/client/oauth2/OAuth2Client$Companion;", "", "()V", "builder", "Ljetbrains/jetpass/client/oauth2/OAuth2Client$OAuth2ClientBuilder;", "client", "Ljavax/ws/rs/client/Client;", "jetbrains.jetpass.client.oauth2"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OAuth2ClientBuilder builder(@NotNull Client client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            return new OAuth2ClientBuilder(client);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ OAuth2ClientBuilder builder$default(Companion companion, Client client, int n, Object object) {
            if ((n & 1) != 0) {
                Client client2 = ClientBuilder.newClient();
                Intrinsics.checkExpressionValueIsNotNull((Object)client2, (String)"ClientBuilder.newClient()");
                client = client2;
            }
            return companion.builder(client);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OAuth2ClientBuilder builder() {
            return jetbrains.jetpass.client.oauth2.OAuth2Client$Companion.builder$default(this, null, 1, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

