/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.oauth2.token;

import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.intellij.hub.auth.oauth2.consumer.TokenLoader;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.request.Header;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import jetbrains.jetpass.client.oauth2.OAuth2Flow;
import jetbrains.jetpass.client.oauth2.SimpleTokenLoader;
import jetbrains.jetpass.client.oauth2.token.OAuth2ResourceOwnerFlow;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002/0B'\b\u0004\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\b\u0001\u0012\u00020\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110(H$J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0014J1\u0010+\u001a\u0002H,\"\u0014\b\u0000\u0010,*\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u0002H-0\u0005\"\b\b\u0001\u0010-*\u00020\u0000*\u0002H,H\u0004\u00a2\u0006\u0002\u0010.R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00061"}, d2={"Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow;", "Ljetbrains/jetpass/client/oauth2/OAuth2Flow;", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "builder", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;", "(Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;)V", "basicAuthToken", "Lcom/intellij/hub/auth/basic/BasicAuthToken;", "getBasicAuthToken", "()Lcom/intellij/hub/auth/basic/BasicAuthToken;", "cache", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/hub/auth/oauth2/consumer/TokenLoader$TokenData;", "clientAuth", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;", "clientSecret", "", "header", "Lcom/intellij/hub/auth/request/Header;", "getHeader", "()Lcom/intellij/hub/auth/request/Header;", "loader", "Lcom/intellij/hub/auth/oauth2/consumer/TokenLoader;", "getLoader", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenLoader;", "rawToken", "getRawToken", "()Ljava/lang/String;", "token", "getToken", "()Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "tokenData", "getTokenData", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenLoader$TokenData;", "tokenURI", "Ljava/net/URI;", "getTokenURI", "()Ljava/net/URI;", "buildParams", "Ljavax/ws/rs/core/MultivaluedMap;", "refresh", "data", "appendSecret", "B", "F", "(Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;)Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;", "Builder", "ClientAuth", "jetbrains.jetpass.client.oauth2"})
public abstract class OAuth2TokenFlow
extends OAuth2Flow
implements TokenHolder<AccessToken> {
    @NotNull
    private final URI tokenURI;
    private final String clientSecret;
    private final ClientAuth clientAuth;
    private final AtomicReference<TokenLoader.TokenData> cache;

    @NotNull
    protected final URI getTokenURI() {
        return this.tokenURI;
    }

    @NotNull
    public final TokenLoader getLoader() {
        WebTarget res = this.getClient().target(this.tokenURI);
        MultivaluedMap<String, String> params2 = this.buildParams();
        WebTarget webTarget = res;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"res");
        return new SimpleTokenLoader(webTarget, params2, this.clientAuth);
    }

    private final BasicAuthToken getBasicAuthToken() {
        String string = this.getClientServiceId();
        if (string == null) {
            throw (Throwable)new IllegalStateException("Client ID is undefined");
        }
        String string2 = this.clientSecret;
        if (string2 == null) {
            throw (Throwable)new IllegalStateException("Client Secret is undefined");
        }
        return new BasicAuthToken(string, string2);
    }

    @Override
    @NotNull
    public AccessToken getToken() throws OAuth2TokenLoadException {
        return this.getTokenData().getAccessToken();
    }

    @Override
    @NotNull
    public TokenLoader.TokenData getToken(@NotNull BasicAuthToken token) throws OAuth2TokenLoadException {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        String[] stringArray = this.getScope();
        return ((OAuth2ResourceOwnerFlow.Builder)((OAuth2ResourceOwnerFlow.Builder)((OAuth2ResourceOwnerFlow.Builder)((OAuth2ResourceOwnerFlow.Builder)new OAuth2ResourceOwnerFlow.Builder(this.getClient(), this.tokenURI).scope(Arrays.copyOf(stringArray, stringArray.length))).clientSecret(this.clientSecret)).clientId(this.getClientServiceId())).clientAuth(this.clientAuth)).username(token.getUsername()).password(token.getPassword()).build().getTokenData();
    }

    @NotNull
    public final String getRawToken() throws OAuth2TokenLoadException {
        return this.getTokenData().getRawAccessToken();
    }

    @NotNull
    protected final <B extends Builder<B, F>, F extends OAuth2TokenFlow> B appendSecret(@NotNull B $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return ((Builder)$receiver.clientSecret(this.clientSecret)).clientAuth(this.clientAuth);
    }

    @NotNull
    public final TokenLoader.TokenData getTokenData() throws OAuth2TokenLoadException {
        TokenLoader.TokenData current = this.cache.get();
        TokenLoader.TokenData data = current;
        if (data == null) {
            data = this.getLoader().loadAccessToken(this.getBasicAuthToken());
        } else if (data.isExpired()) {
            data = this.refresh(data);
        } else {
            return data;
        }
        return this.cache.compareAndSet(current, data) ? data : this.getTokenData();
    }

    @NotNull
    protected TokenLoader.TokenData refresh(@NotNull TokenLoader.TokenData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return this.getLoader().loadAccessToken(this.getBasicAuthToken());
    }

    @Override
    @NotNull
    public Header getHeader() throws OAuth2TokenLoadException {
        return Header.Companion.authorization(this.getToken());
    }

    @NotNull
    protected abstract MultivaluedMap<String, String> buildParams();

    protected OAuth2TokenFlow(@NotNull Builder<? extends Builder<?, ?>, ? extends OAuth2TokenFlow> builder) {
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        super((OAuth2Flow.Builder)builder);
        this.tokenURI = builder.getTokenURI$jetbrains_jetpass_client_oauth2();
        this.clientSecret = builder.getClientSecret$jetbrains_jetpass_client_oauth2();
        this.clientAuth = builder.getClientAuth$jetbrains_jetpass_client_oauth2();
        this.cache = new AtomicReference();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\b&\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\u0017\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0010\u001a\u00028\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u001aR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;", "B", "Flow", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow;", "Ljetbrains/jetpass/client/oauth2/OAuth2Flow$Builder;", "client", "Ljavax/ws/rs/client/Client;", "tokenURI", "Ljava/net/URI;", "(Ljavax/ws/rs/client/Client;Ljava/net/URI;)V", "clientAuth", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;", "getClientAuth$jetbrains_jetpass_client_oauth2", "()Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;", "setClientAuth$jetbrains_jetpass_client_oauth2", "(Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;)V", "clientSecret", "", "getClientSecret$jetbrains_jetpass_client_oauth2", "()Ljava/lang/String;", "setClientSecret$jetbrains_jetpass_client_oauth2", "(Ljava/lang/String;)V", "getTokenURI$jetbrains_jetpass_client_oauth2", "()Ljava/net/URI;", "(Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;)Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;", "serviceSecret", "(Ljava/lang/String;)Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;", "jetbrains.jetpass.client.oauth2"})
    public static abstract class Builder<B extends Builder<B, Flow>, Flow extends OAuth2TokenFlow>
    extends OAuth2Flow.Builder<B, Flow> {
        @Nullable
        private String clientSecret;
        @NotNull
        private ClientAuth clientAuth;
        @NotNull
        private final URI tokenURI;

        @Nullable
        public final String getClientSecret$jetbrains_jetpass_client_oauth2() {
            return this.clientSecret;
        }

        public final void setClientSecret$jetbrains_jetpass_client_oauth2(@Nullable String string) {
            this.clientSecret = string;
        }

        @NotNull
        public final ClientAuth getClientAuth$jetbrains_jetpass_client_oauth2() {
            return this.clientAuth;
        }

        public final void setClientAuth$jetbrains_jetpass_client_oauth2(@NotNull ClientAuth clientAuth) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)clientAuth), (String)"<set-?>");
            this.clientAuth = clientAuth;
        }

        @NotNull
        public final B clientSecret(@Nullable String serviceSecret) {
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.clientSecret = serviceSecret;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder2));
        }

        @NotNull
        public final B clientAuth(@NotNull ClientAuth clientAuth) {
            Builder this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)clientAuth), (String)"clientAuth");
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.clientAuth = clientAuth;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder2));
        }

        @NotNull
        public final URI getTokenURI$jetbrains_jetpass_client_oauth2() {
            return this.tokenURI;
        }

        protected Builder(@NotNull Client client, @NotNull URI tokenURI) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)tokenURI, (String)"tokenURI");
            super(client);
            this.tokenURI = tokenURI;
            this.clientAuth = ClientAuth.HEADER;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;", "", "(Ljava/lang/String;I)V", "HEADER", "FORM", "jetbrains.jetpass.client.oauth2"})
    public static final class ClientAuth
    extends Enum<ClientAuth> {
        public static final /* enum */ ClientAuth HEADER;
        public static final /* enum */ ClientAuth FORM;
        private static final /* synthetic */ ClientAuth[] $VALUES;

        static {
            ClientAuth[] clientAuthArray = new ClientAuth[2];
            ClientAuth[] clientAuthArray2 = clientAuthArray;
            clientAuthArray[0] = HEADER = new ClientAuth();
            clientAuthArray[1] = FORM = new ClientAuth();
            $VALUES = clientAuthArray;
        }

        public static ClientAuth[] values() {
            return (ClientAuth[])$VALUES.clone();
        }

        public static ClientAuth valueOf(String string) {
            return Enum.valueOf(ClientAuth.class, string);
        }
    }
}

