/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api.permissionCache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.dao.api.DAO;
import jetbrains.jetpass.dao.api.ServiceDAO;
import jetbrains.jetpass.dao.api.authority.ProjectTeamDAO;
import jetbrains.jetpass.dao.api.authority.UserDAO;
import jetbrains.jetpass.dao.api.authority.UserGroupDAO;
import jetbrains.jetpass.dao.api.permissionCache.AuthorityHolderPermissionQuery;
import jetbrains.jetpass.dao.api.permissionCache.CalculationContext;
import jetbrains.jetpass.dao.api.permissionCache.DataEntry;
import jetbrains.jetpass.dao.api.permissionCache.Handler;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCache;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCacheImpl;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCacheInterners;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCacheListener;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCalculator;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.api.permissionCache.PrivilegedRunner;
import jetbrains.jetpass.dao.api.permissionCache.ProjectIDComparator;
import jetbrains.jetpass.dao.api.permissionCache.ServicePermissionQuery;
import jetbrains.jetpass.dao.api.permissionCache.data.PermissionData;
import jetbrains.jetpass.dao.api.permissionCache.data.PermissionDataBuilder;
import jetbrains.jetpass.dao.api.permissionCache.filter.AllowedPermissionFilter;
import jetbrains.jetpass.dao.api.permissionCache.filter.AllowedPermissionFilters;
import jetbrains.jetpass.dao.api.security.PermissionDAO;
import jetbrains.jetpass.dao.api.security.ProjectDAO;
import jetbrains.jetpass.dao.api.security.ResourceDAO;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 k2\u00020\u0001:\u0001kBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\"H\u0016J!\u0010=\u001a\u0002H>\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0@H\u0002\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020;H\u0002J\u0018\u0010C\u001a\n D*\u0004\u0018\u000101012\u0006\u0010E\u001a\u00020\u0016H\u0002J\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010K\u001a\u00020J2\u0006\u0010L\u001a\u00020G2\u0006\u0010M\u001a\u00020NH\u0002J$\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020G2\b\u0010M\u001a\u0004\u0018\u00010N2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J$\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020G2\b\u0010M\u001a\u0004\u0018\u00010N2\b\u0010S\u001a\u0004\u0018\u00010TH\u0016J\b\u0010U\u001a\u00020;H\u0016J\u0010\u0010V\u001a\u00020;2\u0006\u0010E\u001a\u00020\u0016H\u0016J\u0018\u0010W\u001a\u00020G2\u0006\u0010X\u001a\u00020\u00162\u0006\u0010Y\u001a\u00020JH\u0016J\b\u0010Z\u001a\u00020;H\u0016J\u0018\u0010[\u001a\u00020G2\u0006\u0010\\\u001a\u00020\u00162\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010]\u001a\u00020G2\u0006\u0010E\u001a\u00020\u00162\u0006\u0010I\u001a\u00020JH\u0016J;\u0010^\u001a\u00020\u001d\"\u0004\b\u0000\u0010_*\u000e\u0012\u0004\u0012\u0002H_\u0012\u0004\u0012\u00020\u001d0`2\u0006\u0010a\u001a\u0002H_2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0002\u00a2\u0006\u0002\u0010fJS\u0010P\u001a\u00020G\"\b\b\u0000\u0010>*\u00020c\"\u0004\b\u0001\u0010_*\u000e\u0012\u0004\u0012\u0002H_\u0012\u0004\u0012\u00020\u001d0`2\u0006\u0010a\u001a\u0002H_2\u0006\u0010g\u001a\u00020\u00162\f\u0010h\u001a\b\u0012\u0004\u0012\u0002H>0i2\u0006\u0010I\u001a\u00020JH\u0002\u00a2\u0006\u0002\u0010jR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001a\u001a\u0004\b*\u0010+R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002010\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R&\u00105\u001a\u0002042\u0006\u00103\u001a\u0002048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006l"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/PermissionCacheImpl;", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;", "userDAO", "Ljetbrains/jetpass/dao/api/authority/UserDAO;", "groupDAO", "Ljetbrains/jetpass/dao/api/authority/UserGroupDAO;", "projectTeamDAO", "Ljetbrains/jetpass/dao/api/authority/ProjectTeamDAO;", "serviceDAO", "Ljetbrains/jetpass/dao/api/ServiceDAO;", "projectDAO", "Ljetbrains/jetpass/dao/api/security/ProjectDAO;", "resourceDAO", "Ljetbrains/jetpass/dao/api/security/ResourceDAO;", "permissionDAO", "Ljetbrains/jetpass/dao/api/security/PermissionDAO;", "privilegedRunner", "Ljetbrains/jetpass/dao/api/permissionCache/PrivilegedRunner;", "allowedPermissionFilters", "Ljetbrains/jetpass/dao/api/permissionCache/filter/AllowedPermissionFilters;", "(Ljetbrains/jetpass/dao/api/authority/UserDAO;Ljetbrains/jetpass/dao/api/authority/UserGroupDAO;Ljetbrains/jetpass/dao/api/authority/ProjectTeamDAO;Ljetbrains/jetpass/dao/api/ServiceDAO;Ljetbrains/jetpass/dao/api/security/ProjectDAO;Ljetbrains/jetpass/dao/api/security/ResourceDAO;Ljetbrains/jetpass/dao/api/security/PermissionDAO;Ljetbrains/jetpass/dao/api/permissionCache/PrivilegedRunner;Ljetbrains/jetpass/dao/api/permissionCache/filter/AllowedPermissionFilters;)V", "globalProjectUUID", "", "getGlobalProjectUUID", "()Ljava/lang/String;", "globalProjectUUID$delegate", "Lkotlin/Lazy;", "groupPermissions", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljetbrains/jetpass/dao/api/permissionCache/DataEntry;", "interners", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCacheInterners;", "listeners", "Ljava/util/ArrayList;", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCacheListener;", "Lkotlin/collections/ArrayList;", "getListeners", "()Ljava/util/ArrayList;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "permissionCalculator", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCalculator;", "getPermissionCalculator", "()Ljetbrains/jetpass/dao/api/permissionCache/PermissionCalculator;", "permissionCalculator$delegate", "projectIDComparator", "Ljetbrains/jetpass/dao/api/permissionCache/ProjectIDComparator;", "projectTeamPermissions", "userHandles", "Ljetbrains/jetpass/dao/api/permissionCache/Handler;", "userPermissions", "<set-?>", "", "version", "getVersion", "()J", "setVersion", "(J)V", "addListener", "", "listener", "evalPrivileged", "T", "privilegedCode", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "fireCacheCalculated", "getUserHandle", "kotlin.jvm.PlatformType", "userUUID", "group", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionQuery;", "userGroupUUID", "acceptDirty", "", "hasGlobalPermission", "permissionQuery", "permission", "Ljetbrains/jetpass/api/security/Permission;", "hasPermission", "query", "project", "Ljetbrains/jetpass/api/security/Project;", "resource", "Ljetbrains/jetpass/api/security/Resource;", "init", "invalidateUserHandle", "service", "serviceUUID", "dirty", "setDirty", "team", "teamUUID", "user", "getOrCalculate", "K", "Ljava/util/concurrent/ConcurrentMap;", "key", "principal", "Ljetbrains/jetpass/api/authority/AuthorityHolder;", "context", "Ljetbrains/jetpass/dao/api/permissionCache/CalculationContext;", "(Ljava/util/concurrent/ConcurrentMap;Ljava/lang/Object;Ljetbrains/jetpass/api/authority/AuthorityHolder;Ljetbrains/jetpass/dao/api/permissionCache/CalculationContext;)Ljetbrains/jetpass/dao/api/permissionCache/DataEntry;", "principalUUID", "dao", "Ljetbrains/jetpass/dao/api/DAO;", "(Ljava/util/concurrent/ConcurrentMap;Ljava/lang/Object;Ljava/lang/String;Ljetbrains/jetpass/dao/api/DAO;Z)Ljetbrains/jetpass/dao/api/permissionCache/PermissionQuery;", "Companion", "jetbrains.jetpass.dao"})
public class PermissionCacheImpl
implements PermissionCache {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final PermissionCacheInterners interners;
    private final ProjectIDComparator projectIDComparator;
    private final Lazy globalProjectUUID$delegate;
    private final Lazy permissionCalculator$delegate;
    private volatile ConcurrentHashMap<String, Handler> userHandles;
    private volatile ConcurrentHashMap<Handler, DataEntry> userPermissions;
    private volatile ConcurrentHashMap<String, DataEntry> groupPermissions;
    private volatile ConcurrentHashMap<String, DataEntry> projectTeamPermissions;
    private volatile long version;
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final ArrayList<PermissionCacheListener> listeners;
    private final UserDAO userDAO;
    private final UserGroupDAO groupDAO;
    private final ProjectTeamDAO projectTeamDAO;
    private final ServiceDAO serviceDAO;
    private final ProjectDAO projectDAO;
    private final ResourceDAO resourceDAO;
    private final PermissionDAO permissionDAO;
    private final PrivilegedRunner privilegedRunner;
    private final AllowedPermissionFilters allowedPermissionFilters;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PermissionCacheImpl.class), "globalProjectUUID", "getGlobalProjectUUID()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PermissionCacheImpl.class), "permissionCalculator", "getPermissionCalculator()Ljetbrains/jetpass/dao/api/permissionCache/PermissionCalculator;"))};
        Companion = new Companion(null);
    }

    private final String getGlobalProjectUUID() {
        Lazy lazy = this.globalProjectUUID$delegate;
        PermissionCacheImpl permissionCacheImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    private final PermissionCalculator getPermissionCalculator() {
        Lazy lazy = this.permissionCalculator$delegate;
        PermissionCacheImpl permissionCacheImpl = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (PermissionCalculator)lazy.getValue();
    }

    @Override
    public final long getVersion() {
        return this.version;
    }

    private final void setVersion(long l) {
        this.version = l;
    }

    @NotNull
    public final ArrayList<PermissionCacheListener> getListeners() {
        return this.listeners;
    }

    @Override
    @NotNull
    public PermissionQuery user(@NotNull String userUUID, boolean acceptDirty) {
        Intrinsics.checkParameterIsNotNull((Object)userUUID, (String)"userUUID");
        return this.query((ConcurrentMap)this.userPermissions, this.getUserHandle(userUUID), userUUID, this.userDAO, acceptDirty);
    }

    @Override
    @NotNull
    public PermissionQuery group(@NotNull String userGroupUUID, boolean acceptDirty) {
        Intrinsics.checkParameterIsNotNull((Object)userGroupUUID, (String)"userGroupUUID");
        return this.query((ConcurrentMap)this.groupPermissions, userGroupUUID, userGroupUUID, this.groupDAO, acceptDirty);
    }

    @Override
    @NotNull
    public PermissionQuery team(@NotNull String teamUUID, boolean acceptDirty) {
        Intrinsics.checkParameterIsNotNull((Object)teamUUID, (String)"teamUUID");
        return this.query((ConcurrentMap)this.projectTeamPermissions, teamUUID, teamUUID, this.projectTeamDAO, acceptDirty);
    }

    @Override
    @NotNull
    public PermissionQuery service(@NotNull String serviceUUID, boolean dirty) {
        Intrinsics.checkParameterIsNotNull((Object)serviceUUID, (String)"serviceUUID");
        return (PermissionQuery)this.evalPrivileged((Function0)new Function0<ServicePermissionQuery>(this, serviceUUID){
            final /* synthetic */ PermissionCacheImpl this$0;
            final /* synthetic */ String $serviceUUID;

            @NotNull
            public final ServicePermissionQuery invoke() {
                return ServicePermissionQuery.Companion.create(PermissionCacheImpl.access$getServiceDAO$p(this.this$0), this.$serviceUUID, PermissionCacheImpl.access$getProjectDAO$p(this.this$0), PermissionCacheImpl.access$getPermissionDAO$p(this.this$0));
            }
            {
                this.this$0 = permissionCacheImpl;
                this.$serviceUUID = string;
                super(0);
            }
        });
    }

    private final <T extends AuthorityHolder, K> PermissionQuery query(@NotNull ConcurrentMap<K, DataEntry> $receiver, K key, String principalUUID, DAO<T> dao, boolean acceptDirty) {
        return (PermissionQuery)this.evalPrivileged((Function0)new Function0<AuthorityHolderPermissionQuery>(this, $receiver, principalUUID, acceptDirty, dao, key){
            final /* synthetic */ PermissionCacheImpl this$0;
            final /* synthetic */ ConcurrentMap receiver$0;
            final /* synthetic */ String $principalUUID;
            final /* synthetic */ boolean $acceptDirty;
            final /* synthetic */ DAO $dao;
            final /* synthetic */ Object $key;

            @NotNull
            public final AuthorityHolderPermissionQuery invoke() {
                PermissionCacheImpl.Companion.getLogger().debug((Function0)new Function0<String>(this){
                    final /* synthetic */ query.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return "Getting permissions for principal " + this.this$0.$principalUUID + ", accept dirty: " + this.this$0.$acceptDirty;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                long curVersion = this.this$0.getVersion();
                AuthorityHolder principal = (AuthorityHolder)jetbrains.jetpass.dao.api.permissionCache.PermissionCacheImpl$Companion.access$toPrincipal(PermissionCacheImpl.Companion, this.$dao, this.$principalUUID);
                AllowedPermissionFilters allowedPermissionFilters = PermissionCacheImpl.access$getAllowedPermissionFilters$p(this.this$0);
                List<AllowedPermissionFilter> allowedPermissionFilter = allowedPermissionFilters != null ? allowedPermissionFilters.getFilters(principal) : null;
                PermissionData permissionData = PermissionCacheImpl.access$getOrCalculate(this.this$0, this.receiver$0, this.$key, principal, new CalculationContext(this.$acceptDirty ? 0L : curVersion, curVersion)).getData();
                if (permissionData == null) {
                    Intrinsics.throwNpe();
                }
                return new AuthorityHolderPermissionQuery(permissionData, PermissionCacheImpl.access$getGlobalProjectUUID$p(this.this$0), PermissionCacheImpl.access$getProjectIDComparator$p(this.this$0), (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(allowedPermissionFilter){
                    final /* synthetic */ List $allowedPermissionFilter;

                    public final boolean invoke(@NotNull String permission) {
                        boolean bl;
                        block5: {
                            Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                            List list2 = this.$allowedPermissionFilter;
                            if (list2 != null) {
                                Iterable $receiver$iv = list2;
                                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (T element$iv : $receiver$iv) {
                                        AllowedPermissionFilter it = (AllowedPermissionFilter)element$iv;
                                        if (it.isPermissionAllowed(permission)) continue;
                                        bl = false;
                                        break block5;
                                    }
                                    bl = true;
                                }
                            } else {
                                bl = true;
                            }
                        }
                        return bl;
                    }
                    {
                        this.$allowedPermissionFilter = list2;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = permissionCacheImpl;
                this.receiver$0 = concurrentMap;
                this.$principalUUID = string;
                this.$acceptDirty = bl;
                this.$dao = dAO;
                this.$key = object;
                super(0);
            }
        });
    }

    @Override
    public boolean hasPermission(@NotNull PermissionQuery query2, @Nullable Permission permission, @Nullable Project project) {
        Object object;
        block7: {
            PermissionQuery permissionQuery;
            block6: {
                Project project2;
                Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
                Permission permission2 = permission;
                CharSequence charSequence = permission2 != null ? permission2.getId() : null;
                if (charSequence == null || charSequence.length() == 0) {
                    return false;
                }
                Permission permission3 = permission;
                if (permission3 == null) {
                    Intrinsics.throwNpe();
                }
                String string = permission3.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"permission!!.id");
                permissionQuery = query2.withPermission(string);
                if (this.hasGlobalPermission(permissionQuery, permission)) {
                    return true;
                }
                object = project;
                if (object == null) break block6;
                Project it = project2 = object;
                object = permissionQuery.toProject(project.getId());
                if (object != null) break block7;
            }
            object = permissionQuery.toGlobalProject();
        }
        Object projectQuery = object;
        return projectQuery.canAccess();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasPermission(@NotNull PermissionQuery query2, @Nullable Permission permission, @Nullable Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        Permission permission2 = permission;
        CharSequence charSequence = permission2 != null ? permission2.getId() : null;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        Permission permission3 = permission;
        if (permission3 == null) {
            Intrinsics.throwNpe();
        }
        String string = permission3.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"permission!!.id");
        PermissionQuery permissionQuery = query2.withPermission(string);
        if (this.hasGlobalPermission(permissionQuery, permission)) {
            return true;
        }
        if (resource != null) {
            void $receiver$iv;
            Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])new Resource[]{(Resource)this.resourceDAO.get(resource.getId())})), (Function1)((Function1)new Function1<Resource, Boolean>(query2){
                final /* synthetic */ PermissionQuery $query;

                public final boolean invoke(@NotNull Resource it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Project project = it.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it.project");
                    return this.$query.toProject(project.getId()).canAccess();
                }
                {
                    this.$query = permissionQuery;
                    super(1);
                }
            }));
            Iterator iterator2 = $receiver$iv.iterator();
            if (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Resource it = (Resource)element$iv;
                return true;
            }
        }
        return query2.toGlobalProject().canAccess();
    }

    private final boolean hasGlobalPermission(PermissionQuery permissionQuery, Permission permission) {
        Boolean bl = permission.isGlobal();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"permission.isGlobal");
        return bl != false && permissionQuery.canAccess();
    }

    @Override
    public void init() {
        this.evalPrivileged((Function0)new Function0<Unit>(this){
            final /* synthetic */ PermissionCacheImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                long myVersion = this.this$0.getVersion();
                double globalTime = System.nanoTime();
                PermissionCacheImpl.Companion.getLogger().info((Function0)new Function0<String>(myVersion){
                    final /* synthetic */ long $myVersion;

                    @NotNull
                    public final String invoke() {
                        return "Start recalculating permissions cache [" + this.$myVersion + ']';
                    }
                    {
                        this.$myVersion = l;
                        super(0);
                    }
                });
                CalculationContext context = new CalculationContext(myVersion, myVersion);
                try {
                    ReentrantReadWriteLock.ReadLock readLock;
                    Map map;
                    Object object;
                    Map map2;
                    String key;
                    AuthorityHolder it;
                    Function0<Unit> checkOutdated$ = new Function0<Unit>(this, myVersion){
                        final /* synthetic */ init.1 this$0;
                        final /* synthetic */ long $myVersion;

                        public final void invoke() {
                            if (this.this$0.this$0.getVersion() > this.$myVersion) {
                                throw (Throwable)new CancellationException();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$myVersion = l;
                            super(0);
                        }
                    };
                    HashMap<K, V> newGroupPermissionsTemp = new HashMap<K, V>();
                    HashMap<K, V> newProjectTeamPermissionsTemp = new HashMap<K, V>();
                    HashMap<K, V> newUserPermissionsTemp = new HashMap<K, V>();
                    jetbrains.jetpass.sequence.Sequence<T> sequence = PermissionCacheImpl.access$getGroupDAO$p(this.this$0).getAllItems();
                    Intrinsics.checkExpressionValueIsNotNull(sequence, (String)"groupDAO.allItems");
                    Iterable $receiver$iv = sequence;
                    for (T element$iv : $receiver$iv) {
                        it = (UserGroup)element$iv;
                        UserGroup userGroup = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)userGroup, (String)"it");
                        key = userGroup.getId();
                        map2 = newGroupPermissionsTemp;
                        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
                        object = PermissionCacheImpl.access$getOrCalculate(this.this$0, PermissionCacheImpl.access$getGroupPermissions$p(this.this$0), key, it, context);
                        map2.put(map, object);
                        checkOutdated$.invoke();
                    }
                    jetbrains.jetpass.sequence.Sequence<T> sequence2 = PermissionCacheImpl.access$getProjectTeamDAO$p(this.this$0).getAllItems();
                    Intrinsics.checkExpressionValueIsNotNull(sequence2, (String)"projectTeamDAO.allItems");
                    $receiver$iv = sequence2;
                    for (T element$iv : $receiver$iv) {
                        AuthorityHolder authorityHolder = it = (ProjectTeam)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)authorityHolder, (String)"it");
                        key = authorityHolder.getId();
                        map2 = newProjectTeamPermissionsTemp;
                        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
                        object = PermissionCacheImpl.access$getOrCalculate(this.this$0, PermissionCacheImpl.access$getProjectTeamPermissions$p(this.this$0), key, it, context);
                        map2.put(map, object);
                        checkOutdated$.invoke();
                    }
                    Collection<V> collection = PermissionCacheImpl.access$getUserHandles$p(this.this$0).values();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"userHandles.values");
                    $receiver$iv = collection;
                    for (T element$iv : $receiver$iv) {
                        DataEntry dataEntry;
                        Handler handle = (Handler)element$iv;
                        if ((DataEntry)PermissionCacheImpl.access$getUserPermissions$p(this.this$0).get(handle) == null) continue;
                        DataEntry it2 = readLock;
                        map = newUserPermissionsTemp;
                        Intrinsics.checkExpressionValueIsNotNull((Object)handle, (String)"handle");
                        Intrinsics.checkExpressionValueIsNotNull((Object)it2, (String)"it");
                        map.put(object, dataEntry);
                    }
                    checkOutdated$.invoke();
                    ConcurrentHashMap<K, V> newGroupPermissions = new ConcurrentHashMap<K, V>(newGroupPermissionsTemp);
                    checkOutdated$.invoke();
                    ConcurrentHashMap<K, V> newProjectTeamPermissions = new ConcurrentHashMap<K, V>(newProjectTeamPermissionsTemp);
                    checkOutdated$.invoke();
                    ConcurrentHashMap<K, V> newUserPermissions = new ConcurrentHashMap<K, V>(newUserPermissionsTemp);
                    checkOutdated$.invoke();
                    ReentrantReadWriteLock reentrantReadWriteLock = PermissionCacheImpl.access$getLock$p(this.this$0);
                    readLock = reentrantReadWriteLock.readLock();
                    readLock.lock();
                    try {
                        checkOutdated$.invoke();
                        PermissionCacheImpl.access$setGroupPermissions$p(this.this$0, newGroupPermissions);
                        PermissionCacheImpl.access$setProjectTeamPermissions$p(this.this$0, newProjectTeamPermissions);
                        PermissionCacheImpl.access$setUserPermissions$p(this.this$0, newUserPermissions);
                        map2 = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    PermissionCacheImpl.Companion.getLogger().info((Function0)new Function0<String>(this, myVersion, globalTime){
                        final /* synthetic */ init.1 this$0;
                        final /* synthetic */ long $myVersion;
                        final /* synthetic */ double $globalTime;

                        @NotNull
                        public final String invoke() {
                            return "Finish recalculating permissions cache [" + this.$myVersion + "] in: " + ((double)System.nanoTime() - this.$globalTime) / (double)1000000000 + "s, total user clusters: " + ((ConcurrentHashMap.KeySetView)PermissionCacheImpl.access$getUserPermissions$p(this.this$0.this$0).keySet()).size();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$myVersion = l;
                            this.$globalTime = d;
                            super(0);
                        }
                    });
                    PermissionCacheImpl.access$fireCacheCalculated(this.this$0);
                }
                catch (CancellationException e) {
                    PermissionCacheImpl.Companion.getLogger().info((Function0)new Function0<String>(myVersion, globalTime){
                        final /* synthetic */ long $myVersion;
                        final /* synthetic */ double $globalTime;

                        @NotNull
                        public final String invoke() {
                            return "Interrupt permissions cache calculation [" + this.$myVersion + "] after: " + ((double)System.nanoTime() - this.$globalTime) / (double)1000000000 + 's';
                        }
                        {
                            this.$myVersion = l;
                            this.$globalTime = d;
                            super(0);
                        }
                    });
                }
            }
            {
                this.this$0 = permissionCacheImpl;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirty() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            long l = this.version;
            this.version = l + 1L;
            long l2 = l;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    public void addListener(@NotNull PermissionCacheListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    private final <T> T evalPrivileged(Function0<? extends T> privilegedCode) {
        Object object = this.privilegedRunner;
        if (object == null || (object = object.eval(privilegedCode)) == null) {
            object = privilegedCode.invoke();
        }
        return (T)object;
    }

    private final void fireCacheCalculated() {
        Iterable $receiver$iv = this.listeners;
        for (Object element$iv : $receiver$iv) {
            PermissionCacheListener listener = (PermissionCacheListener)element$iv;
            listener.cacheCalculated(this);
        }
    }

    @Override
    public void invalidateUserHandle(@NotNull String userUUID) {
        Intrinsics.checkParameterIsNotNull((Object)userUUID, (String)"userUUID");
        this.userHandles.remove(userUUID);
    }

    private final Handler getUserHandle(String userUUID) {
        ConcurrentMap $receiver$iv = this.userHandles;
        Object object = $receiver$iv.get(userUUID);
        if (object == null) {
            Handler handler = (Handler)this.evalPrivileged((Function0)new Function0<Handler>(this, userUUID){
                final /* synthetic */ PermissionCacheImpl this$0;
                final /* synthetic */ String $userUUID$inlined;
                {
                    this.this$0 = permissionCacheImpl;
                    this.$userUUID$inlined = string;
                    super(0);
                }

                @NotNull
                public final Handler invoke() {
                    Handler handler;
                    IdItem idItem = jetbrains.jetpass.dao.api.permissionCache.PermissionCacheImpl$Companion.access$toPrincipal(PermissionCacheImpl.Companion, PermissionCacheImpl.access$getUserDAO$p(this.this$0), this.$userUUID$inlined);
                    Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"toPrincipal(userDAO, userUUID)");
                    Handler $receiver = handler = new Handler((User)idItem);
                    $receiver.intern(PermissionCacheImpl.access$getInterners$p(this.this$0));
                    return handler;
                }
            });
            Handler default$iv = handler;
            object = $receiver$iv.putIfAbsent(userUUID, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (Handler)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <K> DataEntry getOrCalculate(@NotNull ConcurrentMap<K, DataEntry> $receiver, K key, AuthorityHolder principal, CalculationContext context) {
        Object v;
        block24: {
            void this_$iv;
            DataEntry $receiver2;
            DataEntry dataEntry;
            ConcurrentMap<K, DataEntry> $receiver$iv = $receiver;
            Object object = $receiver$iv.get(key);
            if (object == null) {
                DataEntry default$iv;
                if (key instanceof Handler) {
                    ((Handler)key).intern(this.interners);
                }
                if ((object = $receiver$iv.putIfAbsent(key, default$iv = (dataEntry = new DataEntry()))) == null) {
                    object = default$iv;
                }
            }
            v = object;
            dataEntry = $receiver2 = (DataEntry)v;
            CalculationContext context$iv = context;
            if (context$iv.getMinVersion() < 0L || context$iv.getCurVersion() < context$iv.getMinVersion()) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (DataEntry.access$getVersion$p((DataEntry)this_$iv) < context$iv.getMinVersion()) {
                Object object2;
                long versionInCalculationValue$iv;
                do {
                    if ((versionInCalculationValue$iv = DataEntry.access$getVersionInCalculation$p((DataEntry)this_$iv)) < context$iv.getMinVersion()) continue;
                    DataEntry.access$awaitCalculation((DataEntry)this_$iv, context$iv);
                    break block24;
                } while (!DataEntry.access$getVersionInCalculationUpdater$cp().compareAndSet(this_$iv, versionInCalculationValue$iv, context$iv.getMinVersion()));
                void this_$iv$iv = this_$iv;
                try {
                    PermissionData it$iv$iv;
                    PermissionData permissionData;
                    AuthorityHolder it;
                    PermissionDataBuilder permissionDataBuilder;
                    IdItem it$iv;
                    Object element$iv$iv;
                    void principal$iv;
                    void this_$iv2;
                    void version$iv;
                    PermissionDataBuilder permissionDataBuilder2;
                    PermissionCalculator permissionCalculator2 = this.getPermissionCalculator();
                    AuthorityHolder authorityHolder = principal;
                    long l = context.getCurVersion();
                    PermissionDataBuilder $receiver$iv2 = permissionDataBuilder2 = new PermissionDataBuilder((long)version$iv);
                    Object $receiver$iv$iv = PermissionCalculator.access$getGroups$p((PermissionCalculator)this_$iv2, (AuthorityHolder)principal$iv);
                    Iterator iterator2 = $receiver$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv$iv = iterator2.next();
                        UserGroup userGroup = it$iv = (UserGroup)element$iv$iv;
                        permissionDataBuilder = $receiver$iv2;
                        if (this.getOrCalculate((ConcurrentMap)this.groupPermissions, it.getId(), it, context).getData() == null) {
                            Intrinsics.throwNpe();
                        }
                        permissionDataBuilder.add(permissionData);
                    }
                    $receiver$iv$iv = PermissionCalculator.access$getProjectTeams$p((PermissionCalculator)this_$iv2, (AuthorityHolder)principal$iv);
                    iterator2 = $receiver$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv$iv = iterator2.next();
                        it$iv = (ProjectTeam)element$iv$iv;
                        it = it$iv;
                        permissionDataBuilder = $receiver$iv2;
                        if (this.getOrCalculate((ConcurrentMap)this.projectTeamPermissions, it.getId(), it, context).getData() == null) {
                            Intrinsics.throwNpe();
                        }
                        permissionDataBuilder.add(permissionData);
                    }
                    Iterable<? extends ProjectRole> iterable = principal$iv.getProjectRoles();
                    if (iterable != null) {
                        $receiver$iv$iv = iterable;
                        iterator2 = $receiver$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv$iv = iterator2.next();
                            IdItem idItem = it$iv = (ProjectRole)element$iv$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"it");
                            PermissionCalculator.access$addProjectRole((PermissionCalculator)this_$iv2, $receiver$iv2, (ProjectRole)idItem);
                        }
                    }
                    if ((it$iv$iv = (object2 = permissionDataBuilder2.build())).getVersion() < context$iv.getMinVersion()) {
                        throw (Throwable)new IllegalStateException();
                    }
                }
                catch (Throwable e$iv$iv) {
                    if (DataEntry.access$getVersionInCalculationUpdater$cp().compareAndSet(this_$iv$iv, context$iv.getMinVersion(), -1L)) {
                        Lock lock = DataEntry.access$getLock$p((DataEntry)this_$iv$iv);
                        lock.lock();
                        try {
                            DataEntry.access$getUpdated$p((DataEntry)this_$iv$iv).signalAll();
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    throw e$iv$iv;
                }
                PermissionData newData$iv$iv = object2;
                if (newData$iv$iv.getVersion() > DataEntry.access$getVersion$p((DataEntry)this_$iv$iv)) {
                    object2 = DataEntry.access$getLock$p((DataEntry)this_$iv$iv);
                    object2.lock();
                    try {
                        if (newData$iv$iv.getVersion() > DataEntry.access$getVersion$p((DataEntry)this_$iv$iv)) {
                            DataEntry.access$setData$p((DataEntry)this_$iv$iv, newData$iv$iv);
                            DataEntry.access$getUpdated$p((DataEntry)this_$iv$iv).signalAll();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        object2.unlock();
                    }
                }
            }
        }
        return (DataEntry)v;
    }

    public PermissionCacheImpl(@NotNull UserDAO userDAO, @NotNull UserGroupDAO groupDAO, @NotNull ProjectTeamDAO projectTeamDAO, @NotNull ServiceDAO serviceDAO, @NotNull ProjectDAO projectDAO, @NotNull ResourceDAO resourceDAO, @NotNull PermissionDAO permissionDAO, @Nullable PrivilegedRunner privilegedRunner, @Nullable AllowedPermissionFilters allowedPermissionFilters) {
        Intrinsics.checkParameterIsNotNull((Object)userDAO, (String)"userDAO");
        Intrinsics.checkParameterIsNotNull((Object)groupDAO, (String)"groupDAO");
        Intrinsics.checkParameterIsNotNull((Object)projectTeamDAO, (String)"projectTeamDAO");
        Intrinsics.checkParameterIsNotNull((Object)serviceDAO, (String)"serviceDAO");
        Intrinsics.checkParameterIsNotNull((Object)projectDAO, (String)"projectDAO");
        Intrinsics.checkParameterIsNotNull((Object)resourceDAO, (String)"resourceDAO");
        Intrinsics.checkParameterIsNotNull((Object)permissionDAO, (String)"permissionDAO");
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.projectTeamDAO = projectTeamDAO;
        this.serviceDAO = serviceDAO;
        this.projectDAO = projectDAO;
        this.resourceDAO = resourceDAO;
        this.permissionDAO = permissionDAO;
        this.privilegedRunner = privilegedRunner;
        this.allowedPermissionFilters = allowedPermissionFilters;
        this.interners = new PermissionCacheInterners();
        this.projectIDComparator = new ProjectIDComparator();
        this.globalProjectUUID$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PermissionCacheImpl this$0;

            @NotNull
            public final String invoke() {
                ProjectIDComparator projectIDComparator = PermissionCacheImpl.access$getProjectIDComparator$p(this.this$0);
                Project project = PermissionCacheImpl.access$getProjectDAO$p(this.this$0).getGlobal();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"projectDAO.global");
                return projectIDComparator.addProject(project);
            }
            {
                this.this$0 = permissionCacheImpl;
                super(0);
            }
        }));
        this.permissionCalculator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PermissionCalculator>(this){
            final /* synthetic */ PermissionCacheImpl this$0;

            @NotNull
            public final PermissionCalculator invoke() {
                String string = PermissionCacheImpl.access$getGlobalProjectUUID$p(this.this$0);
                UserGroup userGroup = PermissionCacheImpl.access$getGroupDAO$p(this.this$0).getRootUserGroup();
                Intrinsics.checkExpressionValueIsNotNull((Object)userGroup, (String)"groupDAO.rootUserGroup");
                return new PermissionCalculator(string, userGroup, PermissionCacheImpl.access$getProjectIDComparator$p(this.this$0), PermissionCacheImpl.access$getInterners$p(this.this$0));
            }
            {
                this.this$0 = permissionCacheImpl;
                super(0);
            }
        }));
        this.userHandles = new ConcurrentHashMap();
        this.userPermissions = new ConcurrentHashMap();
        this.groupPermissions = new ConcurrentHashMap();
        this.projectTeamPermissions = new ConcurrentHashMap();
        this.lock = new ReentrantReadWriteLock();
        this.listeners = new ArrayList();
    }

    @Override
    @NotNull
    public PermissionQuery user(@NotNull String userUUID) {
        Intrinsics.checkParameterIsNotNull((Object)userUUID, (String)"userUUID");
        return PermissionCache.DefaultImpls.user(this, userUUID);
    }

    @Override
    @NotNull
    public PermissionQuery group(@NotNull String userGroupUUID) {
        Intrinsics.checkParameterIsNotNull((Object)userGroupUUID, (String)"userGroupUUID");
        return PermissionCache.DefaultImpls.group(this, userGroupUUID);
    }

    @Override
    @NotNull
    public PermissionQuery team(@NotNull String teamUUID) {
        Intrinsics.checkParameterIsNotNull((Object)teamUUID, (String)"teamUUID");
        return PermissionCache.DefaultImpls.team(this, teamUUID);
    }

    @Override
    @NotNull
    public PermissionQuery service(@NotNull String serviceUUID) {
        Intrinsics.checkParameterIsNotNull((Object)serviceUUID, (String)"serviceUUID");
        return PermissionCache.DefaultImpls.service(this, serviceUUID);
    }

    @NotNull
    public static final /* synthetic */ ServiceDAO access$getServiceDAO$p(PermissionCacheImpl $this) {
        return $this.serviceDAO;
    }

    @NotNull
    public static final /* synthetic */ ProjectDAO access$getProjectDAO$p(PermissionCacheImpl $this) {
        return $this.projectDAO;
    }

    @NotNull
    public static final /* synthetic */ PermissionDAO access$getPermissionDAO$p(PermissionCacheImpl $this) {
        return $this.permissionDAO;
    }

    public static final /* synthetic */ long access$getVersion$p(PermissionCacheImpl $this) {
        return $this.version;
    }

    public static final /* synthetic */ void access$setVersion$p(PermissionCacheImpl $this, long l) {
        $this.version = l;
    }

    @Nullable
    public static final /* synthetic */ AllowedPermissionFilters access$getAllowedPermissionFilters$p(PermissionCacheImpl $this) {
        return $this.allowedPermissionFilters;
    }

    @NotNull
    public static final /* synthetic */ DataEntry access$getOrCalculate(PermissionCacheImpl $this, @NotNull ConcurrentMap $receiver, Object key, @NotNull AuthorityHolder principal, @NotNull CalculationContext context) {
        return $this.getOrCalculate($receiver, key, principal, context);
    }

    @NotNull
    public static final /* synthetic */ String access$getGlobalProjectUUID$p(PermissionCacheImpl $this) {
        return $this.getGlobalProjectUUID();
    }

    @NotNull
    public static final /* synthetic */ ProjectIDComparator access$getProjectIDComparator$p(PermissionCacheImpl $this) {
        return $this.projectIDComparator;
    }

    @NotNull
    public static final /* synthetic */ UserGroupDAO access$getGroupDAO$p(PermissionCacheImpl $this) {
        return $this.groupDAO;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getGroupPermissions$p(PermissionCacheImpl $this) {
        return $this.groupPermissions;
    }

    public static final /* synthetic */ void access$setGroupPermissions$p(PermissionCacheImpl $this, @NotNull ConcurrentHashMap concurrentHashMap) {
        $this.groupPermissions = concurrentHashMap;
    }

    @NotNull
    public static final /* synthetic */ ProjectTeamDAO access$getProjectTeamDAO$p(PermissionCacheImpl $this) {
        return $this.projectTeamDAO;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getProjectTeamPermissions$p(PermissionCacheImpl $this) {
        return $this.projectTeamPermissions;
    }

    public static final /* synthetic */ void access$setProjectTeamPermissions$p(PermissionCacheImpl $this, @NotNull ConcurrentHashMap concurrentHashMap) {
        $this.projectTeamPermissions = concurrentHashMap;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getUserHandles$p(PermissionCacheImpl $this) {
        return $this.userHandles;
    }

    public static final /* synthetic */ void access$setUserHandles$p(PermissionCacheImpl $this, @NotNull ConcurrentHashMap concurrentHashMap) {
        $this.userHandles = concurrentHashMap;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getUserPermissions$p(PermissionCacheImpl $this) {
        return $this.userPermissions;
    }

    public static final /* synthetic */ void access$setUserPermissions$p(PermissionCacheImpl $this, @NotNull ConcurrentHashMap concurrentHashMap) {
        $this.userPermissions = concurrentHashMap;
    }

    @NotNull
    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(PermissionCacheImpl $this) {
        return $this.lock;
    }

    public static final /* synthetic */ void access$fireCacheCalculated(PermissionCacheImpl $this) {
        $this.fireCacheCalculated();
    }

    @NotNull
    public static final /* synthetic */ UserDAO access$getUserDAO$p(PermissionCacheImpl $this) {
        return $this.userDAO;
    }

    @NotNull
    public static final /* synthetic */ PermissionCacheInterners access$getInterners$p(PermissionCacheImpl $this) {
        return $this.interners;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/PermissionCacheImpl$Companion;", "Lmu/KLogging;", "()V", "toPrincipal", "T", "Ljetbrains/jetpass/api/IdItem;", "dao", "Ljetbrains/jetpass/dao/api/DAO;", "principalUUID", "", "(Ljetbrains/jetpass/dao/api/DAO;Ljava/lang/String;)Ljetbrains/jetpass/api/IdItem;", "jetbrains.jetpass.dao"})
    public static final class Companion
    extends KLogging {
        private final <T extends IdItem> T toPrincipal(DAO<T> dao, String principalUUID) {
            T t = dao.get(principalUUID);
            if (t == null) {
                throw (Throwable)new IllegalStateException("Unknown principal " + principalUUID);
            }
            return t;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ IdItem access$toPrincipal(Companion $this, @NotNull DAO dao, @NotNull String principalUUID) {
            return $this.toPrincipal(dao, principalUUID);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

