/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import jetbrains.jetpass.api.authority.auth.TokenInfo;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.dao.api.authority.AuthorityHolderDAO;
import jetbrains.jetpass.dao.remote.api.RemoteAPI;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\nJ \u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/dao/remote/TokenService;", "", "treatEmptyTokenAsGuest", "", "api", "Ljetbrains/jetpass/dao/remote/api/RemoteAPI;", "(ZLjetbrains/jetpass/dao/remote/api/RemoteAPI;)V", "buildQuery", "Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery;", "userId", "", "serviceId", "checkToken", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "header", "checkTokenInfo", "Ljetbrains/jetpass/api/authority/auth/TokenInfo;", "hasPermission", "token", "permissionId", "resourceOrProjectId", "PermissionQuery", "jetbrains.jetpass.dao.remote"})
public final class TokenService {
    private final boolean treatEmptyTokenAsGuest;
    private final RemoteAPI api;

    @Deprecated(message="User checkTokenInfo() instead, it supports permanent tokens", replaceWith=@ReplaceWith(imports={}, expression="checkTokenInfo(header)"))
    @NotNull
    public final AccessToken checkToken(@Nullable String header2) throws InvalidTokenException {
        return this.api.getRequestValidator().getAccessToken(header2);
    }

    @NotNull
    public final TokenInfo checkTokenInfo(@Nullable String header2) throws InvalidTokenException {
        return this.api.getRequestValidator().getTokenInfo(header2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasPermission(@Nullable String token, @NotNull String permissionId, @NotNull String resourceOrProjectId) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
        Intrinsics.checkParameterIsNotNull((Object)resourceOrProjectId, (String)"resourceOrProjectId");
        try {
            void userId;
            Pair pair;
            CharSequence charSequence = token;
            if (!(charSequence == null || charSequence.length() == 0) && this.treatEmptyTokenAsGuest) {
                pair = new Pair((Object)this.api.getUserDAO().getGuest().getId(), null);
            } else {
                TokenInfo tokenInfo = this.checkTokenInfo(token);
                pair = new Pair((Object)tokenInfo.getUser(), (Object)tokenInfo.getClient());
            }
            Pair pair2 = pair;
            String string = (String)pair2.component1();
            String serviceId = (String)pair2.component2();
            bl = this.buildQuery((String)userId, serviceId).hasPermission(permissionId, resourceOrProjectId);
        }
        catch (InvalidTokenException e) {
            bl = false;
        }
        return bl;
    }

    private final PermissionQuery buildQuery(String userId, String serviceId) {
        if (userId != null) {
            return new PermissionQuery.DAO(userId, this.api, this.api.getUserDAO());
        }
        if (serviceId != null) {
            return new PermissionQuery.DAO(serviceId, this.api, this.api.getServiceDAO());
        }
        return new PermissionQuery.False();
    }

    public TokenService(boolean treatEmptyTokenAsGuest, @NotNull RemoteAPI api) {
        Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
        this.treatEmptyTokenAsGuest = treatEmptyTokenAsGuest;
        this.api = api;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery;", "", "()V", "hasPermission", "", "permissionId", "", "resourceOrProjectId", "DAO", "False", "Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery$DAO;", "Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery$False;", "jetbrains.jetpass.dao.remote"})
    private static abstract class PermissionQuery {
        public abstract boolean hasPermission(@NotNull String var1, @NotNull String var2);

        private PermissionQuery() {
        }

        public /* synthetic */ PermissionQuery(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery$DAO;", "Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery;", "authHolderId", "", "api", "Ljetbrains/jetpass/dao/remote/api/RemoteAPI;", "dao", "Ljetbrains/jetpass/dao/api/authority/AuthorityHolderDAO;", "(Ljava/lang/String;Ljetbrains/jetpass/dao/remote/api/RemoteAPI;Ljetbrains/jetpass/dao/api/authority/AuthorityHolderDAO;)V", "hasPermission", "", "permissionId", "resourceOrProjectId", "jetbrains.jetpass.dao.remote"})
        public static final class DAO
        extends PermissionQuery {
            private final String authHolderId;
            private final RemoteAPI api;
            private final AuthorityHolderDAO<?> dao;

            @Override
            public boolean hasPermission(@NotNull String permissionId, @NotNull String resourceOrProjectId) {
                Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
                Intrinsics.checkParameterIsNotNull((Object)resourceOrProjectId, (String)"resourceOrProjectId");
                Resource resource = (Resource)this.api.getResourceDAO().get(resourceOrProjectId);
                if (resource != null) {
                    return this.dao.hasPermission(this.authHolderId, (Permission)this.api.getPermissionDAO().get(permissionId), resource);
                }
                return this.dao.hasPermission(this.authHolderId, (Permission)this.api.getPermissionDAO().get(permissionId), (Project)this.api.getProjectDAO().get(resourceOrProjectId));
            }

            public DAO(@NotNull String authHolderId, @NotNull RemoteAPI api, @NotNull AuthorityHolderDAO<?> dao) {
                Intrinsics.checkParameterIsNotNull((Object)authHolderId, (String)"authHolderId");
                Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
                Intrinsics.checkParameterIsNotNull(dao, (String)"dao");
                super(null);
                this.authHolderId = authHolderId;
                this.api = api;
                this.dao = dao;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery$False;", "Ljetbrains/jetpass/dao/remote/TokenService$PermissionQuery;", "()V", "hasPermission", "", "permissionId", "", "resourceOrProjectId", "jetbrains.jetpass.dao.remote"})
        public static final class False
        extends PermissionQuery {
            @Override
            public boolean hasPermission(@NotNull String permissionId, @NotNull String resourceOrProjectId) {
                Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
                Intrinsics.checkParameterIsNotNull((Object)resourceOrProjectId, (String)"resourceOrProjectId");
                return false;
            }

            public False() {
                super(null);
            }
        }
    }
}

