/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote.api.authority;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.EndUserAgreementConsent;
import jetbrains.jetpass.api.authority.Profile;
import jetbrains.jetpass.api.authority.SshPublicKey;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.api.authority.auth.RefreshToken;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.totp.ApplicationPassword;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.authority.UserDAO;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.remote.api.RemoteAuthHolderNamedMutableDAO;
import jetbrains.jetpass.dao.remote.api.RemoteDAO;
import jetbrains.jetpass.dao.remote.api.authority.RemoteUserGroupDAO;
import jetbrains.jetpass.dao.remote.api.util.IdRemoteRelationEnd;
import jetbrains.jetpass.dao.remote.api.util.ItemRemoteRelationEnd;
import jetbrains.jetpass.dao.remote.api.util.RemoteRelationEnd;
import jetbrains.jetpass.rest.dto.ApplicationPasswordJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EndUserAgreementConsentJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermanentTokenJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.SshPublicKeyJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.Page;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020!H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010%\u001a\u00020\u001eH\u0016J\u001e\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0014J&\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020*2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020-0$H\u0014J\u001a\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u001e2\b\u00100\u001a\u0004\u0018\u00010\u001eH\u0014J\u0018\u00101\u001a\u00020/2\u0006\u0010+\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u001eH\u0014J\u0018\u00103\u001a\u00020/2\u0006\u0010+\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0004H\u0014J\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J \u00106\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0014J(\u00107\u001a\b\u0012\u0004\u0012\u00020\u0004082\n\u00109\u001a\u0006\u0012\u0002\b\u00030:2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0014J\b\u0010;\u001a\u00020\u0003H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001eH\u0016J\u001c\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0@0@2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u001eH\u0016J\u001a\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u001e2\b\u0010C\u001a\u0004\u0018\u00010\u001eH\u0016JW\u0010D\u001a\u00020\u00032\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00030F2\b\u0010G\u001a\u0004\u0018\u00010\u001e2\b\u0010H\u001a\u0004\u0018\u00010\u001e2\b\u0010B\u001a\u0004\u0018\u00010\u001e2\b\u0010I\u001a\u0004\u0018\u00010\u001e2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u0010L\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010MJ\u0010\u0010N\u001a\u00020/2\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u001eH\u0016J\u0018\u0010R\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0018\u0010S\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010T\u001a\u00020UH\u0016J\u0018\u0010V\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010W\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0018\u0010X\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010Y\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010Z\u001a\u00020[H\u0016J\u0018\u0010\\\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010]\u001a\u00020\u001eH\u0016J\u0018\u0010^\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010_\u001a\u00020\u001eH\u0016J\u0010\u0010`\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010a\u001a\u00020/H\u0016J\u0010\u0010b\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\u0003H\u0016J\u0018\u0010d\u001a\u00020e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010f\u001a\u00020eH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\b\u00a8\u0006g"}, d2={"Ljetbrains/jetpass/dao/remote/api/authority/RemoteUserDAO;", "Ljetbrains/jetpass/dao/api/authority/UserDAO;", "Ljetbrains/jetpass/dao/remote/api/RemoteAuthHolderNamedMutableDAO;", "Ljetbrains/jetpass/api/authority/User;", "Ljetbrains/jetpass/rest/dto/UserJSON;", "Ljetbrains/jetpass/client/accounts/Partial$User;", "client", "Ljetbrains/jetpass/client/accounts/UserClient;", "(Ljetbrains/jetpass/client/accounts/UserClient;)V", "getClient", "()Ljetbrains/jetpass/client/accounts/UserClient;", "setClient", "acceptEndUserAgreement", "Ljetbrains/jetpass/api/authority/EndUserAgreementConsent;", "addApplicationPassword", "Ljetbrains/jetpass/api/authority/totp/ApplicationPassword;", "user", "applicationPassword", "addFavoriteProject", "Ljetbrains/jetpass/api/security/Project;", "project", "addLicense", "Ljetbrains/jetpass/api/settings/LicenseSettings;", "license", "addPermanentToken", "Ljetbrains/jetpass/api/authority/auth/PermanentToken;", "permanentToken", "addSshPublicKey", "Ljetbrains/jetpass/api/authority/SshPublicKey;", "userID", "", "sshPublicKey", "addUserDetails", "Ljetbrains/jetpass/api/authority/details/UserDetails;", "userDetails", "createPartial", "Ljetbrains/jetpass/client/FieldPartial;", "fieldName", "doCreate", "json", "partial", "doCreateRole", "Ljetbrains/jetpass/rest/dto/ProjectRoleJSON;", "id", "roleJSON", "Ljetbrains/jetpass/client/accounts/Partial$ProjectRole;", "doDelete", "", "successor", "doDeleteRole", "roleId", "doUpdate", "change", "erasePersonalData", "fetchItem", "fetchPage", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "getGuest", "getPermissionQuery", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionQuery;", "authHolderId", "getPersonalData", "", "invite", "email", "baseUrl", "merge", "users", "", "login", "name", "jabber", "banned", "", "twoFactorAuthentication", "(Ljava/lang/Iterable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Ljetbrains/jetpass/api/authority/User;", "newEvent", "event", "Ljetbrains/jetpass/api/event/Event;", "newJSON", "removeApplicationPassword", "removeApprovedScope", "approvedScope", "Ljetbrains/jetpass/api/authority/auth/ApprovedScope;", "removeFavoriteProject", "removeLicense", "removePermanentToken", "removeRefreshToken", "refreshToken", "Ljetbrains/jetpass/api/authority/auth/RefreshToken;", "removeSshPublicKey", "fingerPrint", "removeUserDetails", "userDetailsID", "removeUserLocale", "revokeEndUserAgreementConsent", "toJSON", "item", "verifyContact", "Ljetbrains/jetpass/api/authority/Profile;", "profile", "jetbrains.jetpass.dao.remote"})
public final class RemoteUserDAO
extends RemoteAuthHolderNamedMutableDAO<User, UserJSON, Partial.User>
implements UserDAO {
    @NotNull
    private UserClient client;

    @Override
    @NotNull
    protected Page<UserJSON> fetchPage(@NotNull BaseFilter<?> filter2, @NotNull FieldPartial<Partial.User> partial) {
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getUserPage(filter2, partial);
    }

    @Override
    @Nullable
    protected UserJSON fetchItem(@NotNull String id, @NotNull FieldPartial<Partial.User> partial) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getUser(id, partial);
    }

    @Override
    @NotNull
    public FieldPartial<Partial.User> createPartial(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Partial<Partial.User> partial = Partial.user(new Partial.User(fieldName));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.user(Partial.User(fieldName))");
        return partial;
    }

    @Override
    @NotNull
    protected UserJSON doCreate(@NotNull UserJSON json, @NotNull FieldPartial<Partial.User> partial) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.createUser(json, partial);
    }

    @Override
    protected void doUpdate(@NotNull String id, @NotNull UserJSON change) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        this.client.updateUser(id, change);
    }

    @Override
    protected void doDelete(@NotNull String id, @Nullable String successor) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.client.deleteUser(id, successor);
    }

    @Override
    @NotNull
    public UserJSON toJSON(@NotNull User item2) {
        Intrinsics.checkParameterIsNotNull((Object)item2, (String)"item");
        return UserJSON.wrap(item2);
    }

    @Override
    @NotNull
    public UserJSON newJSON(@NotNull String id) {
        UserJSON userJSON;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        UserJSON $receiver = userJSON = new UserJSON();
        $receiver.setId(id);
        return userJSON;
    }

    @Override
    @NotNull
    public User invite(@NotNull String email, @Nullable String baseUrl) throws DataAccessException {
        UserJSON userJSON;
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        RemoteUserDAO $receiver$iv = this;
        String id$iv = null;
        try {
            List<UserJSON> list2 = this.client.invite(CollectionsKt.listOf((Object)email), null, baseUrl, (FieldPartial<Partial.User>)Partial.user(Partial.User.ID));
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"client.invite(listOf(ema\u2026al.user(Partial.User.ID))");
            userJSON = (UserJSON)CollectionsKt.first(list2);
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        UserJSON result$iv = userJSON;
        $receiver$iv.getRemoteAPI().syncNow();
        UserJSON invitedUser = result$iv;
        Object i = this.getNotNull(invitedUser.getId());
        Intrinsics.checkExpressionValueIsNotNull(i, (String)"getNotNull(invitedUser.id)");
        return (User)i;
    }

    @Override
    @NotNull
    public User invite(@NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        return this.invite(email, null);
    }

    @Override
    @NotNull
    protected ProjectRoleJSON doCreateRole(@NotNull String id, @NotNull ProjectRoleJSON roleJSON, @NotNull FieldPartial<Partial.ProjectRole> partial) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)roleJSON, (String)"roleJSON");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getProjectRolesClient(id).addProjectRole(roleJSON, partial);
    }

    @Override
    protected void doDeleteRole(@NotNull String id, @NotNull String roleId) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        this.client.getProjectRolesClient(id).removeProjectRole(roleId);
    }

    @Override
    @NotNull
    public User getGuest() {
        UserJSON guest = this.client.guest((FieldPartial<Partial.User>)Partial.user(Partial.User.ID));
        Object i = this.getNotNull(guest.getId());
        Intrinsics.checkExpressionValueIsNotNull(i, (String)"getNotNull(guest.id)");
        return (User)i;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UserDetails addUserDetails(@NotNull String userID, @NotNull UserDetails userDetails) throws DataAccessException {
        IdItem idItem;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        Intrinsics.checkParameterIsNotNull((Object)userDetails, (String)"userDetails");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getUserDetailsDAO();
        Function1 resolveResult$iv = null;
        ItemRemoteRelationEnd childEnd$iv = new ItemRemoteRelationEnd(childDAO$iv, userDetails);
        IdRemoteRelationEnd idRemoteRelationEnd = new IdRemoteRelationEnd(parentDAO$iv, userID);
        boolean checkChildExistence$iv$iv = false;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        Object childJSON$iv$iv = ((RemoteRelationEnd)childEnd$iv).toJSON();
        FieldPartial childIdPartial$iv$iv = ((RemoteRelationEnd)childEnd$iv).getDao().createPartial("id");
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void idPartial;
            void userDetailsJSON;
            FieldPartial fieldPartial = childIdPartial$iv$iv;
            DetailsJSON detailsJSON = (DetailsJSON)childJSON$iv$iv;
            String userId = parentId$iv$iv;
            idItem = this.client.getUserDetailsClient(userId).addUserDetail((DetailsJSON)userDetailsJSON, (FieldPartial<Partial.Details>)idPartial);
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        IdItem result$iv$iv$iv = idItem;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
        IdItem resultJSON$iv$iv = result$iv$iv$iv;
        RemoteRelationEnd remoteRelationEnd = childEnd$iv;
        String string = resultJSON$iv$iv.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultJSON.id");
        return (UserDetails)remoteRelationEnd.resolve(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeUserDetails(@NotNull String userID, @NotNull String userDetailsID) throws DataAccessException {
        Unit unit;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        Intrinsics.checkParameterIsNotNull((Object)userDetailsID, (String)"userDetailsID");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getUserDetailsDAO();
        IdRemoteRelationEnd idRemoteRelationEnd = new IdRemoteRelationEnd(parentDAO$iv, userID);
        RemoteRelationEnd childEnd$iv$iv = new IdRemoteRelationEnd(childDAO$iv, userDetailsID);
        String parentId$iv$iv = this_$iv$iv.checkExists();
        String childId$iv$iv = childEnd$iv$iv.checkExists();
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void userDetailsId;
            String string = childId$iv$iv;
            String userId = parentId$iv$iv;
            this.client.getUserDetailsClient(userId).removeUserDetail((String)userDetailsId);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        Unit result$iv$iv$iv = unit;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LicenseSettings addLicense(@NotNull User user, @NotNull LicenseSettings license) throws DataAccessException {
        IdItem idItem;
        void childEnd$iv$iv;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getSettingsDAO();
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, user);
        RemoteRelationEnd remoteRelationEnd = new ItemRemoteRelationEnd(childDAO$iv, license);
        boolean checkChildExistence$iv$iv = true;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        childEnd$iv$iv.checkExists();
        Object childJSON$iv$iv = childEnd$iv$iv.toJSON();
        FieldPartial childIdPartial$iv$iv = childEnd$iv$iv.getDao().createPartial("id");
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void settingsJSON;
            FieldPartial fieldPartial = childIdPartial$iv$iv;
            SettingsJSON settingsJSON2 = (SettingsJSON)childJSON$iv$iv;
            String userId = parentId$iv$iv;
            void v0 = settingsJSON;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.rest.dto.LicenseJSON");
            }
            idItem = this.client.getLicensesClient(userId).addLicense((LicenseJSON)v0, (FieldPartial<Partial.License>)Partial.license(Partial.License.ID));
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        IdItem result$iv$iv$iv = idItem;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
        IdItem resultJSON$iv$iv = result$iv$iv$iv;
        String string = resultJSON$iv$iv.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultJSON.id");
        Object i = childEnd$iv$iv.resolve(string);
        if (i == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.api.settings.LicenseSettings");
        }
        return (LicenseSettings)i;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeLicense(@NotNull User user, @NotNull LicenseSettings license) throws DataAccessException {
        Unit unit;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getSettingsDAO();
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, user);
        RemoteRelationEnd childEnd$iv$iv = new ItemRemoteRelationEnd(childDAO$iv, license);
        String parentId$iv$iv = this_$iv$iv.checkExists();
        String childId$iv$iv = childEnd$iv$iv.checkExists();
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void licenseId;
            String string = childId$iv$iv;
            String userId = parentId$iv$iv;
            this.client.getLicensesClient(userId).removeLicense((String)licenseId);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        Unit result$iv$iv$iv = unit;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public User merge(@NotNull Iterable<? extends User> users, @Nullable String login, @Nullable String name, @Nullable String email, @Nullable String jabber, @Nullable Boolean banned, @Nullable String twoFactorAuthentication) throws DataAccessException {
        IdItem idItem;
        void $receiver$iv$iv$iv;
        Collection $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(users, (String)"users");
        RemoteUserDAO $receiver$iv = this;
        Collection collection = $receiver$iv$iv = users;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv;
            IdItem idItem2 = (IdItem)item$iv$iv$iv;
            Collection collection2 = destination$iv$iv$iv;
            Object j = $receiver$iv.toJSON(it$iv);
            collection2.add(j);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        Collection thisCollection$iv$iv = $receiver$iv$iv;
        UserJSON[] userJSONArray = thisCollection$iv$iv.toArray(new UserJSON[0]);
        if (userJSONArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IdItem[] array$iv = userJSONArray;
        FieldPartial idPartial$iv = ((RemoteDAO)$receiver$iv).createPartial("id");
        RemoteUserDAO $receiver$iv$iv2 = $receiver$iv;
        String id$iv$iv = null;
        try {
            void idPartial;
            FieldPartial fieldPartial = idPartial$iv;
            UserJSON[] userArray = (UserJSON[])array$iv;
            idItem = this.client.merge(login, name, email, jabber, banned, twoFactorAuthentication, userArray, (FieldPartial<Partial.User>)idPartial);
        }
        catch (WebApplicationException ex$iv$iv) {
            throw (Throwable)$receiver$iv$iv2.wrapClientException(ex$iv$iv, id$iv$iv);
        }
        IdItem result$iv$iv = idItem;
        $receiver$iv$iv2.getRemoteAPI().syncNow();
        IdItem mergedJSON$iv = result$iv$iv;
        return (User)$receiver$iv.getNotNull(mergedJSON$iv.getId());
    }

    @Override
    @NotNull
    public PermissionQuery getPermissionQuery(@NotNull String authHolderId) {
        Intrinsics.checkParameterIsNotNull((Object)authHolderId, (String)"authHolderId");
        return this.getRemoteAPI().getPermissionCache().user(authHolderId, true);
    }

    @Override
    @NotNull
    public Profile verifyContact(@NotNull String userID, @NotNull Profile profile) throws DataAccessException {
        ProfileJSON profileJSON;
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        User user = (User)this.getNotNull(userID);
        RemoteUserDAO $receiver$iv = this;
        String id$iv = null;
        try {
            profileJSON = this.client.verifyContact(userID, new ProfileJSON(profile), null);
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        ProfileJSON result$iv = profileJSON;
        User user2 = user;
        Intrinsics.checkExpressionValueIsNotNull((Object)user2, (String)"user");
        Profile profile2 = user2.getProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)profile2, (String)"user.profile");
        return profile2;
    }

    @Override
    @NotNull
    public SshPublicKey addSshPublicKey(@NotNull String userID, @NotNull SshPublicKey sshPublicKey) throws DataAccessException {
        SshPublicKeyJSON sshPublicKeyJSON;
        SshPublicKeyJSON sshPublicKeyJSON2;
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        Intrinsics.checkParameterIsNotNull((Object)sshPublicKey, (String)"sshPublicKey");
        this.getNotNull(userID);
        SshPublicKeyJSON $receiver = sshPublicKeyJSON2 = new SshPublicKeyJSON();
        $receiver.setData(sshPublicKey.getData());
        $receiver.setOpenSshKey(sshPublicKey.getOpenSshKey());
        SshPublicKeyJSON keyJSON = sshPublicKeyJSON2;
        RemoteUserDAO $receiver$iv = this;
        try {
            sshPublicKeyJSON = this.client.getSshPublicKeysClient(userID).addSshPublicKey(keyJSON, (FieldPartial<Partial.SshPublicKey>)Partial.sshPublicKey(Partial.SshPublicKey.FINGER_PRINT, Partial.SshPublicKey.COMMENT));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, userID);
        }
        SshPublicKeyJSON result$iv = sshPublicKeyJSON;
        $receiver$iv.getRemoteAPI().syncNow();
        return result$iv;
    }

    @Override
    public void removeSshPublicKey(@NotNull String userID, @NotNull String fingerPrint) throws DataAccessException {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        Intrinsics.checkParameterIsNotNull((Object)fingerPrint, (String)"fingerPrint");
        this.getNotNull(userID);
        RemoteUserDAO $receiver$iv = this;
        try {
            this.client.getSshPublicKeysClient(userID).removeSshPublicKey(fingerPrint);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, userID);
        }
        Unit result$iv = unit;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeRefreshToken(@NotNull User user, @NotNull RefreshToken refreshToken) throws DataAccessException {
        void $receiver$iv;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)refreshToken, (String)"refreshToken");
        this.getNotNull(user.getId());
        RemoteUserDAO remoteUserDAO = this;
        String id$iv = user.getId();
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            UserClient.RefreshTokenClient refreshTokenClient = this.client.getRefreshTokensClient(string);
            String string2 = refreshToken.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"refreshToken.id");
            refreshTokenClient.removeRefreshToken(string2);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        Unit result$iv = unit;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeApprovedScope(@NotNull User user, @NotNull ApprovedScope approvedScope) throws DataAccessException {
        void $receiver$iv;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)approvedScope, (String)"approvedScope");
        this.getNotNull(user.getId());
        RemoteUserDAO remoteUserDAO = this;
        String id$iv = user.getId();
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            UserClient.ApprovedScopeClient approvedScopeClient = this.client.getApprovedScopesClient(string);
            String string2 = approvedScope.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"approvedScope.id");
            approvedScopeClient.removeApprovedScope(string2);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        Unit result$iv = unit;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PermanentToken addPermanentToken(@NotNull User user, @NotNull PermanentToken permanentToken) {
        void $receiver$iv;
        PermanentTokenJSON permanentTokenJSON;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permanentToken, (String)"permanentToken");
        this.getNotNull(user.getId());
        RemoteUserDAO remoteUserDAO = this;
        String id$iv = user.getId();
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            UserClient.PermanentTokenClient permanentTokenClient = this.client.getPermanentTokensClient(string);
            PermanentTokenJSON permanentTokenJSON2 = PermanentTokenJSON.wrap(permanentToken);
            Intrinsics.checkExpressionValueIsNotNull((Object)permanentTokenJSON2, (String)"PermanentTokenJSON.wrap(permanentToken)");
            permanentTokenJSON = permanentTokenClient.addPermanentToken(permanentTokenJSON2, (FieldPartial<Partial.PermanentToken>)Partial.permanentToken(Partial.PermanentToken.ID, Partial.PermanentToken.NAME, Partial.PermanentToken.TOKEN, Partial.PermanentToken.CREATION_TIME));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        PermanentTokenJSON result$iv = permanentTokenJSON;
        $receiver$iv.getRemoteAPI().syncNow();
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removePermanentToken(@NotNull User user, @NotNull PermanentToken permanentToken) {
        void $receiver$iv;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permanentToken, (String)"permanentToken");
        this.getNotNull(user.getId());
        RemoteUserDAO remoteUserDAO = this;
        String id$iv = user.getId();
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            UserClient.PermanentTokenClient permanentTokenClient = this.client.getPermanentTokensClient(string);
            String string2 = permanentToken.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"permanentToken.id");
            permanentTokenClient.removePermanentToken(string2);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        Unit result$iv = unit;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ApplicationPassword addApplicationPassword(@NotNull User user, @NotNull ApplicationPassword applicationPassword) {
        void $receiver$iv;
        ApplicationPasswordJSON applicationPasswordJSON;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)applicationPassword, (String)"applicationPassword");
        this.getNotNull(user.getId());
        RemoteUserDAO remoteUserDAO = this;
        String id$iv = user.getId();
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            UserClient.ApplicationPasswordClient applicationPasswordClient = this.client.getApplicationPasswordsClient(string);
            ApplicationPasswordJSON applicationPasswordJSON2 = ApplicationPasswordJSON.wrap(applicationPassword);
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationPasswordJSON2, (String)"ApplicationPasswordJSON.wrap(applicationPassword)");
            applicationPasswordJSON = applicationPasswordClient.addApplicationPassword(applicationPasswordJSON2, (FieldPartial<Partial.ApplicationPassword>)Partial.applicationPassword(Partial.ApplicationPassword.ID, Partial.ApplicationPassword.NAME, Partial.ApplicationPassword.PASSWORD, Partial.ApplicationPassword.CREATION_TIME));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        ApplicationPasswordJSON result$iv = applicationPasswordJSON;
        $receiver$iv.getRemoteAPI().syncNow();
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeApplicationPassword(@NotNull User user, @NotNull ApplicationPassword applicationPassword) {
        void $receiver$iv;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)applicationPassword, (String)"applicationPassword");
        this.getNotNull(user.getId());
        RemoteUserDAO remoteUserDAO = this;
        String id$iv = user.getId();
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            UserClient.ApplicationPasswordClient applicationPasswordClient = this.client.getApplicationPasswordsClient(string);
            String string2 = applicationPassword.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"applicationPassword.id");
            applicationPasswordClient.removeApplicationPassword(string2);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        Unit result$iv = unit;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Project addFavoriteProject(@NotNull User user, @NotNull Project project) throws DataAccessException {
        IdItem idItem;
        void childEnd$iv$iv;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getProjectDAO();
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, user);
        RemoteRelationEnd remoteRelationEnd = new ItemRemoteRelationEnd(childDAO$iv, project);
        boolean checkChildExistence$iv$iv = true;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        childEnd$iv$iv.checkExists();
        Object childJSON$iv$iv = childEnd$iv$iv.toJSON();
        FieldPartial childIdPartial$iv$iv = childEnd$iv$iv.getDao().createPartial("id");
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void idPartial;
            void projectJSON;
            FieldPartial fieldPartial = childIdPartial$iv$iv;
            ProjectJSON projectJSON2 = (ProjectJSON)childJSON$iv$iv;
            String userId = parentId$iv$iv;
            idItem = this.client.getFavoriteProjectsClient(userId).addFavoriteProject((ProjectJSON)projectJSON, (FieldPartial<Partial.Project>)idPartial);
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        IdItem result$iv$iv$iv = idItem;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
        IdItem resultJSON$iv$iv = result$iv$iv$iv;
        String string = resultJSON$iv$iv.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultJSON.id");
        return (Project)childEnd$iv$iv.resolve(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeFavoriteProject(@NotNull User user, @NotNull Project project) throws DataAccessException {
        Unit unit;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getProjectDAO();
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, user);
        RemoteRelationEnd childEnd$iv$iv = new ItemRemoteRelationEnd(childDAO$iv, project);
        String parentId$iv$iv = this_$iv$iv.checkExists();
        String childId$iv$iv = childEnd$iv$iv.checkExists();
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void projectId;
            String string = childId$iv$iv;
            String userId = parentId$iv$iv;
            this.client.getFavoriteProjectsClient(userId).removeFavoriteProject((String)projectId);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        Unit result$iv$iv$iv = unit;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
    }

    @Override
    @NotNull
    public EndUserAgreementConsent acceptEndUserAgreement() throws DataAccessException {
        EndUserAgreementConsentJSON endUserAgreementConsentJSON;
        RemoteUserDAO $receiver$iv = this;
        String id$iv = null;
        try {
            endUserAgreementConsentJSON = this.client.acceptEndUserAgreement((FieldPartial<Partial.EndUserAgreementConsent>)Partial.endUserAgreementConsent(Partial.EndUserAgreementConsent.MAJOR_VERSION, Partial.EndUserAgreementConsent.MINOR_VERSION, Partial.EndUserAgreementConsent.TIME, Partial.EndUserAgreementConsent.ACCEPTED));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        EndUserAgreementConsentJSON result$iv = endUserAgreementConsentJSON;
        $receiver$iv.getRemoteAPI().syncNow();
        return result$iv;
    }

    @Override
    public void revokeEndUserAgreementConsent() throws DataAccessException {
        Unit unit;
        RemoteUserDAO $receiver$iv = this;
        String id$iv = null;
        try {
            this.client.revokeEndUserAgreementConsent();
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        Unit result$iv = unit;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    @Override
    @NotNull
    public List<List<String>> getPersonalData(@NotNull User user) {
        List<List<String>> list2;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        RemoteUserDAO $receiver$iv = this;
        String id$iv = null;
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            list2 = this.client.getPersonalData(string);
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        List<List<String>> result$iv = list2;
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public User erasePersonalData(@NotNull User user) {
        void $receiver$iv;
        UserJSON userJSON;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        RemoteUserDAO remoteUserDAO = this;
        String id$iv = user.getId();
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            userJSON = this.client.erasePersonalData(string, (FieldPartial<Partial.User>)Partial.user(Partial.User.ID));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        UserJSON result$iv = userJSON;
        $receiver$iv.getRemoteAPI().syncNow();
        UserJSON userJSON2 = result$iv;
        Object i = this.getNotNull(userJSON2.getId());
        Intrinsics.checkExpressionValueIsNotNull(i, (String)"getNotNull(userJSON.id)");
        return (User)i;
    }

    @Override
    public void newEvent(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Event.Type eventType = Event.Type.fromString(event.getType());
        if (eventType == Event.Type.CREATE || eventType == Event.Type.REMOVE) {
            UserGroup rootUserGroup = this.getRemoteAPI().getUserGroupDAO().getRootUserGroup();
            RemoteUserGroupDAO remoteUserGroupDAO = this.getRemoteAPI().getUserGroupDAO();
            String string = rootUserGroup.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rootUserGroup.id");
            remoteUserGroupDAO.refreshGroupUsers(string);
        }
        super.newEvent(event);
    }

    @Override
    public void removeUserLocale(@NotNull User user) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.getNotNull(user.getId());
        RemoteUserDAO $receiver$iv = this;
        String id$iv = null;
        try {
            String string = user.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
            this.client.removeLocale(string);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        Unit result$iv = unit;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    @NotNull
    public final UserClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull UserClient userClient) {
        Intrinsics.checkParameterIsNotNull((Object)userClient, (String)"<set-?>");
        this.client = userClient;
    }

    public RemoteUserDAO(@NotNull UserClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Partial<Partial.User> partial = Partial.user(Partial.User.ID, Partial.User.ALIASES(new Partial.Alias[0]), Partial.User.GROUPS(Partial.UserGroup.ID), Partial.User.TEAMS(Partial.ProjectTeam.ID), Partial.User.TRANSITIVE_TEAMS(Partial.ProjectTeam.ID), Partial.User.PROJECT_ROLES(Partial.ProjectRole.ID), Partial.User.PROFILE(new Partial.Profile[0]));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.user(\n          \u2026  Partial.User.PROFILE())");
        super((FieldPartial)partial);
        this.client = client;
    }
}

