/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.jetpass.dao.util.Pair;
import jetbrains.jetpass.dao.util.Stack;

abstract class AbstractPersistent23Tree<K extends Comparable<K>>
implements Iterable<K> {
    AbstractPersistent23Tree() {
    }

    abstract RootNode<K> getRoot();

    public boolean contains(K key) {
        RootNode<K> root = this.getRoot();
        return root != null && root.get(key) != null;
    }

    public boolean isEmpty() {
        return this.getRoot() == null;
    }

    public int size() {
        RootNode<K> root = this.getRoot();
        return root == null ? 0 : root.getSize();
    }

    public final K getMinimum() {
        Iterator<K> it = this.iterator();
        return (K)(it.hasNext() ? (Comparable)it.next() : null);
    }

    public final K getMaximum() {
        Iterator<K> it = this.reverseIterator();
        return (K)(it.hasNext() ? (Comparable)it.next() : null);
    }

    @Override
    public Iterator<K> iterator() {
        return this.isEmpty() ? Collections.EMPTY_LIST.iterator() : new Iterator<K>(){
            private Stack<TreePos<K>> stack;
            private boolean hasNext;
            private boolean hasNextValid;

            @Override
            public boolean hasNext() {
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                if (this.stack == null) {
                    RootNode root = AbstractPersistent23Tree.this.getRoot();
                    if (root == null) {
                        this.hasNext = false;
                        return this.hasNext;
                    }
                    this.stack = new Stack();
                    this.stack.push(new TreePos(root));
                }
                TreePos treePos = this.stack.peek();
                if (treePos.node.isLeaf()) {
                    while (treePos.pos >= (treePos.node.isTernary() ? 2 : 1)) {
                        this.stack.pop();
                        if (this.stack.isEmpty()) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = this.stack.peek();
                    }
                } else {
                    treePos = treePos.pos == 0 ? new TreePos(treePos.node.getFirstChild()) : (treePos.pos == 1 ? new TreePos(treePos.node.getSecondChild()) : new TreePos(treePos.node.getThirdChild()));
                    this.stack.push(treePos);
                    while (!treePos.node.isLeaf()) {
                        treePos = new TreePos(treePos.node.getFirstChild());
                        this.stack.push(treePos);
                    }
                }
                ++treePos.pos;
                this.hasNext = true;
                return this.hasNext;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                TreePos treePos = this.stack.peek();
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<K> tailIterator(K key) {
        return new Iterator<K>((Comparable)key){
            private Stack<TreePos<K>> stack;
            private boolean hasNext;
            private boolean hasNextValid;
            final /* synthetic */ Comparable val$key;
            {
                this.val$key = comparable;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                if (this.stack == null) {
                    RootNode<Comparable> root = AbstractPersistent23Tree.this.getRoot();
                    if (root == null) {
                        this.hasNext = false;
                        return this.hasNext;
                    }
                    this.stack = new Stack();
                    if (!root.getLess(this.val$key, this.stack)) {
                        this.stack.push(new TreePos(root));
                    }
                }
                TreePos treePos = this.stack.peek();
                if (treePos.node.isLeaf()) {
                    while (treePos.pos >= (treePos.node.isTernary() ? 2 : 1)) {
                        this.stack.pop();
                        if (this.stack.isEmpty()) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = this.stack.peek();
                    }
                } else {
                    treePos = treePos.pos == 0 ? new TreePos(treePos.node.getFirstChild()) : (treePos.pos == 1 ? new TreePos(treePos.node.getSecondChild()) : new TreePos(treePos.node.getThirdChild()));
                    this.stack.push(treePos);
                    while (!treePos.node.isLeaf()) {
                        treePos = new TreePos(treePos.node.getFirstChild());
                        this.stack.push(treePos);
                    }
                }
                ++treePos.pos;
                this.hasNext = true;
                return this.hasNext;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                TreePos treePos = this.stack.peek();
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<K> reverseIterator() {
        return new Iterator<K>(){
            private Stack<TreePosRev<K>> stack;
            private boolean hasNext;
            private boolean hasNextValid;

            @Override
            public boolean hasNext() {
                TreePosRev treePos;
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                if (this.stack == null) {
                    RootNode root = AbstractPersistent23Tree.this.getRoot();
                    if (root == null) {
                        this.hasNext = false;
                        return this.hasNext;
                    }
                    this.stack = new Stack();
                    this.stack.push(new TreePosRev(root));
                }
                if ((treePos = this.stack.peek()).node.isLeaf()) {
                    while (treePos.pos <= 1) {
                        this.stack.pop();
                        if (this.stack.isEmpty()) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = this.stack.peek();
                    }
                } else {
                    treePos = treePos.pos == 1 ? new TreePosRev(treePos.node.getFirstChild()) : (treePos.pos == 2 ? new TreePosRev(treePos.node.getSecondChild()) : new TreePosRev(treePos.node.getThirdChild()));
                    this.stack.push(treePos);
                    while (!treePos.node.isLeaf()) {
                        treePos = new TreePosRev(treePos.node.isTernary() ? treePos.node.getThirdChild() : treePos.node.getSecondChild());
                        this.stack.push(treePos);
                    }
                }
                treePos.pos--;
                this.hasNext = true;
                return this.hasNext;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                TreePosRev treePos = this.stack.peek();
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<K> tailReverseIterator(K key) {
        return new Iterator<K>((Comparable)key){
            private Stack<TreePosRev<K>> stack;
            private boolean hasNext;
            private boolean hasNextValid;
            private K bound;
            final /* synthetic */ Comparable val$key;
            {
                this.val$key = comparable;
            }

            @Override
            public boolean hasNext() {
                TreePosRev treePos;
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                if (this.stack == null) {
                    RootNode root = AbstractPersistent23Tree.this.getRoot();
                    if (root == null) {
                        this.hasNext = false;
                        return this.hasNext;
                    }
                    this.bound = AbstractPersistent23Tree.getLess(root, this.val$key);
                    this.stack = new Stack();
                    this.stack.push(new TreePosRev(root));
                }
                if ((treePos = this.stack.peek()).node.isLeaf()) {
                    while (treePos.pos <= 1) {
                        this.stack.pop();
                        if (this.stack.isEmpty()) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = this.stack.peek();
                    }
                } else {
                    treePos = treePos.pos == 1 ? new TreePosRev(treePos.node.getFirstChild()) : (treePos.pos == 2 ? new TreePosRev(treePos.node.getSecondChild()) : new TreePosRev(treePos.node.getThirdChild()));
                    this.stack.push(treePos);
                    while (!treePos.node.isLeaf()) {
                        treePos = new TreePosRev(treePos.node.isTernary() ? treePos.node.getThirdChild() : treePos.node.getSecondChild());
                        this.stack.push(treePos);
                    }
                }
                treePos.pos--;
                this.hasNext = this.tryNext() != this.bound;
                return this.hasNext;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                return this.tryNext();
            }

            private K tryNext() {
                TreePosRev treePos = this.stack.peek();
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <K extends Comparable<K>> Node<K> createNode(Node<K> firstChild, K key, Node<K> secondChild) {
        if (firstChild == null && secondChild == null) {
            return new BinaryNode<K>(key);
        }
        return new InternalBinaryNode<K>(firstChild, key, secondChild);
    }

    static <K extends Comparable<K>> RootNode<K> createRootNode(Node<K> firstChild, K key, Node<K> secondChild, int size2) {
        if (firstChild == null && secondChild == null) {
            return new RootBinaryNode<K>(key, size2);
        }
        return new RootInternalBinaryNode<K>(firstChild, key, secondChild, size2);
    }

    static <K extends Comparable<K>> Node<K> createNode(Node<K> firstChild, K firstKey, Node<K> secondChild, K secondKey, Node<K> thirdChild) {
        if (firstChild == null && secondChild == null && thirdChild == null) {
            return new TernaryNode<K>(firstKey, secondKey);
        }
        return new InternalTernaryNode<K>(firstChild, firstKey, secondChild, secondKey, thirdChild);
    }

    static <K extends Comparable<K>> RootNode<K> createRootNode(Node<K> firstChild, K firstKey, Node<K> secondChild, K secondKey, Node<K> thirdChild, int size2) {
        if (firstChild == null && secondChild == null && thirdChild == null) {
            return new RootTernaryNode<K>(firstKey, secondKey, size2);
        }
        return new RootInternalTernaryNode<K>(firstChild, firstKey, secondChild, secondKey, thirdChild, size2);
    }

    static <K extends Comparable<K>> void checkNode(Node<K> node) {
        node.checkNode(null, null);
    }

    static <K extends Comparable<K>> boolean getLess(Node<K> node, Stack<TreePos<K>> stack) {
        stack.push(new TreePos<K>(node));
        return false;
    }

    static <K extends Comparable<K>> K getLess(Node<K> node, K key) {
        Stack stack = new Stack();
        if (!node.getLess(key, stack)) {
            return null;
        }
        TreePos treePos = stack.peek();
        return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
    }

    static class SplitResult<K extends Comparable<K>> {
        private Node<K> firstNode;
        private Node<K> secondNode;
        private K key;
        boolean sizeChanged = false;

        SplitResult() {
        }

        SplitResult<K> fill(Node<K> first, K key, Node<K> second) {
            this.firstNode = first;
            this.key = key;
            this.secondNode = second;
            return this;
        }

        public SplitResult<K> fill(Node<K> node) {
            return this.fill(node, null, null);
        }

        public Node<K> getFirstNode() {
            return this.firstNode;
        }

        public Node<K> getSecondNode() {
            return this.secondNode;
        }

        public K getKey() {
            return this.key;
        }

        public SplitResult<K> setSizeChanged() {
            this.sizeChanged = true;
            return this;
        }
    }

    static class RemovedNode<K extends Comparable<K>>
    implements Node<K> {
        private final Node<K> child;

        RemovedNode(Node<K> child) {
            this.child = child;
        }

        @Override
        public Node<K> getFirstChild() {
            return this.child;
        }

        @Override
        public Node<K> getSecondChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node<K> getThirdChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getFirstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getSecondKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTernary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RootNode<K> asRoot(int size2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SplitResult<K> insert(K key) {
            throw new UnsupportedOperationException("Can't insert into a temporary tree.");
        }

        @Override
        public Pair<Node<K>, K> remove(K key, boolean strict) {
            throw new UnsupportedOperationException("Can't remove from a temporary tree.");
        }

        @Override
        public K get(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int checkNode(K from, K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String print() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void count(int[] count) {
            throw new UnsupportedOperationException();
        }
    }

    static class InternalTernaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;
        private final K secondKey;
        private final Node<K> firstChild;
        private final Node<K> secondChild;
        private final Node<K> thirdChild;

        InternalTernaryNode(Node<K> firstChild, K firstKey, Node<K> secondChild, K secondKey, Node<K> thirdChild) {
            this.firstKey = firstKey;
            this.secondKey = secondKey;
            this.firstChild = firstChild;
            this.secondChild = secondChild;
            this.thirdChild = thirdChild;
        }

        @Override
        public Node<K> getFirstChild() {
            return this.firstChild;
        }

        @Override
        public Node<K> getSecondChild() {
            return this.secondChild;
        }

        @Override
        public Node<K> getThirdChild() {
            return this.thirdChild;
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            return this.secondKey;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isTernary() {
            return true;
        }

        @Override
        public RootNode<K> asRoot(int size2) {
            return new RootInternalTernaryNode<K>(this.firstChild, this.firstKey, this.secondChild, this.secondKey, this.thirdChild, size2);
        }

        @Override
        public SplitResult<K> insert(K key) {
            int comp = key.compareTo(this.firstKey);
            if (comp < 0) {
                SplitResult<K> splitResult = this.firstChild.insert(key);
                Node<K> firstNode = splitResult.getFirstNode();
                K splitKey = splitResult.getKey();
                if (splitKey == null) {
                    return splitResult.fill(this.cloneReplacingChild(this.firstChild, firstNode));
                }
                return splitResult.fill(new InternalBinaryNode<K>(firstNode, splitKey, splitResult.getSecondNode()), this.firstKey, new InternalBinaryNode<K>(this.secondChild, this.secondKey, this.thirdChild));
            }
            if (comp == 0) {
                return new SplitResult<K>().fill(new InternalTernaryNode<K>(this.firstChild, key, this.secondChild, this.secondKey, this.thirdChild));
            }
            comp = key.compareTo(this.secondKey);
            if (comp < 0) {
                SplitResult<K> splitResult = this.secondChild.insert(key);
                Node<K> firstNode = splitResult.getFirstNode();
                K splitKey = splitResult.getKey();
                if (splitKey == null) {
                    return splitResult.fill(this.cloneReplacingChild(this.secondChild, firstNode));
                }
                return splitResult.fill(new InternalBinaryNode<K>(this.firstChild, this.firstKey, firstNode), splitKey, new InternalBinaryNode<K>(splitResult.getSecondNode(), this.secondKey, this.thirdChild));
            }
            if (comp == 0) {
                return new SplitResult<K>().fill(new InternalTernaryNode<K>(this.firstChild, this.firstKey, this.secondChild, key, this.thirdChild));
            }
            SplitResult<K> splitResult = this.thirdChild.insert(key);
            Node<K> firstNode = splitResult.getFirstNode();
            K splitKey = splitResult.getKey();
            if (splitKey == null) {
                return splitResult.fill(this.cloneReplacingChild(this.thirdChild, firstNode));
            }
            return splitResult.fill(new InternalBinaryNode<K>(this.firstChild, this.firstKey, this.secondChild), this.secondKey, new InternalBinaryNode<K>(firstNode, splitKey, splitResult.getSecondNode()));
        }

        @Override
        public Pair<Node<K>, K> remove(K key, boolean strict) {
            Object newNodeKey;
            int compFirst;
            int n = compFirst = strict ? key.compareTo(this.firstKey) : -1;
            if (compFirst < 0) {
                Pair<Node<K>, K> removeResult = this.firstChild.remove(key, strict);
                if (removeResult == null) {
                    return null;
                }
                Node<K> resultNode = removeResult.getFirst();
                Comparable removedKey = (Comparable)removeResult.getSecond();
                if (resultNode instanceof RemovedNode) {
                    Node<K> removedNodeResult = resultNode.getFirstChild();
                    if (!this.secondChild.isTernary()) {
                        return new Pair<InternalBinaryNode<K>, Comparable>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild()), this.secondKey, this.thirdChild), removedKey);
                    }
                    return new Pair<InternalTernaryNode<K>, Comparable>(new InternalTernaryNode<K>(AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild()), this.secondChild.getFirstKey(), AbstractPersistent23Tree.createNode(this.secondChild.getSecondChild(), this.secondChild.getSecondKey(), this.secondChild.getThirdChild()), this.secondKey, this.thirdChild), removedKey);
                }
                return new Pair<Node<K>, Comparable>(this.cloneReplacingChild(this.firstChild, resultNode), removedKey);
            }
            int compSecond = -1;
            if (compFirst > 0) {
                compSecond = key.compareTo(this.secondKey);
            }
            if (compSecond < 0) {
                Object newNodeKey2;
                Pair<Node<K>, K> removeResult = this.secondChild.remove(key, compFirst != 0);
                if (removeResult == null) {
                    return null;
                }
                Node<K> resultNode = removeResult.getFirst();
                Object removedKey = compFirst == 0 ? this.firstKey : (Comparable)removeResult.getSecond();
                Object object = newNodeKey2 = compFirst != 0 ? this.firstKey : (Comparable)removeResult.getSecond();
                if (resultNode instanceof RemovedNode) {
                    Node<K> removedNodeResult = resultNode.getFirstChild();
                    if (!this.firstChild.isTernary()) {
                        return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild(), newNodeKey2, removedNodeResult), this.secondKey, this.thirdChild), removedKey);
                    }
                    return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild()), this.firstChild.getSecondKey(), AbstractPersistent23Tree.createNode(this.firstChild.getThirdChild(), newNodeKey2, removedNodeResult), this.secondKey, this.thirdChild), removedKey);
                }
                return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(this.firstChild, newNodeKey2, resultNode, this.secondKey, this.thirdChild), removedKey);
            }
            Pair<Node<K>, K> removeResult = this.thirdChild.remove(key, compSecond != 0);
            if (removeResult == null) {
                return null;
            }
            Node<K> resultNode = removeResult.getFirst();
            Object removedKey = compSecond == 0 ? this.secondKey : (Comparable)removeResult.getSecond();
            Object object = newNodeKey = compSecond != 0 ? this.secondKey : (Comparable)removeResult.getSecond();
            if (resultNode instanceof RemovedNode) {
                Node<K> removedNodeResult = resultNode.getFirstChild();
                if (!this.secondChild.isTernary()) {
                    return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(this.firstChild, this.firstKey, AbstractPersistent23Tree.createNode(this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild(), newNodeKey, removedNodeResult)), removedKey);
                }
                return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(this.firstChild, this.firstKey, AbstractPersistent23Tree.createNode(this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild()), this.secondChild.getSecondKey(), AbstractPersistent23Tree.createNode(this.secondChild.getThirdChild(), newNodeKey, removedNodeResult)), removedKey);
            }
            return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(this.firstChild, this.firstKey, this.secondChild, newNodeKey, resultNode), removedKey);
        }

        @Override
        public K get(K key) {
            int comp = key.compareTo(this.firstKey);
            if (comp < 0) {
                return this.firstChild.get(key);
            }
            if (comp == 0) {
                return this.firstKey;
            }
            comp = key.compareTo(this.secondKey);
            if (comp == 0) {
                return this.secondKey;
            }
            return comp < 0 ? this.secondChild.get(key) : this.thirdChild.get(key);
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            int comp = this.secondKey.compareTo(key);
            if (comp < 0) {
                stack.peek().pos += 2;
                this.thirdChild.getLess(key, stack);
                return true;
            }
            comp = this.firstKey.compareTo(key);
            if (comp < 0) {
                ++stack.peek().pos;
                this.secondChild.getLess(key, stack);
            } else if (!this.firstChild.getLess(key, stack)) {
                stack.pop();
                return false;
            }
            return true;
        }

        Node<K> cloneReplacingChild(Node<K> oldChild, Node<K> newChild) {
            return new InternalTernaryNode<K>(this.firstChild == oldChild ? newChild : this.firstChild, this.firstKey, this.secondChild == oldChild ? newChild : this.secondChild, this.secondKey, this.thirdChild == oldChild ? newChild : this.thirdChild);
        }

        @Override
        public int checkNode(K from, K to) {
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstKey.compareTo(this.secondKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.secondKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstChild == null || this.secondChild == null || this.thirdChild == null) {
                throw new RuntimeException("The node has not enough children.");
            }
            int depth = this.firstChild.checkNode(from, this.firstKey);
            if (depth != this.secondChild.checkNode(this.firstKey, this.secondKey) || depth != this.thirdChild.checkNode(this.secondKey, to)) {
                throw new RuntimeException("Not a balanced tree.");
            }
            return depth + 1;
        }

        @Override
        public String print() {
            return '(' + this.firstChild.print() + ") " + this.firstKey + " (" + this.secondChild.print() + ") " + this.secondKey + " (" + this.thirdChild.print() + ')';
        }

        @Override
        public void count(int[] count) {
            count[3] = count[3] + 1;
            this.firstChild.count(count);
            this.secondChild.count(count);
            this.thirdChild.count(count);
        }
    }

    static class RootInternalTernaryNode<K extends Comparable<K>>
    extends InternalTernaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootInternalTernaryNode(Node<K> firstChild, K firstKey, Node<K> secondChild, K secondKey, Node<K> thirdChild, int size2) {
            super(firstChild, firstKey, secondChild, secondKey, thirdChild);
            this.size = size2;
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }

    static class TernaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;
        private final K secondKey;

        TernaryNode(K firstKey, K secondKey) {
            this.firstKey = firstKey;
            this.secondKey = secondKey;
        }

        @Override
        public Node<K> getFirstChild() {
            return null;
        }

        @Override
        public Node<K> getSecondChild() {
            return null;
        }

        @Override
        public Node<K> getThirdChild() {
            return null;
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            return this.secondKey;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isTernary() {
            return true;
        }

        @Override
        public RootNode<K> asRoot(int size2) {
            return new RootTernaryNode<K>(this.firstKey, this.secondKey, size2);
        }

        @Override
        public SplitResult<K> insert(K key) {
            int comp = key.compareTo(this.firstKey);
            if (comp < 0) {
                return new SplitResult<K>().fill(new BinaryNode<K>(key), this.firstKey, new BinaryNode<K>(this.secondKey)).setSizeChanged();
            }
            if (comp == 0) {
                return new SplitResult<K>().fill(new TernaryNode<K>(key, this.secondKey));
            }
            comp = key.compareTo(this.secondKey);
            if (comp < 0) {
                return new SplitResult<K>().fill(new BinaryNode<K>(this.firstKey), key, new BinaryNode<K>(this.secondKey)).setSizeChanged();
            }
            if (comp == 0) {
                return new SplitResult<K>().fill(new TernaryNode<K>(this.firstKey, key));
            }
            return new SplitResult<K>().fill(new BinaryNode<K>(this.firstKey), this.secondKey, new BinaryNode<K>(key)).setSizeChanged();
        }

        @Override
        public Pair<Node<K>, K> remove(K key, boolean strict) {
            int compFirst;
            int n = compFirst = strict ? key.compareTo(this.firstKey) : -1;
            if (compFirst < 0 && strict) {
                return null;
            }
            if (compFirst <= 0) {
                return new Pair<BinaryNode<K>, K>(new BinaryNode<K>(this.secondKey), this.firstKey);
            }
            int compSecond = -1;
            if (compFirst > 0) {
                compSecond = key.compareTo(this.secondKey);
            }
            if (compSecond != 0) {
                return null;
            }
            return new Pair<BinaryNode<K>, K>(new BinaryNode<K>(this.firstKey), this.secondKey);
        }

        @Override
        public K get(K key) {
            int comp = key.compareTo(this.firstKey);
            if (comp == 0) {
                return this.firstKey;
            }
            if (comp > 0 && key.compareTo(this.secondKey) == 0) {
                return this.secondKey;
            }
            return null;
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            if (this.firstKey.compareTo(key) >= 0) {
                stack.pop();
                return false;
            }
            stack.peek().pos = this.secondKey.compareTo(key) < 0 ? (stack.peek().pos += 2) : ++stack.peek().pos;
            return true;
        }

        @Override
        public int checkNode(K from, K to) {
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstKey.compareTo(this.secondKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.secondKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            return 1;
        }

        @Override
        public String print() {
            return this.firstKey + ", " + this.secondKey;
        }

        @Override
        public void count(int[] count) {
            count[2] = count[2] + 1;
        }
    }

    static class RootTernaryNode<K extends Comparable<K>>
    extends TernaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootTernaryNode(K firstKey, K secondKey, int size2) {
            super(firstKey, secondKey);
            this.size = size2;
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }

    static class InternalBinaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;
        private final Node<K> firstChild;
        private final Node<K> secondChild;

        InternalBinaryNode(Node<K> firstChild, K firstKey, Node<K> secondChild) {
            this.firstKey = firstKey;
            this.firstChild = firstChild;
            this.secondChild = secondChild;
        }

        @Override
        public Node<K> getFirstChild() {
            return this.firstChild;
        }

        @Override
        public Node<K> getSecondChild() {
            return this.secondChild;
        }

        @Override
        public Node<K> getThirdChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isTernary() {
            return false;
        }

        @Override
        public RootNode<K> asRoot(int size2) {
            return new RootInternalBinaryNode<K>(this.firstChild, this.firstKey, this.secondChild, size2);
        }

        @Override
        public SplitResult<K> insert(K key) {
            int comp = key.compareTo(this.firstKey);
            if (comp < 0) {
                SplitResult<K> splitResult = this.firstChild.insert(key);
                Node<K> firstNode = splitResult.getFirstNode();
                K splitKey = splitResult.getKey();
                if (splitKey == null) {
                    return splitResult.fill(new InternalBinaryNode<K>(firstNode, this.firstKey, this.secondChild));
                }
                return splitResult.fill(new InternalTernaryNode<K>(firstNode, splitKey, splitResult.getSecondNode(), this.firstKey, this.secondChild));
            }
            if (comp == 0) {
                return new SplitResult<K>().fill(new InternalBinaryNode<K>(this.firstChild, key, this.secondChild));
            }
            SplitResult<K> splitResult = this.secondChild.insert(key);
            Node<K> firstNode = splitResult.getFirstNode();
            K splitKey = splitResult.getKey();
            if (splitKey == null) {
                return splitResult.fill(new InternalBinaryNode<K>(this.firstChild, this.firstKey, firstNode));
            }
            return splitResult.fill(new InternalTernaryNode<K>(this.firstChild, this.firstKey, firstNode, splitKey, splitResult.getSecondNode()));
        }

        @Override
        public Pair<Node<K>, K> remove(K key, boolean strict) {
            Object newNodeKey;
            int comp;
            int n = comp = strict ? key.compareTo(this.firstKey) : -1;
            if (comp < 0) {
                Pair<Node<K>, K> removeResult = this.firstChild.remove(key, strict);
                if (removeResult == null) {
                    return null;
                }
                Node<K> resultNode = removeResult.getFirst();
                Comparable removedKey = (Comparable)removeResult.getSecond();
                if (resultNode instanceof RemovedNode) {
                    Node<K> removedNodeResult = resultNode.getFirstChild();
                    if (!this.secondChild.isTernary()) {
                        Node<K> node = AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild());
                        return new Pair<RemovedNode<K>, Comparable>(new RemovedNode<K>(node), removedKey);
                    }
                    return new Pair<InternalBinaryNode<K>, Comparable>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild()), this.secondChild.getFirstKey(), AbstractPersistent23Tree.createNode(this.secondChild.getSecondChild(), this.secondChild.getSecondKey(), this.secondChild.getThirdChild())), removedKey);
                }
                return new Pair<Node<K>, Comparable>(AbstractPersistent23Tree.createNode(resultNode, this.firstKey, this.secondChild), removedKey);
            }
            Pair<Node<K>, K> removeResult = this.secondChild.remove(key, comp != 0);
            if (removeResult == null) {
                return null;
            }
            Node<K> resultNode = removeResult.getFirst();
            Object removedKey = comp == 0 ? this.firstKey : (Comparable)removeResult.getSecond();
            Object object = newNodeKey = comp != 0 ? this.firstKey : (Comparable)removeResult.getSecond();
            if (resultNode instanceof RemovedNode) {
                Node<K> removedNodeResult = resultNode.getFirstChild();
                if (!this.firstChild.isTernary()) {
                    return new Pair<RemovedNode<K>, K>(new RemovedNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild(), newNodeKey, removedNodeResult)), removedKey);
                }
                return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild()), this.firstChild.getSecondKey(), AbstractPersistent23Tree.createNode(this.firstChild.getThirdChild(), newNodeKey, removedNodeResult)), removedKey);
            }
            return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(this.firstChild, newNodeKey, resultNode), removedKey);
        }

        @Override
        public K get(K key) {
            int comp = key.compareTo(this.firstKey);
            if (comp == 0) {
                return this.firstKey;
            }
            if (comp < 0) {
                return this.firstChild.get(key);
            }
            return this.secondChild.get(key);
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            int comp = this.firstKey.compareTo(key);
            if (comp < 0) {
                ++stack.peek().pos;
                this.secondChild.getLess(key, stack);
            } else if (!this.firstChild.getLess(key, stack)) {
                stack.pop();
                return false;
            }
            return true;
        }

        @Override
        public int checkNode(K from, K to) {
            int secondDepth;
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.firstKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstChild == null || this.secondChild == null) {
                throw new RuntimeException("Not an inner node.");
            }
            int firstDepth = this.firstChild.checkNode(from, this.firstKey);
            if (firstDepth != (secondDepth = this.secondChild.checkNode(this.firstKey, to))) {
                throw new RuntimeException("Not balanced tree.");
            }
            return firstDepth + 1;
        }

        @Override
        public String print() {
            return '(' + this.firstChild.print() + ") " + this.firstKey + " (" + this.secondChild.print() + ')';
        }

        @Override
        public void count(int[] count) {
            count[1] = count[1] + 1;
            this.firstChild.count(count);
            this.secondChild.count(count);
        }
    }

    static class RootInternalBinaryNode<K extends Comparable<K>>
    extends InternalBinaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootInternalBinaryNode(Node<K> firstChild, K firstKey, Node<K> secondChild, int size2) {
            super(firstChild, firstKey, secondChild);
            this.size = size2;
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }

    static class BinaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;

        BinaryNode(K firstKey) {
            this.firstKey = firstKey;
        }

        @Override
        public Node<K> getFirstChild() {
            return null;
        }

        @Override
        public Node<K> getSecondChild() {
            return null;
        }

        @Override
        public Node<K> getThirdChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isTernary() {
            return false;
        }

        @Override
        public RootNode<K> asRoot(int size2) {
            return new RootBinaryNode<K>(this.firstKey, size2);
        }

        @Override
        public SplitResult<K> insert(K key) {
            int comp = key.compareTo(this.firstKey);
            if (comp < 0) {
                return new SplitResult<K>().fill(new TernaryNode<K>(key, this.firstKey)).setSizeChanged();
            }
            if (comp == 0) {
                return new SplitResult<K>().fill(new BinaryNode<K>(key));
            }
            return new SplitResult<K>().fill(new TernaryNode<K>(this.firstKey, key)).setSizeChanged();
        }

        @Override
        public Pair<Node<K>, K> remove(K key, boolean strict) {
            int comp;
            int n = comp = strict ? key.compareTo(this.firstKey) : -1;
            if (strict && comp != 0) {
                return null;
            }
            return new Pair(new RemovedNode(null), this.firstKey);
        }

        @Override
        public K get(K key) {
            return key.compareTo(this.firstKey) == 0 ? (K)this.firstKey : null;
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            if (this.firstKey.compareTo(key) >= 0) {
                stack.pop();
                return false;
            }
            ++stack.peek().pos;
            return true;
        }

        @Override
        public int checkNode(K from, K to) {
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.firstKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            return 1;
        }

        @Override
        public String print() {
            return String.valueOf(this.firstKey);
        }

        @Override
        public void count(int[] count) {
            count[0] = count[0] + 1;
        }
    }

    static class RootBinaryNode<K extends Comparable<K>>
    extends BinaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootBinaryNode(K firstKey, int size2) {
            super(firstKey);
            this.size = size2;
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }

    static interface RootNode<K extends Comparable<K>>
    extends Node<K> {
        public int getSize();
    }

    static interface Node<K extends Comparable<K>> {
        public Node<K> getFirstChild();

        public Node<K> getSecondChild();

        public Node<K> getThirdChild();

        public K getFirstKey();

        public K getSecondKey();

        public boolean isLeaf();

        public boolean isTernary();

        public RootNode<K> asRoot(int var1);

        public SplitResult<K> insert(K var1);

        public Pair<Node<K>, K> remove(K var1, boolean var2);

        public K get(K var1);

        public boolean getLess(K var1, Stack<TreePos<K>> var2);

        public int checkNode(K var1, K var2);

        public String print();

        public void count(int[] var1);
    }

    class TreePosRev<K extends Comparable<K>> {
        private final Node<K> node;
        private int pos;

        TreePosRev(Node<K> node) {
            this.node = node;
            this.pos = 2;
            if (node.isTernary()) {
                this.pos = 3;
            }
        }
    }

    private static class TreePos<K extends Comparable<K>> {
        final Node<K> node;
        int pos;

        TreePos(Node<K> node) {
            this.node = node;
        }
    }
}

