/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.login.AuthAttempt;
import jetbrains.jetpass.api.authority.login.FoundUser;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthAttemptJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.UuidJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="authFoundUser")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=AuthFoundUserJSON.class)
public class AuthFoundUserJSON
extends UuidJSON
implements FoundUser {
    @XmlElement(name="user")
    private UserJSON user;
    @XmlElement(name="attempts")
    private List<AuthAttemptJSON> attempts;

    public AuthFoundUserJSON() {
    }

    public AuthFoundUserJSON(@NotNull FoundUser that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        if (that.getUser() != null) {
            UserJSON ref = new UserJSON();
            ref.setId(that.getUser().getId());
            this.setUser(ref);
        }
        if (that.getAttempts() != null) {
            ArrayList<AuthAttemptJSON> references = new ArrayList<AuthAttemptJSON>();
            for (AuthAttempt authAttempt : that.getAttempts()) {
                AuthAttemptJSON ref = new AuthAttemptJSON();
                ref.setId(authAttempt.getId());
                references.add(ref);
            }
            this.setAttempts(references);
        }
    }

    @Override
    @Nullable
    public UserJSON getUser() {
        return this.user;
    }

    @Nullable
    public Iterable<AuthAttemptJSON> getAttempts() {
        return this.attempts;
    }

    @XmlTransient
    public void setUser(@Nullable UserJSON user) {
        this.user = user;
    }

    @XmlTransient
    public void setAttempts(@Nullable Iterable<AuthAttemptJSON> attempts) {
        this.attempts = JsonUtils.iterableToList(attempts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FoundUser)) {
            return false;
        }
        FoundUser that = (FoundUser)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static AuthFoundUserJSON wrap(@NotNull FoundUser that) {
        if (that instanceof AuthFoundUserJSON) {
            return (AuthFoundUserJSON)that;
        }
        return new AuthFoundUserJSON(that);
    }
}

