/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.JabberSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jabberSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeName(value="jabber")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=JabberSettingsJSON.class)
public class JabberSettingsJSON
extends SettingsJSON
implements JabberSettings {
    @XmlElement(name="enabled")
    private Boolean enabled;
    @XmlElement(name="host")
    private String host;
    @XmlElement(name="port")
    private Integer port;
    @XmlElement(name="serviceName")
    private String serviceName;
    @XmlElement(name="SASLEnabled")
    private Boolean SASLEnabled;
    @XmlElement(name="login")
    private String login;
    @XmlElement(name="password")
    private String password;
    @XmlElement(name="passwordDefined")
    private Boolean passwordDefined;

    public JabberSettingsJSON() {
    }

    public JabberSettingsJSON(@NotNull JabberSettings that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setEnabled(that.isEnabled());
        this.setHost(that.getHost());
        this.setPort(that.getPort());
        this.setServiceName(that.getServiceName());
        this.setSASLEnabled(that.isSASLEnabled());
        this.setLogin(that.getLogin());
        this.setPassword(that.getPassword());
    }

    @Override
    @Nullable
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @Nullable
    public Boolean isSASLEnabled() {
        return this.SASLEnabled;
    }

    @Override
    @Nullable
    public String getLogin() {
        return this.login;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public Boolean isPasswordDefined() {
        return this.passwordDefined;
    }

    @XmlTransient
    public void setEnabled(@Nullable Boolean enabled2) {
        this.enabled = enabled2;
    }

    @XmlTransient
    public void setHost(@Nullable String host) {
        this.host = host;
    }

    @XmlTransient
    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    @XmlTransient
    public void setServiceName(@Nullable String serviceName) {
        this.serviceName = serviceName;
    }

    @XmlTransient
    public void setSASLEnabled(@Nullable Boolean SASLEnabled) {
        this.SASLEnabled = SASLEnabled;
    }

    @XmlTransient
    public void setLogin(@Nullable String login) {
        this.login = login;
    }

    @XmlTransient
    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    @XmlTransient
    public void setPasswordDefined(@Nullable Boolean passwordDefined) {
        this.passwordDefined = passwordDefined;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JabberSettings)) {
            return false;
        }
        JabberSettings that = (JabberSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static JabberSettingsJSON wrap(@NotNull JabberSettings that) {
        if (that instanceof JabberSettingsJSON) {
            return (JabberSettingsJSON)that;
        }
        return new JabberSettingsJSON(that);
    }
}

