/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.security.access.ProjectRoleSource;
import jetbrains.jetpass.api.security.access.SourcedProjectRole;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleSourceJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="sourcedProjectRole")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=SourcedProjectRoleJSON.class)
public class SourcedProjectRoleJSON
extends ProjectRoleJSON
implements SourcedProjectRole {
    @XmlElement(name="sources")
    private List<ProjectRoleSourceJSON> sources;

    public SourcedProjectRoleJSON() {
    }

    public SourcedProjectRoleJSON(@NotNull SourcedProjectRole that) {
        super(that);
        if (that.getSources() != null) {
            ArrayList<ProjectRoleSourceJSON> aggregated = new ArrayList<ProjectRoleSourceJSON>();
            for (ProjectRoleSource projectRoleSource : that.getSources()) {
                aggregated.add(ProjectRoleSourceJSON.wrap(projectRoleSource));
            }
            this.setSources(aggregated);
        }
    }

    public List<ProjectRoleSourceJSON> getSources() {
        return this.sources;
    }

    @XmlTransient
    public void setSources(@Nullable Iterable<ProjectRoleSourceJSON> sources) {
        this.sources = JsonUtils.iterableToList(sources);
    }

    @Nullable
    public static SourcedProjectRoleJSON wrap(@Nullable SourcedProjectRole that) {
        if (that instanceof SourcedProjectRoleJSON) {
            return (SourcedProjectRoleJSON)that;
        }
        if (that != null) {
            return new SourcedProjectRoleJSON(that);
        }
        return null;
    }
}

