/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.dashboard.UserGroupDashboardPermission;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.DashboardPermissionJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="userGroupDashboardPermission")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=UserGroupDashboardPermissionJSON.class)
public class UserGroupDashboardPermissionJSON
extends DashboardPermissionJSON
implements UserGroupDashboardPermission {
    @XmlElement(name="userGroup")
    private UserGroupJSON userGroup;

    public UserGroupDashboardPermissionJSON() {
    }

    public UserGroupDashboardPermissionJSON(@NotNull UserGroupDashboardPermission that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setPermission(that.getPermission());
        if (that.getUserGroup() != null) {
            UserGroupJSON ref = new UserGroupJSON();
            ref.setId(that.getUserGroup().getId());
            this.setUserGroup(ref);
        }
    }

    @Override
    @Nullable
    public UserGroupJSON getUserGroup() {
        return this.userGroup;
    }

    @XmlTransient
    public void setUserGroup(@Nullable UserGroupJSON userGroup) {
        this.userGroup = userGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserGroupDashboardPermission)) {
            return false;
        }
        UserGroupDashboardPermission that = (UserGroupDashboardPermission)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static UserGroupDashboardPermissionJSON wrap(@NotNull UserGroupDashboardPermission that) {
        if (that instanceof UserGroupDashboardPermissionJSON) {
            return (UserGroupDashboardPermissionJSON)that;
        }
        return new UserGroupDashboardPermissionJSON(that);
    }
}

