/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.webapp.servlets;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import jetbrains.ring.servlet.LookupResult;
import jetbrains.ring.servlet.StaticServlet;
import jetbrains.ring.servlet.util.IndexFileHolder;
import jetbrains.ring.servlet.util.ServletUtil;
import jetbrains.youtrack.webapp.servlets.YouTrackIndexHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/webapp/servlets/YouTrackStaticServlet;", "Ljetbrains/ring/servlet/StaticServlet;", "()V", "cacheControl", "", "indexHolder", "Ljetbrains/ring/servlet/util/IndexFileHolder;", "createIndexFileHolder", "welcomePage", "Ljava/net/URL;", "replacePattern", "contextTag", "getFile", "Ljava/io/File;", "path", "init", "", "config", "Ljavax/servlet/ServletConfig;", "isFile", "", "lookupNoCache", "Ljetbrains/ring/servlet/LookupResult;", "req", "Ljavax/servlet/http/HttpServletRequest;", "youtrack-webapp"})
public final class YouTrackStaticServlet
extends StaticServlet {
    private IndexFileHolder indexHolder;
    private String cacheControl;

    public void init(@NotNull ServletConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super.init(config);
        String string = config.getInitParameter("cacheControl");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"config.getInitParameter(CACHE_CONTROL_PARAM)");
        this.cacheControl = string;
    }

    @NotNull
    protected IndexFileHolder createIndexFileHolder(@Nullable URL welcomePage, @Nullable String replacePattern, @Nullable String contextTag, @Nullable String cacheControl) {
        IndexFileHolder indexFileHolder = this.indexHolder = (IndexFileHolder)new YouTrackIndexHolder(welcomePage, replacePattern, contextTag, cacheControl);
        if (indexFileHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"indexHolder");
        }
        return indexFileHolder;
    }

    @NotNull
    protected LookupResult lookupNoCache(@Nullable HttpServletRequest req) {
        LookupResult lookupResult;
        URL e2;
        String path;
        block12: {
            LookupResult lookupResult2;
            block11: {
                path = ServletUtil.getPath((HttpServletRequest)req);
                if (ServletUtil.isForbidden((String)path)) {
                    LookupResult.Error error = LookupResult.FORBIDDEN;
                    Intrinsics.checkExpressionValueIsNotNull((Object)error, (String)"LookupResult.FORBIDDEN");
                    return (LookupResult)error;
                }
                String string = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                if (StringsKt.endsWith$default((String)string, (String)"/", (boolean)false, (int)2, null) || !this.isFile(path)) break block11;
                File file = this.getFile(path);
                if (file != null && file.exists()) break block12;
            }
            try {
                IndexFileHolder indexFileHolder = this.indexHolder;
                if (indexFileHolder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexHolder");
                }
                LookupResult.IndexResource indexResource = indexFileHolder.getIndexResource(req);
                Intrinsics.checkExpressionValueIsNotNull((Object)indexResource, (String)"indexHolder.getIndexResource(req)");
                lookupResult2 = (LookupResult)indexResource;
            }
            catch (Exception e2) {
                LookupResult.Error error = LookupResult.INTERNAL_SERVER_ERROR;
                Intrinsics.checkExpressionValueIsNotNull((Object)error, (String)"LookupResult.INTERNAL_SERVER_ERROR");
                lookupResult2 = (LookupResult)error;
            }
            return lookupResult2;
        }
        try {
            e2 = this.getServletContext().getResource(path);
        }
        catch (MalformedURLException e3) {
            LookupResult.Error error = LookupResult.BAD_REQUEST;
            Intrinsics.checkExpressionValueIsNotNull((Object)error, (String)"LookupResult.BAD_REQUEST");
            return (LookupResult)error;
        }
        URL uRL = e2;
        if (uRL == null) {
            LookupResult.Error error = LookupResult.NOT_FOUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)error, (String)"LookupResult.NOT_FOUND");
            return (LookupResult)error;
        }
        URL url = uRL;
        File file = this.getFile(path);
        if (file != null && file.isFile()) {
            String string = this.getMimeType(path);
            String string2 = this.cacheControl;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheControl");
            }
            lookupResult = (LookupResult)new LookupResult.FileResource(url, file, string, string2);
        } else {
            LookupResult.Error error = LookupResult.NOT_FOUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)error, (String)"LookupResult.NOT_FOUND");
            lookupResult = (LookupResult)error;
        }
        return lookupResult;
    }

    private final boolean isFile(String path) {
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null);
        return dotIndex > 0 && dotIndex > StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null);
    }

    private final File getFile(String path) {
        File file;
        String string = this.getServletContext().getRealPath(path);
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        return file;
    }
}

