/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.saml.dnq.persistence;

import com.onelogin.saml2.Auth;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.dnq.authentication.FederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.State;
import jetbrains.jetpass.auth.module.saml.api.SamlUserDetailsImpl;
import jetbrains.jetpass.auth.module.saml.dnq.persistence.SamlAuthenticationException;
import jetbrains.jetpass.auth.module.saml.dnq.persistence.SamlFederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.saml.dnq.persistence.SamlFederatedAuthenticationHandlerKt;
import jetbrains.jetpass.auth.module.saml.dnq.persistence.XdSamlAuthModule;
import jetbrains.jetpass.auth.module.saml.rest.client.api.SamlUserDetails;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.pojo.api.authority.profile.EmailUtils;
import jetbrains.jetpass.userManagement.persistence.UriConcatenator;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRootService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J5\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0019\u0010\u0013\u001a\u0015\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0017\u00a2\u0006\u0002\b\u0018H\u0016J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001e*\u00020\u001fH\u0002J\u0018\u0010 \u001a\u0004\u0018\u00010\u0010*\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010#\u001a\u0004\u0018\u00010\u0010*\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/jetpass/auth/module/saml/dnq/persistence/SamlFederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/dnq/authentication/FederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/saml/rest/client/api/SamlUserDetails;", "xdAuthModule", "Ljetbrains/jetpass/auth/module/saml/dnq/persistence/XdSamlAuthModule;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/auth/module/saml/dnq/persistence/XdSamlAuthModule;Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "authenticate", "credentials", "Ljetbrains/jetpass/auth/module/dnq/authentication/ServletRequestCredentials;", "buildSamlSettings", "Lcom/onelogin/saml2/settings/Saml2Settings;", "authUrl", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "generateMetadataXml", "", "getReturnUri", "Ljava/net/URI;", "restoreState", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "request", "Ljavax/servlet/http/HttpServletRequest;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "start", "Ljavax/ws/rs/core/Response;", "state", "stateId", "authProviderInitiatedAuthParameters", "", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "getFirstAttribute", "Lcom/onelogin/saml2/Auth;", "attributeName", "getJoinedAttribute", "Companion", "jetbrains.jetpass.auth.module.saml.dnq"})
public final class SamlFederatedAuthenticationHandler
implements FederatedAuthenticationHandler<SamlUserDetails> {
    private final XdSamlAuthModule xdAuthModule;
    private final JetPassDAOContainer container;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response start(@NotNull HttpServletRequest request, @NotNull State state, @NotNull String stateId, @NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)stateId, (String)"stateId");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Saml2Settings settings = this.buildSamlSettings(authUrl);
        try {
            Auth auth = new Auth(settings, request, null);
            String authURI = auth.login(stateId, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
            SamlFederatedAuthenticationHandlerKt.access$setRequestId$p(state, auth.getLastRequestId());
            Response response = Response.seeOther((URI)URI.create(authURI)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(URI.create(authURI)).build()");
            return response;
        }
        catch (Exception e) {
            throw (Throwable)((Object)SamlAuthenticationException.Companion.toAuthenticationException(e));
        }
    }

    @NotNull
    public final String generateMetadataXml(@NotNull AuthUrl authUrl) {
        List errors;
        Object settings;
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        try {
            settings = this.buildSamlSettings(authUrl);
            settings = settings.getSPMetadata();
        }
        catch (Exception e) {
            throw (Throwable)((Object)SamlAuthenticationException.Companion.toAuthenticationException(e));
        }
        Object metadata = settings;
        List list = errors = Saml2Settings.validateMetadata((String)metadata);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"errors");
        Collection collection = list;
        if (!collection.isEmpty()) {
            Object object = CollectionsKt.first((List)errors);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"errors.first()");
            throw (Throwable)((Object)SamlAuthenticationException.Companion.toAuthenticationException((String)object));
        }
        Object object = metadata;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadata");
        return object;
    }

    @NotNull
    public SamlUserDetails authenticate(@NotNull ServletRequestCredentials credentials) throws AuthenticationException {
        SamlUserDetailsImpl samlUserDetailsImpl;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        try {
            Auth auth = new Auth(this.buildSamlSettings(credentials.getAuthUrl()), credentials.getRequest(), null);
            auth.processResponse(SamlFederatedAuthenticationHandlerKt.access$getRequestId$p(credentials.getState()));
        }
        catch (Exception e) {
            throw (Throwable)((Object)SamlAuthenticationException.Companion.toAuthenticationException(e));
        }
        void auth = samlUserDetailsImpl;
        if (!auth.isAuthenticated()) {
            throw (Throwable)((Object)SamlAuthenticationException.Companion.notAuthenticated(auth.getLastErrorReason()));
        }
        SamlUserDetailsImpl $receiver = samlUserDetailsImpl = new SamlUserDetailsImpl();
        $receiver.setAuthModule(this.container.getJetPassAuthModuleDAO().wrapEntity((XdAuthModule)this.xdAuthModule));
        $receiver.setNameId(auth.getNameId());
        String email = this.getFirstAttribute((Auth)auth, this.xdAuthModule.getEmailAttributeName());
        if (email != null) {
            if (EmailUtils.EMAIL_PATTERN.matches((CharSequence)email)) {
                $receiver.setEmail((EmailContact)new EmailContactImpl(email, this.xdAuthModule.isEmailVerified()));
            } else {
                Companion.getLogger().info((Function0)new Function0<String>($receiver){
                    final /* synthetic */ SamlUserDetailsImpl receiver$0;

                    @NotNull
                    public final String invoke() {
                        return "Email for SAML credentials of user \"" + this.receiver$0.getNameId() + "\" was not set because \"email\" is not a correct email address";
                    }
                    {
                        this.receiver$0 = samlUserDetailsImpl;
                        super(0);
                    }
                });
            }
        }
        $receiver.setLogin(this.getFirstAttribute((Auth)auth, this.xdAuthModule.getLoginAttributeName()));
        String fullName = this.getJoinedAttribute((Auth)auth, this.xdAuthModule.getFullNameAttributeName());
        String firstName = this.getJoinedAttribute((Auth)auth, this.xdAuthModule.getFirstNameAttributeName());
        String lastName = this.getJoinedAttribute((Auth)auth, this.xdAuthModule.getLastNameAttributeName());
        $receiver.setFullName(fullName != null ? fullName : (firstName != null && lastName != null ? firstName + ' ' + lastName : (firstName != null ? firstName : (lastName != null ? lastName : null))));
        return (SamlUserDetails)samlUserDetailsImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getFirstAttribute(@NotNull Auth $receiver, String attributeName) {
        String string;
        String string2 = attributeName;
        Object object = string2;
        if (string2 == null) return null;
        String it = string = object;
        List list = (List)$receiver.getAttributes().get(attributeName);
        object = list;
        if (list == null) return null;
        String string3 = (String)CollectionsKt.firstOrNull((List)object);
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getJoinedAttribute(@NotNull Auth $receiver, String attributeName) {
        Object object;
        String string = attributeName;
        Object object2 = string;
        if (string == null) return null;
        Object it = object = object2;
        List list = (List)$receiver.getAttributes().get(attributeName);
        object2 = list;
        if (list == null) return null;
        Sequence sequence = CollectionsKt.asSequence((Iterable)((Iterable)object2));
        object2 = sequence;
        if (sequence == null) return null;
        Sequence sequence2 = SequencesKt.mapNotNull((Sequence)object2, (Function1)getJoinedAttribute.2.INSTANCE);
        object2 = sequence2;
        if (sequence2 == null) return null;
        object = object2;
        it = object;
        if (!SequencesKt.any((Sequence)it)) return null;
        Object object3 = object;
        object2 = object3;
        if (object3 == null) return null;
        String string2 = SequencesKt.joinToString$default((Sequence)object2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        return string2;
    }

    @NotNull
    public URI getReturnUri(@NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        URI uRI = URI.create(authUrl.getFederatedReturnURL(this.xdAuthModule.getUuid()));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(authUrl.getFe\u2026rnURL(xdAuthModule.uuid))");
        return uRI;
    }

    @Nullable
    public State restoreState(@NotNull HttpServletRequest request, @NotNull AuthUrl authUrl, @NotNull Function1<? super String, ? extends State> restoreState) {
        State state;
        String relayState;
        String string;
        String it;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Intrinsics.checkParameterIsNotNull(restoreState, (String)"restoreState");
        String string2 = request.getParameter("RelayState");
        String string3 = string2 != null ? ((charSequence = (CharSequence)(it = (string = string2))).length() > 0 ? string : null) : (relayState = null);
        if (relayState != null) {
            state = (State)restoreState.invoke(relayState);
        } else {
            Map<String, String> map = this.authProviderInitiatedAuthParameters(XdRootService.Companion.getInstance().getHostService());
            URI uRI = URI.create(authUrl.getFederatedReturnURL(this.xdAuthModule.getUuid()));
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(authUrl.getFe\u2026rnURL(xdAuthModule.uuid))");
            state = new State(map, true, uRI, false);
        }
        return state;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Map<String, String> authProviderInitiatedAuthParameters(@NotNull XdService $receiver) {
        Map map;
        String everythingScope2 = SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)XdQueryKt.asSequence((XdQuery)XdService.Companion.all()), (Function1)authProviderInitiatedAuthParameters.everythingScope.1.INSTANCE), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String string = $receiver.getApplicationName();
        if (string != null) {
            switch (string) {
                case "Hub": {
                    map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"response_type", (Object)"token"), TuplesKt.to((Object)"client_id", (Object)$receiver.getUuid()), TuplesKt.to((Object)"scope", (Object)everythingScope2), TuplesKt.to((Object)"redirect_uri", (Object)UriConcatenator.INSTANCE.concat($receiver.getHomeUrl(), "./").toASCIIString())});
                    return map;
                }
                case "YouTrack": {
                    map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"response_type", (Object)"token"), TuplesKt.to((Object)"client_id", (Object)$receiver.getUuid()), TuplesKt.to((Object)"scope", (Object)everythingScope2), TuplesKt.to((Object)"redirect_uri", (Object)UriConcatenator.INSTANCE.concat($receiver.getHomeUrl(), "./oauth").toASCIIString())});
                    return map;
                }
                case "Upsource": {
                    map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"response_type", (Object)"token"), TuplesKt.to((Object)"client_id", (Object)$receiver.getUuid()), TuplesKt.to((Object)"scope", (Object)everythingScope2), TuplesKt.to((Object)"redirect_uri", (Object)UriConcatenator.INSTANCE.concat($receiver.getHomeUrl(), "./").toASCIIString())});
                    return map;
                }
            }
        }
        map = this.authProviderInitiatedAuthParameters((XdService)XdRootService.Companion.getInstance());
        return map;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final Saml2Settings buildSamlSettings(@NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        v0 = this.xdAuthModule.getKey();
        keyPair /* !! */  = v0 != null ? v0.getKeyPair() : null;
        v1 /* !! */  = keyPair /* !! */ ;
        if (v1 /* !! */  == null || (v1 /* !! */  = (PrivateKey)v1 /* !! */ .getFirst()) == null) ** GOTO lbl-1000
        v2 = v1 /* !! */ .getEncoded();
        v1 /* !! */  = (Pair)v2;
        if (v2 != null) {
            it /* !! */  = var4_3 /* !! */  = v1 /* !! */ ;
            v3 = Base64.getEncoder().encodeToString((byte[])it /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v3 = spPrivateKey = null;
        }
        if ((v4 /* !! */  = keyPair /* !! */ ) == null || (v4 /* !! */  = (Certificate)v4 /* !! */ .getSecond()) == null) ** GOTO lbl-1000
        v5 = v4 /* !! */ .getEncoded();
        v4 /* !! */  = (Pair)v5;
        if (v5 != null) {
            var5_4 = v4 /* !! */ ;
            it /* !! */  = var5_4;
            v6 = Base64.getEncoder().encodeToString((byte[])it /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v6 = null;
        }
        spX509Certificate = v6;
        v7 = new Pair[16];
        v7[0] = TuplesKt.to((Object)"onelogin.saml2.strict", (Object)true);
        v7[1] = TuplesKt.to((Object)"onelogin.saml2.debug", (Object)true);
        v7[2] = TuplesKt.to((Object)"onelogin.saml2.sp.entityid", (Object)this.xdAuthModule.getSpEntityId());
        v7[3] = TuplesKt.to((Object)"onelogin.saml2.sp.assertion_consumer_service.url", (Object)this.xdAuthModule.getAcsUrl(authUrl));
        v7[4] = TuplesKt.to((Object)"onelogin.saml2.sp.single_logout_service.url", null);
        v7[5] = TuplesKt.to((Object)"onelogin.saml2.sp.x509cert", (Object)spX509Certificate);
        v7[6] = TuplesKt.to((Object)"onelogin.saml2.sp.privatekey", (Object)spPrivateKey);
        v7[7] = TuplesKt.to((Object)"onelogin.saml2.security.authnrequest_signed", (Object)(keyPair /* !! */  != null));
        v7[8] = TuplesKt.to((Object)"onelogin.saml2.security.logoutrequest_signed", (Object)(keyPair /* !! */  != null));
        v7[9] = TuplesKt.to((Object)"onelogin.saml2.security.logoutresponse_signed", (Object)(keyPair /* !! */  != null));
        v7[10] = TuplesKt.to((Object)"onelogin.saml2.idp.entityid", (Object)this.xdAuthModule.getIdpEntityId());
        v7[11] = TuplesKt.to((Object)"onelogin.saml2.idp.single_sign_on_service.url", (Object)this.xdAuthModule.getUrl());
        var5_4 = StringsKt.replace$default((String)this.xdAuthModule.getCertificateFingerprint(), (String)":", (String)"", (boolean)false, (int)4, null);
        var12_7 = "onelogin.saml2.idp.certfingerprint";
        var11_8 = 12;
        var10_9 = v7;
        var9_10 = v7;
        var8_11 = new SettingsBuilder();
        v8 = var5_4;
        if (v8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v9 = v8.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"(this as java.lang.String).toLowerCase()");
        var13_12 = v9;
        var10_9[var11_8] = TuplesKt.to((Object)var12_7, (Object)var13_12);
        v10 = var9_10;
        var9_10[13] = TuplesKt.to((Object)"onelogin.saml2.idp.certfingerprint_algorithm", (Object)this.xdAuthModule.getCertificateFingerprintAlgorithm());
        v11 = this.xdAuthModule.getContactUser();
        v10[14] = TuplesKt.to((Object)"onelogin.saml2.contacts.technical.given_name", (Object)(v11 != null ? v11.getVisibleName() : null));
        v12 = this.xdAuthModule.getContactUser();
        v10[15] = TuplesKt.to((Object)"onelogin.saml2.contacts.technical.email_address", v12 != null && (v12 = v12.getProfile()) != null && (v12 = v12.getEmail()) != null ? v12.getEmail() : null);
        v13 = var8_11.fromValues(MapsKt.mapOf((Pair[])v10)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"SettingsBuilder().fromVa\u2026.email\n        )).build()");
        return v13;
    }

    public SamlFederatedAuthenticationHandler(@NotNull XdSamlAuthModule xdAuthModule, @NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdAuthModule), (String)"xdAuthModule");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.xdAuthModule = xdAuthModule;
        this.container = container;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/auth/module/saml/dnq/persistence/SamlFederatedAuthenticationHandler$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.auth.module.saml.dnq"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

