/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import org.jetbrains.annotations.NotNull;

public class LZ77 {
    @NotNull
    private final Config config;
    @NotNull
    private final byte[] window;
    private int readCursor;
    private int writeCursor;
    private final NavigableSet<Offset>[] searchTrees;

    public LZ77() {
        this(Config.DEFAULT);
    }

    public LZ77(@NotNull Config config) {
        this.config = config;
        int windowSize = config.getWindowSize();
        this.window = new byte[windowSize];
        this.searchTrees = new NavigableSet[HashUtil.getCeilingPrime(windowSize / 23)];
        this.reset();
    }

    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public Pair<List<Match>, Integer> encode(@NotNull InputStream stream, int count) throws IOException {
        LimitedInputStream limitedInputStream = new LimitedInputStream(stream, count);
        List<Match> matchesList = this.encode(limitedInputStream);
        return new Pair<List<Match>, Integer>(matchesList, limitedInputStream.bytesRead());
    }

    public List<Match> encode(@NotNull InputStream stream) throws IOException {
        int minMatchLength = this.config.getMinMatchLength();
        int maxMatchLength = this.config.getMaxMatchLength();
        int windowSize = this.window.length;
        ArrayList<Match> result = new ArrayList<Match>();
        boolean eof = false;
        block0: while (!eof) {
            int cursorsDiff = this.writeCursor - this.readCursor;
            if (cursorsDiff < 0) {
                cursorsDiff += windowSize;
            }
            while (cursorsDiff < maxMatchLength) {
                int nextByte = stream.read();
                if (nextByte == -1) {
                    eof = true;
                    break;
                }
                this.getSearchTree(this.writeCursor).remove(new RemoveOffset(this.writeCursor));
                this.window[this.writeCursor] = (byte)nextByte;
                int addedOffset = this.writeCursor + windowSize - maxMatchLength;
                if (addedOffset >= windowSize) {
                    addedOffset -= windowSize;
                }
                this.getSearchTree(addedOffset).add(new Offset(addedOffset));
                if (++this.writeCursor == windowSize) {
                    this.writeCursor = 0;
                }
                ++cursorsDiff;
            }
            while (this.readCursor != this.writeCursor) {
                int resultSize;
                int bestMatchLength;
                SearchOffset matchOffset = new SearchOffset(this.readCursor);
                this.getSearchTree(this.readCursor).contains(matchOffset);
                int remainedBytes = this.writeCursor + windowSize - this.readCursor;
                if (remainedBytes >= windowSize) {
                    remainedBytes -= windowSize;
                }
                if ((bestMatchLength = matchOffset.getBestMatchLength()) > remainedBytes) {
                    bestMatchLength = remainedBytes;
                }
                Match lastMatch = (resultSize = result.size()) > 0 ? (Match)result.get(resultSize - 1) : null;
                Match newMatch = null;
                if (bestMatchLength < minMatchLength) {
                    byte b = this.window[this.readCursor];
                    if (lastMatch == null || lastMatch.length != 0 || lastMatch.offset != (b & 0xFF)) {
                        newMatch = new Match(b);
                    }
                    ++this.readCursor;
                } else {
                    int bestMatchOffset = (this.readCursor + windowSize - matchOffset.getBestMatchOffset()) % windowSize;
                    if (lastMatch == null || lastMatch.offset != bestMatchOffset || lastMatch.length != bestMatchLength) {
                        newMatch = new Match(bestMatchOffset, bestMatchLength);
                    }
                    this.readCursor += bestMatchLength;
                }
                if (newMatch != null) {
                    result.add(newMatch);
                } else {
                    lastMatch.repeat();
                }
                if (this.readCursor >= windowSize) {
                    this.readCursor -= windowSize;
                }
                if (eof) continue;
                continue block0;
            }
        }
        return result;
    }

    public Pair<List<Match>, Integer> encodeImmutable(@NotNull InputStream stream, int count) throws IOException {
        LimitedInputStream limitedInputStream = new LimitedInputStream(stream, count);
        List<Match> matchesList = this.encodeImmutable(limitedInputStream);
        return new Pair<List<Match>, Integer>(matchesList, limitedInputStream.bytesRead());
    }

    public List<Match> encodeImmutable(@NotNull InputStream stream) throws IOException {
        int minMatchLength = this.config.getMinMatchLength();
        int maxMatchLength = this.config.getMaxMatchLength();
        int windowSize = this.window.length;
        ArrayList<Match> result = new ArrayList<Match>();
        boolean eof = false;
        block0: while (!eof) {
            int cursorsDiff = this.writeCursor - this.readCursor;
            if (cursorsDiff < 0) {
                cursorsDiff += windowSize;
            }
            while (cursorsDiff < maxMatchLength) {
                int nextByte = stream.read();
                if (nextByte == -1) {
                    eof = true;
                    break;
                }
                this.window[this.writeCursor] = (byte)nextByte;
                if (++this.writeCursor == windowSize) {
                    this.writeCursor = 0;
                }
                ++cursorsDiff;
            }
            while (this.readCursor != this.writeCursor) {
                int resultSize;
                int bestMatchLength;
                SearchOffset matchOffset = new SearchOffset(this.readCursor);
                this.getSearchTree(this.readCursor).contains(matchOffset);
                int remainedBytes = this.writeCursor + windowSize - this.readCursor;
                if (remainedBytes >= windowSize) {
                    remainedBytes -= windowSize;
                }
                if ((bestMatchLength = matchOffset.getBestMatchLength()) > remainedBytes) {
                    bestMatchLength = remainedBytes;
                }
                Match lastMatch = (resultSize = result.size()) > 0 ? (Match)result.get(resultSize - 1) : null;
                Match newMatch = null;
                if (bestMatchLength < minMatchLength) {
                    byte b = this.window[this.readCursor];
                    if (lastMatch == null || lastMatch.length != 0 || lastMatch.offset != (b & 0xFF)) {
                        newMatch = new Match(b);
                    }
                    ++this.readCursor;
                } else {
                    int bestMatchOffset = (this.readCursor + windowSize - matchOffset.getBestMatchOffset()) % windowSize;
                    if (lastMatch == null || lastMatch.offset != bestMatchOffset || lastMatch.length != bestMatchLength) {
                        newMatch = new Match(bestMatchOffset, bestMatchLength);
                    }
                    this.readCursor += bestMatchLength;
                }
                if (newMatch != null) {
                    result.add(newMatch);
                } else {
                    lastMatch.repeat();
                }
                if (this.readCursor >= windowSize) {
                    this.readCursor -= windowSize;
                }
                if (eof) continue;
                continue block0;
            }
        }
        return result;
    }

    public void decode(@NotNull List<Match> matches, @NotNull OutputStream stream) throws IOException {
        int windowSize = this.window.length;
        for (Match match : matches) {
            int matchLength = match.length;
            if (matchLength == 0) {
                int nextByte = match.offset;
                for (int n = 0; n < match.count; ++n) {
                    stream.write(nextByte);
                    this.window[this.writeCursor] = (byte)nextByte;
                    if (++this.writeCursor != windowSize) continue;
                    this.writeCursor = 0;
                }
                continue;
            }
            for (int n = 0; n < match.count; ++n) {
                int offset = (this.writeCursor + windowSize - match.offset) % windowSize;
                for (int i = 0; i < matchLength; ++i) {
                    byte nextByte = this.window[offset];
                    stream.write(nextByte & 0xFF);
                    this.window[this.writeCursor] = nextByte;
                    if (++this.writeCursor == windowSize) {
                        this.writeCursor = 0;
                    }
                    if (++offset != windowSize) continue;
                    offset = 0;
                }
            }
        }
    }

    public int fillForEncode(@NotNull InputStream stream, int count) throws IOException {
        int nextByte;
        int i;
        int windowSize = this.window.length;
        int writeCursorSaved = this.writeCursor;
        for (i = 0; i < count && (nextByte = stream.read()) != -1; ++i) {
            this.window[this.writeCursor] = (byte)nextByte;
            if (++this.writeCursor != windowSize) continue;
            this.writeCursor = 0;
        }
        this.readCursor = this.writeCursor;
        int maxMatchLen = this.config.getMaxMatchLength();
        for (int j = 0; j < i - maxMatchLen; ++j) {
            this.getSearchTree(writeCursorSaved).add(new Offset(writeCursorSaved));
            if (++writeCursorSaved != windowSize) continue;
            writeCursorSaved = 0;
        }
        return i;
    }

    public int fillForDecode(@NotNull InputStream stream, int count) throws IOException {
        int nextByte;
        int i;
        int windowSize = this.window.length;
        for (i = 0; i < count && (nextByte = stream.read()) != -1; ++i) {
            this.window[this.writeCursor] = (byte)nextByte;
            if (++this.writeCursor != windowSize) continue;
            this.writeCursor = 0;
        }
        return i;
    }

    public void reset() {
        int i;
        this.writeCursor = 0;
        this.readCursor = 0;
        int f1 = 0;
        int f2 = 1;
        for (i = 0; i < this.window.length; ++i) {
            int t = f2;
            if ((f2 += f1) >= 63997) {
                f2 -= 63997;
            }
            f1 = t;
            this.window[i] = (byte)f2;
        }
        for (i = 0; i < this.searchTrees.length; ++i) {
            this.searchTrees[i] = new TreeSet<Offset>();
        }
    }

    private NavigableSet<Offset> getSearchTree(int offset) {
        int windowSize = this.window.length;
        int minMatchLen = this.config.getMinMatchLength();
        int n = 0;
        int j = offset;
        for (int i = 0; i < minMatchLen; ++i) {
            n = n * 251 + (this.window[j] & 0xFF);
            if (++j != windowSize) continue;
            j = 0;
        }
        return this.searchTrees[(n & Integer.MAX_VALUE) % this.searchTrees.length];
    }

    private static class LimitedInputStream
    extends InputStream {
        @NotNull
        private final InputStream decorated;
        private final int bytesToRead;
        private int bytesRead;

        private LimitedInputStream(@NotNull InputStream decorated, int bytesToRead) {
            this.decorated = decorated;
            this.bytesToRead = bytesToRead;
            this.bytesRead = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRead >= this.bytesToRead) {
                return -1;
            }
            int result = this.decorated.read();
            if (result >= 0) {
                ++this.bytesRead;
            }
            return result;
        }

        public int bytesRead() {
            return this.bytesRead;
        }
    }

    private class RemoveOffset
    extends Offset {
        private RemoveOffset(int offset) {
            super(offset);
        }

        @Override
        public int compareTo(Offset right) {
            int result = super.compareTo(right);
            return result != 0 ? result : this.offset - right.offset;
        }
    }

    private class SearchOffset
    extends Offset {
        private int bestMatchOffset;
        private int bestMatchLength;

        private SearchOffset(int offset) {
            super(offset);
            this.bestMatchLength = 0;
            this.bestMatchOffset = 0;
        }

        public int getBestMatchOffset() {
            return this.bestMatchOffset;
        }

        public int getBestMatchLength() {
            return this.bestMatchLength;
        }

        @Override
        protected void updateBestMatch(int matchOffset, int matchLength) {
            if (this.bestMatchLength < matchLength) {
                this.bestMatchLength = matchLength;
                this.bestMatchOffset = matchOffset;
            }
        }
    }

    private class Offset
    implements Comparable<Offset> {
        protected final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }

        @Override
        public int compareTo(Offset right) {
            int result;
            if (right instanceof RemoveOffset) {
                return -right.compareTo(this);
            }
            int maxMatchLength = LZ77.this.config.getMaxMatchLength();
            int thisOffset = this.offset;
            int rightOffset = right.offset;
            if (thisOffset == rightOffset) {
                return 0;
            }
            int windowSize = LZ77.this.window.length;
            int i = 0;
            if (thisOffset + maxMatchLength <= windowSize && rightOffset + maxMatchLength <= windowSize) {
                while ((result = LZ77.this.window[thisOffset] - LZ77.this.window[rightOffset]) == 0 && ++i != maxMatchLength) {
                    ++thisOffset;
                    ++rightOffset;
                }
            } else {
                while ((result = LZ77.this.window[thisOffset] - LZ77.this.window[rightOffset]) == 0) {
                    if (++thisOffset == windowSize) {
                        thisOffset = 0;
                    }
                    if (++rightOffset == windowSize) {
                        rightOffset = 0;
                    }
                    if (++i < maxMatchLength) continue;
                }
            }
            this.updateBestMatch(right.offset, i);
            right.updateBestMatch(this.offset, i);
            return result;
        }

        protected void updateBestMatch(int matchOffset, int matchLength) {
        }
    }

    public static final class Match {
        public final int offset;
        public final int length;
        public int count;

        public Match(byte b) {
            this.offset = b & 0xFF;
            this.length = 0;
            this.count = 1;
        }

        public Match(int offset, int length) {
            this.offset = offset;
            this.length = length;
            this.count = 1;
        }

        public void repeat() {
            ++this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    public static final class Config {
        public static final Config DEFAULT = new Config();
        private static final int MIN_MIN_MATCH_LEN = 2;
        private static final int MAX_MIN_MATCH_LEN = 16;
        private static final int MIN_MAX_MATCH_LEN = 4;
        private static final int MAX_MAX_MATCH_LEN = 1024;
        private static final int MIN_WINDOW_SIZE = 16;
        private static final int MAX_WINDOW_SIZE = 0x1000000;
        private int minMatchLength = 4;
        private int maxMatchLength = 259;
        private int windowSize = 65536;

        public int getMinMatchLength() {
            return this.minMatchLength;
        }

        public void setMinMatchLength(int minMatchLength) {
            if (minMatchLength > this.maxMatchLength) {
                throw new IllegalArgumentException("Minimum match length cannot be greater than maximum match length");
            }
            if (minMatchLength < 2) {
                throw new IllegalArgumentException("Minimum match length cannot be less than 2");
            }
            if (minMatchLength > 16) {
                throw new IllegalArgumentException("Minimum match length cannot be greater than 16");
            }
            this.minMatchLength = minMatchLength;
        }

        public int getMaxMatchLength() {
            return this.maxMatchLength;
        }

        public void setMaxMatchLength(int maxMatchLength) {
            if (maxMatchLength < this.minMatchLength) {
                throw new IllegalArgumentException("Maximum match length cannot be less than minimum match length");
            }
            if (maxMatchLength > this.windowSize / 2) {
                throw new IllegalArgumentException("Maximum match length cannot be greater than half of window size");
            }
            if (maxMatchLength < 4) {
                throw new IllegalArgumentException("Maximum match length cannot be less than 4");
            }
            if (maxMatchLength > 1024) {
                throw new IllegalArgumentException("Maximum match length cannot be greater than 1024");
            }
            this.maxMatchLength = maxMatchLength;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public void setWindowSize(int windowSize) {
            if (windowSize < this.maxMatchLength || windowSize < 16 || windowSize > 0x1000000) {
                throw new IllegalArgumentException();
            }
            this.windowSize = windowSize;
        }
    }
}

