/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.PriorityQueue;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrentStablePriorityQueue<P extends Comparable<? super P>, E>
extends PriorityQueue<P, E> {
    private final AtomicReference<Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>>> rootPair = new AtomicReference();

    @Override
    public boolean isEmpty() {
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> currentPair = this.getCurrent();
        return currentPair == null || currentPair.getFirst().isEmpty();
    }

    @Override
    public int size() {
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> currentPair = this.getCurrent();
        return currentPair == null ? 0 : currentPair.getFirst().size();
    }

    @Override
    public E push(@NotNull P priority, @NotNull E value) {
        Object result;
        PersistentHashSet<Object> values;
        Persistent23Tree<Object> queue;
        Pair<Persistent23Tree<Object>, PersistentHashSet<Object>> newPair;
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> currentPair;
        do {
            PersistentHashSet.MutablePersistentHashSet<Object> mutableValues;
            Persistent23Tree.MutableTree<Object> mutableQueue;
            result = null;
            currentPair = this.getCurrent();
            TreeNode node = new TreeNode((Comparable)priority, value, null);
            IdentifiedTreeNode idNode = new IdentifiedTreeNode(node);
            if (currentPair == null) {
                queue = new Persistent23Tree();
                values = new PersistentHashSet();
                mutableQueue = queue.beginWrite();
                mutableValues = values.beginWrite();
            } else {
                queue = currentPair.getFirst().getClone();
                values = currentPair.getSecond().getClone();
                mutableQueue = queue.beginWrite();
                mutableValues = values.beginWrite();
                IdentifiedTreeNode oldIdNode = mutableValues.getKey(idNode);
                if (oldIdNode != null) {
                    TreeNode oldNode = oldIdNode.node;
                    result = oldNode.value;
                    mutableValues.remove(oldIdNode);
                    mutableQueue.exclude(oldNode);
                }
            }
            mutableQueue.add(node);
            mutableValues.add(idNode);
            mutableQueue.endWrite();
            mutableValues.endWrite();
        } while (!this.rootPair.compareAndSet(currentPair, newPair = new Pair<Persistent23Tree<Object>, PersistentHashSet<Object>>(queue, values)));
        return (E)result;
    }

    @Override
    public Pair<P, E> peekPair() {
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> currentPair = this.getCurrent();
        if (currentPair == null) {
            return null;
        }
        TreeNode max = (TreeNode)currentPair.getFirst().getMaximum();
        return max == null ? null : new Pair<Comparable, Object>(max.priority, max.value);
    }

    @Override
    @Nullable
    public Pair<P, E> floorPair() {
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> currentPair = this.getCurrent();
        if (currentPair == null) {
            return null;
        }
        TreeNode min = (TreeNode)currentPair.getFirst().getMinimum();
        return min == null ? null : new Pair<Comparable, Object>(min.priority, min.value);
    }

    @Override
    public E pop() {
        Object result;
        PersistentHashSet<IdentifiedTreeNode<P, E>> values;
        Persistent23Tree<TreeNode<P, E>> queue;
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> newPair;
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> currentPair;
        do {
            result = null;
            currentPair = this.getCurrent();
            if (currentPair == null) break;
            queue = currentPair.getFirst().getClone();
            values = currentPair.getSecond().getClone();
            Persistent23Tree.MutableTree<TreeNode<P, E>> mutableQueue = queue.beginWrite();
            PersistentHashSet.MutablePersistentHashSet<IdentifiedTreeNode<P, E>> mutableValues = values.beginWrite();
            TreeNode max = (TreeNode)mutableQueue.getMaximum();
            if (max == null) break;
            mutableQueue.exclude(max);
            mutableValues.remove(new IdentifiedTreeNode(max));
            result = max.value;
            mutableQueue.endWrite();
            mutableValues.endWrite();
        } while (!this.rootPair.compareAndSet(currentPair, newPair = queue.isEmpty() ? null : new Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>>(queue, values)));
        return (E)result;
    }

    @Override
    public void clear() {
        this.rootPair.set(null);
    }

    @Override
    public Iterator<E> iterator() {
        Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> currentPair = this.getCurrent();
        if (currentPair == null) {
            List objects = Collections.emptyList();
            return objects.iterator();
        }
        final Iterator iterator = currentPair.getFirst().iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return ((TreeNode)iterator.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Nullable
    private Pair<Persistent23Tree<TreeNode<P, E>>, PersistentHashSet<IdentifiedTreeNode<P, E>>> getCurrent() {
        return this.rootPair.get();
    }

    private static class IdentifiedTreeNode<P extends Comparable<? super P>, E> {
        @NotNull
        private final TreeNode<P, E> node;

        private IdentifiedTreeNode(@NotNull TreeNode<P, E> node) {
            this.node = node;
        }

        public int hashCode() {
            return ((TreeNode)this.node).value.hashCode();
        }

        public boolean equals(Object obj) {
            IdentifiedTreeNode o = (IdentifiedTreeNode)obj;
            return ((TreeNode)this.node).value.equals(((TreeNode)o.node).value);
        }
    }

    private static class TreeNode<P extends Comparable<? super P>, E>
    implements Comparable<TreeNode<P, E>> {
        private static final AtomicInteger orderCounter = new AtomicInteger(Integer.MAX_VALUE);
        private final P priority;
        private final int samePriorityOrder;
        private final E value;

        private TreeNode(P priority, int samePriorityOrder, E value) {
            this.priority = priority;
            this.samePriorityOrder = samePriorityOrder;
            this.value = value;
        }

        private TreeNode(P priority, E value) {
            this(priority, orderCounter.getAndDecrement(), value);
        }

        @Override
        public int compareTo(TreeNode<P, E> o) {
            int result = this.priority.compareTo(o.priority);
            if (result == 0) {
                result = this.samePriorityOrder - o.samePriorityOrder;
            }
            return result;
        }

        /* synthetic */ TreeNode(Comparable x0, Object x1, 1 x2) {
            this(x0, x1);
        }
    }
}

