/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import jetbrains.exodus.core.dataStructures.CacheHitRateable;
import org.jetbrains.annotations.NotNull;

public abstract class LongObjectCacheBase<V>
extends CacheHitRateable {
    public static final int DEFAULT_SIZE = 8192;
    public static final int MIN_SIZE = 4;
    static final CriticalSection TRIVIAL_CRITICAL_SECTION = new CriticalSection(){

        @Override
        public void close() {
        }
    };
    protected final int size;

    protected LongObjectCacheBase(int size) {
        this.size = Math.max(4, size);
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean containsKey(long key) {
        return this.isCached(key);
    }

    public V get(long key) {
        return this.tryKey(key);
    }

    public V put(long key, V value) {
        V oldValue = this.tryKey(key);
        if (oldValue != null) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public V tryKeyLocked(long key) {
        try (CriticalSection ignored = this.newCriticalSection();){
            V v = this.tryKey(key);
            return v;
        }
    }

    public abstract void clear();

    public abstract void lock();

    public abstract void unlock();

    public abstract V cacheObject(long var1, @NotNull V var3);

    public abstract V remove(long var1);

    public abstract V tryKey(long var1);

    public abstract V getObject(long var1);

    public boolean isCached(long key) {
        return this.getObject(key) != null;
    }

    public abstract int count();

    public int size() {
        return this.size;
    }

    @Override
    public void adjustHitRate() {
        try (CriticalSection ignored = this.newCriticalSection();){
            super.adjustHitRate();
        }
    }

    public CriticalSection newCriticalSection() {
        this.lock();
        return new CriticalSection(){

            @Override
            public void close() {
                LongObjectCacheBase.this.unlock();
            }
        };
    }

    public static interface CriticalSection
    extends AutoCloseable {
        @Override
        public void close();
    }
}

