/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.lang.ref.SoftReference;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.SoftObjectCacheBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftLongObjectCache<V>
extends LongObjectCacheBase<V> {
    public static final int DEFAULT_SIZE = 4096;
    public static final int MIN_SIZE = 16;
    private final SoftReference<LongObjectCache<V>>[] chunks;
    private final int chuckSize;

    public SoftLongObjectCache() {
        this(4096);
    }

    public SoftLongObjectCache(int cacheSize) {
        super(cacheSize);
        if (cacheSize < 16) {
            cacheSize = 16;
        }
        this.chunks = new SoftReference[SoftObjectCacheBase.computeNumberOfChunks(cacheSize)];
        this.chuckSize = cacheSize / this.chunks.length;
        this.clear();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.chunks.length; ++i) {
            this.chunks[i] = null;
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public V tryKey(long key) {
        V result;
        this.incAttempts();
        LongObjectCache<V> chunk = this.getChunk(key, false);
        V v = result = chunk == null ? null : (V)chunk.tryKey(key);
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    @Override
    public V getObject(long key) {
        LongObjectCache<V> chunk = this.getChunk(key, false);
        return chunk == null ? null : (V)chunk.getObject(key);
    }

    @Override
    public V cacheObject(long key, @NotNull V value) {
        LongObjectCache<V> chunk = this.getChunk(key, true);
        assert (chunk != null);
        return chunk.cacheObject(key, value);
    }

    @Override
    public V remove(long key) {
        LongObjectCache<V> chunk = this.getChunk(key, false);
        return chunk == null ? null : (V)chunk.remove(key);
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongObjectCacheBase.CriticalSection newCriticalSection() {
        return TRIVIAL_CRITICAL_SECTION;
    }

    @Nullable
    private LongObjectCache<V> getChunk(long key, boolean create) {
        LongObjectCache<V> result;
        int chunkIndex = (int)((key & Long.MAX_VALUE) % (long)this.chunks.length);
        SoftReference<LongObjectCache<V>> ref = this.chunks[chunkIndex];
        LongObjectCache<V> longObjectCache = result = ref == null ? null : ref.get();
        if (result == null && create) {
            result = new LongObjectCache(this.chuckSize);
            this.chunks[chunkIndex] = new SoftReference<LongObjectCache<V>>(result);
        }
        return result;
    }
}

