/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.PriorityQueue;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class StablePriorityQueue<P extends Comparable<? super P>, E>
extends PriorityQueue<P, E> {
    private final TreeMap<P, LinkedHashSet<E>> theQueue = new TreeMap();
    private final Map<E, Pair<E, P>> priorities = new HashMap<E, Pair<E, P>>();
    private final Lock lock = new ReentrantLock();

    @Override
    public boolean isEmpty() {
        this.lock();
        try {
            boolean bl = this.priorities.isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int size() {
        this.lock();
        try {
            int n = this.priorities.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public E push(@NotNull P priority, @NotNull E value) {
        LinkedHashSet<E> values;
        E oldValue;
        Pair<E, P> oldPair = this.priorities.put(value, new Pair<E, P>(value, priority));
        Comparable oldPriority = oldPair == null ? null : (Comparable)oldPair.getSecond();
        E e = oldValue = oldPair == null ? null : (E)oldPair.getFirst();
        if (oldPriority != null && (values = this.theQueue.get(oldPriority)) != null) {
            values.remove(value);
            if (values.isEmpty()) {
                this.theQueue.remove(oldPriority);
            }
        }
        if ((values = this.theQueue.get(priority)) == null) {
            values = new LinkedHashSet();
            this.theQueue.put(priority, values);
        }
        values.add(value);
        return oldValue;
    }

    @Override
    public Pair<P, E> peekPair() {
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<P, LinkedHashSet<E>> queue = this.theQueue;
        Comparable priority = (Comparable)queue.lastKey();
        LinkedHashSet<E> values = queue.get(priority);
        return new Pair<Comparable, E>(priority, values.getBack());
    }

    @Override
    public Pair<P, E> floorPair() {
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<P, LinkedHashSet<E>> queue = this.theQueue;
        Comparable priority = (Comparable)queue.firstKey();
        LinkedHashSet<E> values = queue.get(priority);
        return new Pair<Comparable, E>(priority, values.getTop());
    }

    @Override
    public E pop() {
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<P, LinkedHashSet<E>> queue = this.theQueue;
        Comparable priority = (Comparable)queue.lastKey();
        Set values = queue.get(priority);
        Object result = values.iterator().next();
        this.priorities.remove(result);
        values.remove(result);
        if (values.isEmpty()) {
            queue.remove(priority);
        }
        return result;
    }

    @Override
    public void clear() {
        this.theQueue.clear();
        this.priorities.clear();
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    public boolean remove(@NotNull E value) {
        Pair<E, P> pair = this.priorities.remove(value);
        if (pair == null) {
            return false;
        }
        Comparable priority = (Comparable)pair.getSecond();
        LinkedHashSet<E> values = this.theQueue.get(priority);
        values.remove(value);
        if (values.isEmpty()) {
            this.theQueue.remove(priority);
        }
        return true;
    }

    private class QueueIterator
    implements Iterator<E> {
        @NotNull
        private final Iterator<Map.Entry<P, LinkedHashSet<E>>> priorityIt;
        @NotNull
        private Iterator<E> currentIt;

        private QueueIterator() {
            this.priorityIt = StablePriorityQueue.this.theQueue.entrySet().iterator();
            this.currentIt = Collections.EMPTY_LIST.iterator();
            this.checkCurrentIterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentIt.hasNext();
        }

        @Override
        public E next() {
            Object result = this.currentIt.next();
            this.checkCurrentIterator();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkCurrentIterator() {
            while (!this.currentIt.hasNext() && this.priorityIt.hasNext()) {
                Map.Entry next = this.priorityIt.next();
                this.currentIt = next.getValue().iterator();
            }
        }
    }
}

