/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLong23TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentLinkedHashMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(PersistentLinkedHashMap.class);
    @Nullable
    private volatile Pair<PersistentHashMap<K, InternalValue<V>>, PersistentLong23TreeMap<K>> root;
    @NotNull
    private final AtomicLong orderCounter;
    @Nullable
    private final RemoveEldestFunction<K, V> removeEldest;

    public PersistentLinkedHashMap() {
        this.root = null;
        this.orderCounter = new AtomicLong();
        this.removeEldest = null;
    }

    public PersistentLinkedHashMap(@Nullable RemoveEldestFunction<K, V> removeEldest) {
        this.root = null;
        this.orderCounter = new AtomicLong();
        this.removeEldest = removeEldest;
    }

    private PersistentLinkedHashMap(@NotNull PersistentLinkedHashMap<K, V> source) {
        Pair<PersistentHashMap<K, InternalValue<V>>, PersistentLong23TreeMap<K>> sourceRoot = source.root;
        this.root = sourceRoot == null ? new Pair(new PersistentHashMap(), new PersistentLong23TreeMap()) : new Pair<PersistentHashMap<K, InternalValue<V>>, PersistentLong23TreeMap<K>>(sourceRoot.getFirst().getClone(), sourceRoot.getSecond().getClone());
        this.orderCounter = source.orderCounter;
        this.removeEldest = source.removeEldest;
    }

    public int size() {
        Pair<PersistentHashMap<K, InternalValue<V>>, PersistentLong23TreeMap<K>> root = this.root;
        return root == null ? 0 : root.getFirst().getCurrent().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public PersistentLinkedHashMap<K, V> getClone() {
        return new PersistentLinkedHashMap<K, V>(this);
    }

    public PersistentLinkedHashMapMutable<K, V> beginWrite() {
        return new PersistentLinkedHashMapMutable(this);
    }

    public boolean endWrite(@NotNull PersistentLinkedHashMapMutable<K, V> mutableMap) {
        if (!mutableMap.isDirty() || mutableMap.getSourceRoot() != this.root) {
            return false;
        }
        mutableMap.getMapMutable().endWrite();
        mutableMap.getQueueMutable().endWrite();
        this.root = new Pair<PersistentHashMap<K, InternalValue<V>>, PersistentLong23TreeMap<K>>(mutableMap.getMap(), mutableMap.getQueue());
        return true;
    }

    private static void logMapIsInconsistent() {
        logger.error("PersistentLinkedHashMap is inconsistent", new Throwable());
    }

    private static class InternalValue<V> {
        private final long order;
        private final V value;

        InternalValue(long order, V value) {
            this.order = order;
            this.value = value;
        }

        public long getOrder() {
            return this.order;
        }

        public V getValue() {
            return this.value;
        }
    }

    public static interface RemoveEldestFunction<K, V> {
        public boolean removeEldest(@NotNull PersistentLinkedHashMapMutable<K, V> var1, @NotNull K var2, @Nullable V var3);
    }

    public static class PersistentLinkedHashMapMutable<K, V>
    implements Iterable<Pair<K, V>> {
        @Nullable
        private final Pair<PersistentHashMap<K, InternalValue<V>>, PersistentLong23TreeMap<K>> sourceRoot;
        @NotNull
        private final AtomicLong orderCounter;
        @Nullable
        private final RemoveEldestFunction<K, V> removeEldest;
        @NotNull
        private final PersistentHashMap<K, InternalValue<V>> map;
        @NotNull
        private final PersistentHashMap.MutablePersistentHashMap mapMutable;
        @NotNull
        private final PersistentLong23TreeMap<K> queue;
        @NotNull
        private final PersistentLong23TreeMap.MutableMap queueMutable;
        private boolean isDirty;

        public PersistentLinkedHashMapMutable(PersistentLinkedHashMap<K, V> source) {
            this.sourceRoot = ((PersistentLinkedHashMap)source).root;
            this.orderCounter = ((PersistentLinkedHashMap)source).orderCounter;
            this.removeEldest = ((PersistentLinkedHashMap)source).removeEldest;
            if (this.sourceRoot == null) {
                this.map = new PersistentHashMap();
                this.queue = new PersistentLong23TreeMap();
            } else {
                this.map = this.sourceRoot.getFirst();
                this.queue = this.sourceRoot.getSecond();
            }
            this.mapMutable = this.map.beginWrite();
            this.queueMutable = this.queue.beginWrite();
            this.isDirty = false;
        }

        @Nullable
        public V get(@NotNull K key) {
            InternalValue internalValue = (InternalValue)this.mapMutable.get(key);
            if (internalValue == null) {
                return null;
            }
            Object result = internalValue.getValue();
            long currentOrder = internalValue.getOrder();
            if (this.orderCounter.get() > currentOrder + (long)(this.mapMutable.size() >> 1)) {
                this.isDirty = true;
                long newOrder = this.orderCounter.incrementAndGet();
                this.mapMutable.put(key, new InternalValue(newOrder, result));
                this.queueMutable.put(newOrder, key);
                if (!key.equals(this.queueMutable.remove(currentOrder))) {
                    PersistentLinkedHashMap.logMapIsInconsistent();
                }
            }
            return result;
        }

        @Nullable
        public V getValue(@NotNull K key) {
            InternalValue internalValue = (InternalValue)this.mapMutable.get(key);
            return internalValue == null ? null : (V)internalValue.getValue();
        }

        public boolean containsKey(@NotNull K key) {
            return this.mapMutable.get(key) != null;
        }

        public void put(@NotNull K key, @Nullable V value) {
            Object eldestKey;
            PersistentLong23TreeMap.Entry min;
            InternalValue internalValue = (InternalValue)this.mapMutable.get(key);
            if (internalValue != null && !key.equals(this.queueMutable.remove(internalValue.getOrder()))) {
                PersistentLinkedHashMap.logMapIsInconsistent();
            }
            this.isDirty = true;
            long newOrder = this.orderCounter.incrementAndGet();
            this.mapMutable.put(key, new InternalValue<V>(newOrder, value));
            this.queueMutable.put(newOrder, key);
            if (this.removeEldest != null && (min = (PersistentLong23TreeMap.Entry)this.queueMutable.getMinimum()) != null && this.removeEldest.removeEldest(this, eldestKey = min.getValue(), this.getValue(eldestKey))) {
                this.remove(eldestKey);
            }
        }

        public V remove(@NotNull K key) {
            InternalValue internalValue = (InternalValue)this.mapMutable.removeKey(key);
            if (internalValue != null) {
                this.isDirty = true;
                if (!key.equals(this.queueMutable.remove(internalValue.getOrder()))) {
                    PersistentLinkedHashMap.logMapIsInconsistent();
                }
                return internalValue.getValue();
            }
            return null;
        }

        public int size() {
            return this.mapMutable.size();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void forEachKey(final ObjectProcedure<K> procedure) {
            this.mapMutable.forEachKey(new ObjectProcedure<PersistentHashMap.Entry<K, InternalValue<V>>>(){

                @Override
                public boolean execute(PersistentHashMap.Entry<K, InternalValue<V>> object) {
                    return procedure.execute(object.getKey());
                }
            });
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        @Override
        public Iterator<Pair<K, V>> iterator() {
            final Iterator sourceIt = this.mapMutable.iterator();
            return new Iterator<Pair<K, V>>(){

                @Override
                public boolean hasNext() {
                    return sourceIt.hasNext();
                }

                @Override
                public Pair<K, V> next() {
                    PersistentHashMap.Entry next = (PersistentHashMap.Entry)sourceIt.next();
                    return new Pair(next.getKey(), ((InternalValue)next.getValue()).getValue());
                }

                @Override
                public void remove() {
                    sourceIt.remove();
                }
            };
        }

        @Nullable
        public Pair<PersistentHashMap<K, InternalValue<V>>, PersistentLong23TreeMap<K>> getSourceRoot() {
            return this.sourceRoot;
        }

        @NotNull
        public PersistentHashMap<K, InternalValue<V>> getMap() {
            return this.map;
        }

        @NotNull
        public PersistentHashMap.MutablePersistentHashMap getMapMutable() {
            return this.mapMutable;
        }

        @NotNull
        public PersistentLong23TreeMap<K> getQueue() {
            return this.queue;
        }

        @NotNull
        public PersistentLong23TreeMap.MutableMap getQueueMutable() {
            return this.queueMutable;
        }

        void checkTip() {
            this.mapMutable.checkTip();
            this.queueMutable.checkTip();
        }
    }
}

