/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentLong23TreeMap<V> {
    private final Persistent23Tree<Entry<V>> set;

    public PersistentLong23TreeMap() {
        this(null);
    }

    PersistentLong23TreeMap(@Nullable AbstractPersistent23Tree.RootNode<Entry<V>> root) {
        this.set = new Persistent23Tree<Entry<V>>(root);
    }

    public ImmutableMap beginRead() {
        return new ImmutableMap();
    }

    public PersistentLong23TreeMap<V> getClone() {
        return new PersistentLong23TreeMap<V>(this.set.getRoot());
    }

    public MutableMap beginWrite() {
        return new MutableMap();
    }

    public boolean endWrite(MutableMap tree) {
        return this.set.endWrite(tree);
    }

    public Entry<V> createEntry(long key) {
        return new Entry(key);
    }

    public static class Entry<V>
    implements Comparable<Entry<V>> {
        private final long key;
        private final V value;

        Entry(long k) {
            this(k, null);
        }

        Entry(long k, @Nullable V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public int compareTo(Entry<V> o) {
            return this.key > o.key ? 1 : (this.key == o.key ? 0 : -1);
        }

        public V getValue() {
            return this.value;
        }

        public long getKey() {
            return this.key;
        }
    }

    public class MutableMap
    extends Persistent23Tree.MutableTree<Entry<V>> {
        MutableMap() {
            super(PersistentLong23TreeMap.this.set);
        }

        public V get(long key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            if (root == null) {
                return null;
            }
            Entry entry = root.get(new Entry(key));
            return entry == null ? null : (Object)entry.getValue();
        }

        public boolean containsKey(long key) {
            return this.get(key) != null;
        }

        public void put(long key, @NotNull V value) {
            this.add(new Entry(key, value));
        }

        public V remove(long key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            if (root == null) {
                return null;
            }
            Pair removeResult = root.remove(new Entry(key), true);
            if (removeResult == null) {
                return null;
            }
            AbstractPersistent23Tree.Node res = removeResult.getFirst();
            if (res instanceof AbstractPersistent23Tree.RemovedNode) {
                res = res.getFirstChild();
            }
            root = res == null ? null : res.asRoot(root.getSize() - 1);
            this.setRoot(root);
            return removeResult.getSecond().getValue();
        }
    }

    public class ImmutableMap
    extends Persistent23Tree.ImmutableTree<Entry<V>> {
        ImmutableMap() {
            super(PersistentLong23TreeMap.this.set.getRoot());
        }

        public V get(long key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            if (root == null) {
                return null;
            }
            Entry entry = root.get(new Entry(key));
            return entry == null ? null : (Object)entry.getValue();
        }

        public boolean containsKey(long key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            return root != null && root.get(new Entry(key)) != null;
        }
    }
}

