/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.CacheHitRateable;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentObjectCache<K, V>
extends CacheHitRateable {
    private final int size;
    private final int firstGenSizeBound;
    private final int secondGenSizeBound;
    private final AtomicReference<Root<K, V>> root;

    public PersistentObjectCache() {
        this(8192);
    }

    public PersistentObjectCache(int size) {
        this(size, 0.5f);
    }

    public PersistentObjectCache(int size, float secondGenSizeRatio) {
        int n = this.size = size < 4 ? 4 : size;
        if (secondGenSizeRatio < 0.05f) {
            secondGenSizeRatio = 0.05f;
        } else if (secondGenSizeRatio > 0.95f) {
            secondGenSizeRatio = 0.95f;
        }
        this.secondGenSizeBound = (int)((float)size * secondGenSizeRatio);
        this.firstGenSizeBound = size - this.secondGenSizeBound;
        this.root = new AtomicReference();
    }

    protected PersistentObjectCache(@NotNull PersistentObjectCache<K, V> source) {
        this.size = source.size;
        this.firstGenSizeBound = source.firstGenSizeBound;
        this.secondGenSizeBound = source.secondGenSizeBound;
        this.root = new AtomicReference<Root<K, Root<K, V>>>(source.root.get());
        this.setAttempts(source.getAttempts());
        this.setHits(source.getHits());
    }

    public void clear() {
        this.root.set(null);
    }

    public int size() {
        return this.size;
    }

    public int count() {
        Root<K, V> root = this.getCurrent();
        return root == null ? 0 : root.getFirstGen().size() + root.getSecondGen().size();
    }

    public V get(@NotNull K key) {
        return this.tryKey(key);
    }

    public void put(@NotNull K key, @NotNull V x) {
        this.cacheObject(key, x);
    }

    public V tryKey(@NotNull K key) {
        Object result;
        Root next;
        Root<K, V> current;
        this.incAttempts();
        do {
            current = this.getCurrent();
            next = new Root(current, this.firstGenSizeBound, this.secondGenSizeBound);
            PersistentLinkedHashMap secondGen = next.getSecondGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable secondGenMutable = secondGen.beginWrite();
            result = secondGenMutable.get(key);
            boolean wereMutations = secondGenMutable.isDirty();
            if (result == null) {
                PersistentLinkedHashMap firstGen = next.getFirstGen();
                PersistentLinkedHashMap.PersistentLinkedHashMapMutable firstGenMutable = firstGen.beginWrite();
                result = firstGenMutable.get(key);
                if (!firstGenMutable.isDirty() && firstGenMutable.size() >= this.firstGenSizeBound >> 1 && result != null) {
                    firstGenMutable.remove(key);
                    secondGenMutable.put(key, result);
                }
                if (firstGenMutable.isDirty()) {
                    wereMutations = true;
                    firstGen.endWrite(firstGenMutable);
                }
            }
            if (!wereMutations) break;
            secondGen.endWrite(secondGenMutable);
        } while (!this.root.compareAndSet(current, next));
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    public V getObject(@NotNull K key) {
        Root<K, V> current = this.getCurrent();
        if (current == null) {
            return null;
        }
        V result = current.getFirstGen().beginWrite().getValue(key);
        if (result == null) {
            result = current.getSecondGen().beginWrite().getValue(key);
        }
        return result;
    }

    public void cacheObject(@NotNull K key, @NotNull V x) {
        Root next;
        Root<K, V> current;
        do {
            current = this.getCurrent();
            next = new Root(current, this.firstGenSizeBound, this.secondGenSizeBound);
            PersistentLinkedHashMap firstGen = next.getFirstGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> firstGenMutable = firstGen.beginWrite();
            PersistentLinkedHashMap secondGen = next.getSecondGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> secondGenMutable = secondGen.beginWrite();
            if (firstGenMutable.remove(key) == null) {
                secondGenMutable.remove(key);
            }
            if (secondGenMutable.size() < this.secondGenSizeBound >> 1) {
                secondGenMutable.put(key, x);
            } else {
                firstGenMutable.put(key, x);
            }
            firstGen.endWrite(firstGenMutable);
            secondGen.endWrite(secondGenMutable);
        } while (!this.root.compareAndSet(current, next));
    }

    public V remove(@NotNull K key) {
        Object result;
        Root next;
        Root<K, V> current;
        do {
            PersistentLinkedHashMap firstGen;
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable firstGenMutable;
            if ((result = (firstGenMutable = (firstGen = (next = new Root(current = this.getCurrent(), this.firstGenSizeBound, this.secondGenSizeBound)).getFirstGen()).beginWrite()).remove(key)) != null) {
                firstGen.endWrite(firstGenMutable);
                continue;
            }
            PersistentLinkedHashMap secondGen = next.getSecondGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable secondGenMutable = secondGen.beginWrite();
            result = secondGenMutable.remove(key);
            if (result == null) break;
            secondGen.endWrite(secondGenMutable);
        } while (!this.root.compareAndSet(current, next));
        return result;
    }

    public void forEachKey(ObjectProcedure<K> procedure) {
        Root<K, V> current = this.getCurrent();
        if (current == null) {
            return;
        }
        current.getFirstGen().beginWrite().forEachKey(procedure);
        current.getSecondGen().beginWrite().forEachKey(procedure);
    }

    public Iterator<K> keys() {
        final Root<K, V> current = this.getCurrent();
        if (current == null) {
            return new ArrayList(1).iterator();
        }
        return new Iterator<K>(){
            private Iterator<Pair<K, V>> firstGenIt;
            private Iterator<Pair<K, V>> secondGenIt;
            private K next;
            {
                this.firstGenIt = current.getFirstGen().beginWrite().iterator();
                this.secondGenIt = null;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                this.checkNext();
                return this.next != null;
            }

            @Override
            public K next() {
                this.checkNext();
                Object result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("PersistentObjectCache.keys iterator is immutable");
            }

            private void checkNext() {
                if (this.next == null) {
                    if (this.firstGenIt != null) {
                        if (this.firstGenIt.hasNext()) {
                            this.next = this.firstGenIt.next().getFirst();
                            return;
                        }
                        this.firstGenIt = null;
                        this.secondGenIt = current.getSecondGen().beginWrite().iterator();
                    }
                    if (this.secondGenIt != null) {
                        if (this.secondGenIt.hasNext()) {
                            this.next = this.secondGenIt.next().getFirst();
                            return;
                        }
                        this.secondGenIt = null;
                    }
                }
            }
        };
    }

    public Iterator<V> values() {
        Root<K, V> current = this.getCurrent();
        if (current == null) {
            return new ArrayList(1).iterator();
        }
        ArrayList<V> result = new ArrayList<V>();
        for (Pair<K, V> pair : current.getFirstGen().beginWrite()) {
            result.add(pair.getSecond());
        }
        for (Pair<K, V> pair : current.getSecondGen().beginWrite()) {
            result.add(pair.getSecond());
        }
        return result.iterator();
    }

    public PersistentObjectCache<K, V> getClone() {
        return new PersistentObjectCache<K, V>(this);
    }

    private Root<K, V> getCurrent() {
        return this.root.get();
    }

    private static class Root<K, V> {
        @NotNull
        private final PersistentLinkedHashMap<K, V> firstGen;
        @NotNull
        private final PersistentLinkedHashMap<K, V> secondGen;

        private Root(@Nullable Root<K, V> sourceRoot, final int firstGenSizeBound, final int secondGenSizeBound) {
            if (sourceRoot != null) {
                this.firstGen = sourceRoot.firstGen.getClone();
                this.secondGen = sourceRoot.secondGen.getClone();
            } else {
                this.firstGen = new PersistentLinkedHashMap(new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                    @Override
                    public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                        return map.size() > firstGenSizeBound;
                    }
                });
                this.secondGen = new PersistentLinkedHashMap(new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                    @Override
                    public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                        return map.size() > secondGenSizeBound;
                    }
                });
            }
        }

        @NotNull
        public PersistentLinkedHashMap<K, V> getFirstGen() {
            return this.firstGen;
        }

        @NotNull
        public PersistentLinkedHashMap<K, V> getSecondGen() {
            return this.secondGen;
        }
    }
}

