/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent.trial;

import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.persistent.trial.PersistentList;

class MutablePersistentList<T>
extends PersistentList<T> {
    protected HashSet<Object[]> allocated = new HashSet();
    protected int hits;
    protected int misses;

    public MutablePersistentList(PersistentList<T> source) {
        super(source.size, source.shift, MutablePersistentList.mutableRoot(source.root), MutablePersistentList.mutableRecent(source.recent));
        this.allocated.add(this.root);
        this.allocated.add(this.recent);
    }

    @Override
    protected PersistentList<T> maybeEmpty() {
        return this;
    }

    @Override
    protected Object[] ensureMutable(Object[] parent) {
        if (this.allocated.contains(parent)) {
            ++this.hits;
            return parent;
        }
        ++this.misses;
        Object[] result = super.ensureMutable(parent);
        this.allocated.add(result);
        return result;
    }

    @Override
    protected PersistentList<T> mutableCopy(int newSize, int newShift, Object[] newRoot, T[] newRecent) {
        this.size = newSize;
        this.shift = newShift;
        this.root = newRoot;
        this.recent = newRecent;
        return this;
    }

    private static Object[] mutableRoot(Object[] root) {
        return (Object[])root.clone();
    }

    private static Object[] mutableRecent(Object[] recent) {
        Object[] result = new Object[32];
        System.arraycopy(recent, 0, result, 0, recent.length);
        return result;
    }

    public static void main(String[] args) {
        int i;
        PersistentList l = PersistentList.EMPTY.toMutable();
        for (i = 0; i < 9000; ++i) {
            l = l.add("test " + i);
        }
        for (i = 0; i < 9000; ++i) {
            l = l.pop();
        }
        System.out.println(l.size);
    }
}

