/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent.trial;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.persistent.trial.MutablePersistentList;
import jetbrains.exodus.core.dataStructures.persistent.trial.Sequence;
import jetbrains.exodus.core.dataStructures.persistent.trial.SequenceIterable;

public class PersistentList<T>
implements Iterable<T> {
    private static final Object[] WHATEVER = new Object[32];
    protected static final int MASK_31 = 31;
    public static final PersistentList EMPTY = new PersistentList<Object>(0, 5, WHATEVER, new Object[0]);
    protected int size;
    protected int shift;
    protected Object[] root;
    protected T[] recent;

    public PersistentList(int size, int shift, Object[] root, T[] recent) {
        this.size = size;
        this.shift = shift;
        this.root = root;
        this.recent = recent;
    }

    @Override
    public Iterator<T> iterator() {
        return new SequenceIterable.Iterator<T>(this.asSequence());
    }

    public SequenceImpl<T> asSequence() {
        return this.size == 0 ? null : new SequenceImpl(this, 0, 0);
    }

    int recentOffset() {
        if (this.size < 32) {
            return 0;
        }
        return this.size - 1 >>> 5 << 5;
    }

    public T[] arrayFor(int i) {
        if (i >= 0 && i < this.size) {
            if (i >= this.recentOffset()) {
                return this.recent;
            }
            Object[] node = this.root;
            int level = this.shift;
            while (true) {
                Object child = node[i >>> level & 0x1F];
                if ((level -= 5) <= 0) {
                    return (Object[])child;
                }
                node = (Object[])child;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public T get(int i) {
        T[] node = this.arrayFor(i);
        return node[i & 0x1F];
    }

    static Object[] newPath(int level, Object[] node) {
        if (level == 0) {
            return node;
        }
        Object[] result = new Object[32];
        result[0] = PersistentList.newPath(level - 5, node);
        return result;
    }

    private Object[] pushRecent(int level, Object[] parent, T[] recent_) {
        Object child;
        int subIndex = this.size - 1 >>> level & 0x1F;
        Object[] result = this.ensureMutable(parent);
        Object[] target = level == 5 ? recent_ : ((child = parent[subIndex]) != null ? this.pushRecent(level - 5, (Object[])child, recent_) : PersistentList.newPath(level - 5, recent_));
        result[subIndex] = target;
        return result;
    }

    protected Object[] ensureMutable(Object[] parent) {
        return (Object[])parent.clone();
    }

    public PersistentList<T> add(T item) {
        Object[] newRoot;
        if (this.size - this.recentOffset() < 32) {
            Object[] newRecent = new Object[this.recent.length + 1];
            System.arraycopy(this.recent, 0, newRecent, 0, this.recent.length);
            newRecent[this.recent.length] = item;
            return this.mutableCopy(this.size + 1, this.shift, this.root, newRecent);
        }
        int newShift = this.shift;
        if (this.size >>> 5 > 1 << this.shift) {
            newRoot = new Object[32];
            newRoot[0] = this.root;
            newRoot[1] = PersistentList.newPath(this.shift, this.recent);
            newShift += 5;
        } else {
            newRoot = this.pushRecent(this.shift, this.root, this.recent);
        }
        return this.mutableCopy(this.size + 1, newShift, newRoot, new Object[]{item});
    }

    protected PersistentList<T> mutableCopy(int newSize, int newShift, Object[] newRoot, T[] newRecent) {
        return new PersistentList<T>(newSize, newShift, newRoot, newRecent);
    }

    public PersistentList<T> pop() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        if (this.size == 1) {
            return this.maybeEmpty();
        }
        if (this.size - this.recentOffset() > 1) {
            Object[] newRecent = new Object[this.recent.length - 1];
            System.arraycopy(this.recent, 0, newRecent, 0, newRecent.length);
            return this.mutableCopy(this.size - 1, this.shift, this.root, newRecent);
        }
        T[] newRecent = this.arrayFor(this.size - 2);
        Object[] newRoot = this.popRecent(this.shift, this.root);
        int newShift = this.shift;
        if (newRoot == null) {
            newRoot = WHATEVER;
        }
        if (this.shift > 5 && newRoot[1] == null) {
            newRoot = (Object[])newRoot[0];
            newShift -= 5;
        }
        return this.mutableCopy(this.size - 1, newShift, newRoot, newRecent);
    }

    protected PersistentList<T> maybeEmpty() {
        return EMPTY;
    }

    public MutablePersistentList<T> toMutable() {
        return new MutablePersistentList(this);
    }

    private Object[] popRecent(int level, Object[] node) {
        int subIndex = this.size - 2 >>> level & 0x1F;
        if (level > 5) {
            Object[] newChild = this.popRecent(level - 5, (Object[])node[subIndex]);
            if (newChild == null && subIndex == 0) {
                return null;
            }
            Object[] result = this.ensureMutable(node);
            result[subIndex] = newChild;
            return result;
        }
        if (subIndex == 0) {
            return null;
        }
        Object[] result = this.ensureMutable(node);
        result[subIndex] = null;
        return result;
    }

    public static void main(String[] args) {
        PersistentList<String> l = EMPTY;
        for (int i = 0; i < 9000; ++i) {
            l = l.add("test " + i);
        }
        int count = 0;
        for (String s : l) {
            if (!("test " + count).equals(s)) {
                System.out.println("boom");
            }
            ++count;
        }
        for (int i = 0; i < 9000; ++i) {
            l = l.pop();
        }
        System.out.println(l.size);
        l.iterator().hasNext();
    }

    public static final class SequenceImpl<T>
    implements Sequence<T> {
        private final PersistentList<T> source;
        private final T[] node;
        private final int i;
        private final int offset;

        public SequenceImpl(PersistentList<T> source, int i, int offset) {
            this.source = source;
            this.i = i;
            this.offset = offset;
            this.node = source.arrayFor(i);
        }

        SequenceImpl(PersistentList<T> source, T[] node, int i, int offset) {
            this.source = source;
            this.i = i;
            this.offset = offset;
            this.node = node;
        }

        @Override
        public T first() {
            return this.node[this.offset];
        }

        @Override
        public Sequence<T> skip() {
            if (this.offset + 1 < this.node.length) {
                return new SequenceImpl<T>(this.source, this.node, this.i, this.offset + 1);
            }
            if (this.i + this.node.length < this.source.size) {
                return new SequenceImpl<T>(this.source, this.i + this.node.length, 0);
            }
            return null;
        }
    }
}

