/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent.trial;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.persistent.trial.PersistentList;
import jetbrains.exodus.core.dataStructures.persistent.trial.Sequence;
import jetbrains.exodus.core.dataStructures.persistent.trial.SequenceIterable;

public class RealTimePersistentQueue<T>
implements Iterable<T> {
    public static final RealTimePersistentQueue EMPTY = new RealTimePersistentQueue(0, null, null);
    private final int size;
    private final Sequence<T> first;
    private final PersistentList<T> second;

    private RealTimePersistentQueue(int size, Sequence<T> first, PersistentList<T> second) {
        this.size = size;
        this.first = first;
        this.second = second;
    }

    @Override
    public Iterator<T> iterator() {
        return new SequenceIterable.Iterator<T>(this.asSequence());
    }

    public Sequence<T> asSequence() {
        if (this.size == 0) {
            return null;
        }
        return new SequenceImpl(this.first, this.second == null ? null : this.second.asSequence());
    }

    public Object peek() {
        return SequenceIterable.first(this.first);
    }

    public RealTimePersistentQueue<T> pop() {
        if (this.first == null) {
            return this;
        }
        Sequence<T> f1 = this.first.skip();
        PersistentList<T> r1 = this.second;
        if (f1 == null) {
            f1 = this.second == null ? null : this.second.asSequence();
            r1 = null;
        }
        return new RealTimePersistentQueue<T>(this.size - 1, f1, r1);
    }

    public RealTimePersistentQueue<T> add(T item) {
        if (this.first == null) {
            return new RealTimePersistentQueue<T>(this.size + 1, SequenceIterable.singleton(item), null);
        }
        return new RealTimePersistentQueue<T>(this.size + 1, this.first, (this.second != null ? this.second : PersistentList.EMPTY).add(item));
    }

    public int getSize() {
        return this.size;
    }

    private static final class SequenceImpl<T>
    implements Sequence<T> {
        private final Sequence<T> first;
        private final Sequence<T> second;

        private SequenceImpl(Sequence<T> first, Sequence<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public T first() {
            return this.first.first();
        }

        @Override
        public Sequence<T> skip() {
            Sequence<T> first_ = this.first.skip();
            if (first_ == null) {
                if (this.second == null) {
                    return null;
                }
                return new SequenceImpl<T>(this.second, null);
            }
            return new SequenceImpl<T>(first_, this.second);
        }
    }
}

