/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent.trial;

import jetbrains.exodus.core.dataStructures.persistent.trial.Sequence;

class SequenceIterable<T>
implements Iterable<T> {
    private final Sequence<T> source;

    SequenceIterable(Sequence<T> source) {
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(this.source);
    }

    public static <T> T first(Sequence<T> source) {
        return source == null ? null : (T)source.first();
    }

    public static <T> Sequence<T> singleton(T item) {
        return new Singleton<T>(item);
    }

    public static final class Singleton<T>
    implements Sequence<T> {
        private final T item;

        public Singleton(T item) {
            this.item = item;
        }

        @Override
        public T first() {
            return this.item;
        }

        @Override
        public Sequence<T> skip() {
            return null;
        }
    }

    public static final class Iterator<T>
    implements java.util.Iterator<T> {
        private boolean hasNextCalled;
        private Sequence<T> source;

        public Iterator(Sequence<T> source) {
            this.source = source;
            this.hasNextCalled = false;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNextCalled) {
                this.source = this.source.skip();
                this.hasNextCalled = false;
            }
            return this.source != null;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T result = this.source.first();
                this.hasNextCalled = true;
                return result;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

