/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.skiplists;

import jetbrains.exodus.core.dataStructures.skiplists.SkipListBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkipList<K extends Comparable<? super K>>
extends SkipListBase {
    @NotNull
    private final SkipListInternalNode<K> root = new SkipListInternalNode((Comparable)((Object)"just a fake key which very unlikely would ever be used in real life ;-)"), null);
    private SkipListNode<K>[] prevList;

    public SkipList() {
        this.clear();
    }

    public void clear() {
        this.root.setNext(null);
        ((SkipListInternalNode)this.root).setNexts(this.newNodeArray(3));
        this.prevList = new SkipListNode[]{this.root, this.root, this.root, this.root};
        this.size = 0;
    }

    public void add(@NotNull K key) {
        SkipListNode newNode;
        SkipListNode temp;
        SkipListNode next = this.root;
        int level = next.getLevels() - 1;
        SkipListNode<K>[] prevs = this.prevList;
        while (level > 0) {
            while ((temp = next.getNext(level)) != null && this.compare(key, temp.getKey()) >= 0) {
                next = temp;
            }
            prevs[level--] = next;
        }
        while ((temp = next.getNext()) != null && this.compare(key, temp.getKey()) >= 0) {
            next = temp;
        }
        prevs[0] = next;
        SkipListNode<K> prev = prevs[0];
        level = prev != this.root && prev.getLevels() > 1 ? 1 : this.generateQuasiRandomLevel();
        next = prev.getNext();
        switch (level) {
            case 1: {
                newNode = new SkipListBottomNode((Comparable)key, null);
                break;
            }
            case 2: {
                newNode = new SkipListLevel2Node((Comparable)key, null);
                SkipListNode<K> prev1 = prevs[1];
                newNode.setNext(prev1.getNext(1), 1);
                prev1.setNext(newNode, 1);
                break;
            }
            case 3: {
                newNode = new SkipListLevel3Node((Comparable)key, null);
                SkipListNode<K> prev1 = prevs[1];
                newNode.setNext(prev1.getNext(1), 1);
                prev1.setNext(newNode, 1);
                SkipListNode<K> prev2 = prevs[2];
                newNode.setNext(prev2.getNext(2), 2);
                prev2.setNext(newNode, 2);
                break;
            }
            default: {
                SkipListInternalNode internalNode = new SkipListInternalNode((Comparable)key, null);
                newNode = internalNode;
                int rootLevels = this.root.getLevels();
                SkipListNode[] nexts = this.newNodeArray(level - 1);
                for (int i = 1; i < level && i < rootLevels; ++i) {
                    nexts[i - 1] = prevs[i].getNext(i);
                    prevs[i].setNext(newNode, i);
                }
                internalNode.setNexts(nexts);
                break;
            }
        }
        newNode.setNext(next);
        newNode.setPrev(prev);
        prev.setNext(newNode);
        if (next != null) {
            next.setPrev(newNode);
        }
        this.adjustRootNode(newNode, level);
        ++this.size;
    }

    @Nullable
    public K getMinimum() {
        SkipListNode<K> node = this.getMinimumNode();
        return node == null ? null : (K)node.getKey();
    }

    @NotNull
    public SkipListNode<K> getFakeRoot() {
        return this.root;
    }

    @Nullable
    public SkipListNode<K> getMinimumNode() {
        return this.size == 0 ? null : this.root.getNext();
    }

    @Nullable
    public K getMaximum() {
        SkipListNode<K> node = this.getMaximumNode();
        return node == null ? null : (K)node.getKey();
    }

    @Nullable
    public SkipListNode<K> getMaximumNode() {
        SkipListInternalNode<K> result = null;
        SkipListNode next = this.root;
        for (int level = ((SkipListNode)next).getLevels() - 1; level >= 0; --level) {
            SkipListNode temp;
            while ((temp = ((SkipListNode)next).getNext(level)) != null) {
                next = temp;
            }
            result = next;
        }
        return result == this.root ? null : result;
    }

    public SkipListNode<K> getNext(SkipListNode<K> node) {
        return node.getNext();
    }

    public SkipListNode<K> getPrevious(SkipListNode<K> node) {
        SkipListNode<K> prev = node.getPrev();
        return prev == this.root ? null : prev;
    }

    @Nullable
    public SkipListNode<K> search(@NotNull K key) {
        SkipListNode temp;
        int cmp;
        SkipListNode next = this.root;
        for (int level = ((SkipListNode)next).getLevels() - 1; level > 0; --level) {
            cmp = -1;
            while ((temp = ((SkipListNode)next).getNext(level)) != null && (cmp = this.compare(key, temp.getKey())) > 0) {
                next = temp;
            }
            if (cmp != 0) continue;
            return temp;
        }
        cmp = -1;
        while ((temp = next.getNext()) != null && (cmp = this.compare(key, temp.getKey())) > 0) {
            next = temp;
        }
        return cmp == 0 ? temp : null;
    }

    public boolean remove(@NotNull K key) {
        SkipListNode temp;
        int cmp;
        int level;
        SkipListNode next = this.root;
        SkipListNode<K>[] prevs = this.prevList;
        SkipListNode foundNode = null;
        block0: for (level = next.getLevels() - 1; level > 0; --level) {
            while (true) {
                prevs[level] = next;
                cmp = -1;
                temp = next.getNext(level);
                if (temp == null || (cmp = this.compare(key, temp.getKey())) <= 0) {
                    if (cmp != 0) continue block0;
                    foundNode = temp;
                    continue block0;
                }
                next = temp;
            }
        }
        while (true) {
            prevs[0] = next;
            cmp = -1;
            temp = next.getNext();
            if (temp == null || (cmp = this.compare(key, temp.getKey())) <= 0) {
                if (cmp != 0) break;
                foundNode = temp;
                break;
            }
            next = temp;
        }
        if (foundNode != null) {
            level = foundNode.getLevels();
            for (int i = 1; i < level; ++i) {
                prevs[i].setNext(foundNode.getNext(i), i);
            }
            next = foundNode.getNext();
            SkipListNode<K> prev = prevs[0];
            prev.setNext(next);
            if (next != null) {
                next.setPrev(prev);
            }
            if (--this.size == 0) {
                this.clear();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public SkipListNode<K> getGreaterOrEqual(@NotNull K key) {
        SkipListNode temp;
        int cmp;
        SkipListNode next = this.root;
        for (int level = ((SkipListNode)next).getLevels() - 1; level > 0; --level) {
            cmp = -1;
            while ((temp = ((SkipListNode)next).getNext(level)) != null && (cmp = this.compare(key, temp.getKey())) > 0) {
                next = temp;
            }
            if (cmp != 0) continue;
            return this.getMostLeftEqualNode(temp);
        }
        cmp = -1;
        while ((temp = next.getNext()) != null && (cmp = this.compare(key, temp.getKey())) > 0) {
            next = temp;
        }
        if (cmp == 0) {
            return this.getMostLeftEqualNode(temp);
        }
        return next.getNext();
    }

    @Nullable
    public SkipListNode<K> getLessOrEqual(@NotNull K key) {
        SkipListNode temp;
        int cmp;
        SkipListNode next = this.root;
        for (int level = ((SkipListNode)next).getLevels() - 1; level >= 0; --level) {
            cmp = -1;
            while ((temp = ((SkipListNode)next).getNext(level)) != null && (cmp = this.compare(key, temp.getKey())) > 0) {
                next = temp;
            }
            if (cmp != 0) continue;
            return this.getMostLeftEqualNode(temp);
        }
        cmp = -1;
        while ((temp = next.getNext()) != null && (cmp = this.compare(key, temp.getKey())) > 0) {
            next = temp;
        }
        if (cmp == 0) {
            return this.getMostLeftEqualNode(temp);
        }
        return next == this.root ? null : next;
    }

    private void adjustRootNode(SkipListNode<K> node, int level) {
        SkipListInternalNode<K> root = this.root;
        int rootLevels = root.getLevels();
        if (rootLevels < level) {
            int i;
            this.prevList = this.newNodeArray(level);
            SkipListNode[] newRootNexts = this.newNodeArray(level - 1);
            for (i = 1; i < rootLevels; ++i) {
                newRootNexts[i - 1] = root.getNext(i);
            }
            while (i < newRootNexts.length + 1) {
                newRootNexts[i - 1] = node;
                ++i;
            }
            ((SkipListInternalNode)root).setNexts(newRootNexts);
        }
    }

    private SkipListNode<K> getMostLeftEqualNode(SkipListNode<K> node) {
        SkipListNode<K> result;
        SkipListNode<K> prev = node;
        K key = node.getKey();
        do {
            result = prev;
        } while ((prev = prev.getPrev()) != this.root && this.compare(prev.getKey(), key) == 0);
        return result;
    }

    private int compare(@NotNull K k1, @NotNull K k2) {
        return k1.compareTo(k2);
    }

    private SkipListNode<K>[] newNodeArray(int size) {
        return new SkipListNode[size];
    }

    static class 1 {
    }

    private static final class SkipListLevel3Node<K extends Comparable<? super K>>
    extends SkipListNode<K> {
        private SkipListNode<K> _next2;
        private SkipListNode<K> _next3;

        private SkipListLevel3Node(K key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return 3;
        }

        @Override
        protected SkipListNode<K> getNext(int level) {
            switch (level) {
                case 2: {
                    return this._next3;
                }
                case 1: {
                    return this._next2;
                }
                case 0: {
                    return this.getNext();
                }
            }
            SkipListLevel3Node.throwBadLevel();
            return null;
        }

        @Override
        protected void setNext(SkipListNode<K> next, int level) {
            switch (level) {
                case 2: {
                    this._next3 = next;
                    break;
                }
                case 1: {
                    this._next2 = next;
                    break;
                }
                case 0: {
                    this.setNext(next);
                    break;
                }
                default: {
                    SkipListLevel3Node.throwBadLevel();
                }
            }
        }

        private static void throwBadLevel() {
            throw new IllegalArgumentException("SkipListLevel3Node: level can only be equal to 0, 1 or 2.");
        }

        /* synthetic */ SkipListLevel3Node(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static final class SkipListLevel2Node<K extends Comparable<? super K>>
    extends SkipListNode<K> {
        private SkipListNode<K> _next2;

        private SkipListLevel2Node(K key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return 2;
        }

        @Override
        protected SkipListNode<K> getNext(int level) {
            if (level == 1) {
                return this._next2;
            }
            if (level == 0) {
                return this.getNext();
            }
            SkipListLevel2Node.throwBadLevel();
            return null;
        }

        @Override
        protected void setNext(SkipListNode<K> next, int level) {
            if (level == 1) {
                this._next2 = next;
            } else if (level == 0) {
                this.setNext(next);
            } else {
                SkipListLevel2Node.throwBadLevel();
            }
        }

        private static void throwBadLevel() {
            throw new IllegalArgumentException("SkipListLevel2Node: level can only be equal to 0 or 1.");
        }

        /* synthetic */ SkipListLevel2Node(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static final class SkipListBottomNode<K extends Comparable<? super K>>
    extends SkipListNode<K> {
        private SkipListBottomNode(@NotNull K key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return 1;
        }

        @Override
        protected SkipListNode<K> getNext(int level) {
            this.checkLevel(level);
            return this.getNext();
        }

        @Override
        protected void setNext(SkipListNode<K> next, int level) {
            this.checkLevel(level);
            this.setNext(next);
        }

        private void checkLevel(int level) {
            if (level != 0) {
                throw new IllegalArgumentException("SkipListBottomNode: level can only be equal to 0.");
            }
        }

        /* synthetic */ SkipListBottomNode(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static final class SkipListInternalNode<K extends Comparable<? super K>>
    extends SkipListNode<K> {
        private SkipListNode<K>[] _nexts;

        private SkipListInternalNode(@NotNull K key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return this._nexts.length + 1;
        }

        @Override
        protected SkipListNode<K> getNext(int level) {
            return level == 0 ? this.getNext() : this._nexts[level - 1];
        }

        @Override
        protected void setNext(SkipListNode<K> next, int level) {
            if (level == 0) {
                this.setNext(next);
            } else {
                this._nexts[level - 1] = next;
            }
        }

        private void setNexts(SkipListNode<K>[] nexts) {
            this._nexts = nexts;
        }

        /* synthetic */ SkipListInternalNode(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static abstract class SkipListNode<K extends Comparable<? super K>> {
        @NotNull
        private final K key;
        private SkipListNode<K> prev;
        private SkipListNode<K> next;

        protected SkipListNode(@NotNull K key) {
            this.key = key;
        }

        @NotNull
        public K getKey() {
            return this.key;
        }

        protected abstract int getLevels();

        protected abstract SkipListNode<K> getNext(int var1);

        protected abstract void setNext(SkipListNode<K> var1, int var2);

        protected final SkipListNode<K> getPrev() {
            return this.prev;
        }

        protected final void setPrev(SkipListNode<K> prev) {
            this.prev = prev;
        }

        protected final SkipListNode<K> getNext() {
            return this.next;
        }

        protected final void setNext(@Nullable SkipListNode<K> next) {
            this.next = next;
        }
    }
}

