/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.core.dataStructures.ConcurrentStablePriorityQueue;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.dataStructures.PriorityQueue;
import jetbrains.exodus.core.dataStructures.StablePriorityQueue;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JobProcessorQueueAdapter
extends JobProcessorAdapter {
    public static final String CONCURRENT_QUEUE_PROPERTY = "jetbrains.exodus.core.execution.concurrentQueue";
    private final PriorityQueue<Priority, Job> queue = JobProcessorQueueAdapter.createQueue();
    private final PriorityQueue<Long, Job> timeQueue = JobProcessorQueueAdapter.createQueue();
    private volatile int outdatedJobsCount;
    private volatile Job currentJob;
    private volatile long currentJobStartedAt;
    protected final Semaphore awake = new Semaphore(0);

    protected JobProcessorQueueAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean queueLowest(@NotNull Job job) {
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        this.queue.lock();
        try {
            Priority priority;
            Pair<Priority, Job> pair = this.queue.floorPair();
            Priority priority2 = priority = pair == null ? Priority.highest : pair.getFirst();
            if (this.queue.push(priority, job) != null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.queue.unlock();
        }
        this.awake.release();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean push(Job job, Priority priority) {
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        this.queue.lock();
        try {
            if (this.queue.push(priority, job) != null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.queue.unlock();
        }
        this.awake.release();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Job pushAt(Job job, long millis) {
        Pair<Long, Job> pair;
        Job oldJob;
        if (this.isFinished()) {
            return null;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        long priority = Long.MAX_VALUE - millis;
        this.timeQueue.lock();
        try {
            oldJob = this.timeQueue.push(priority, job);
            pair = this.timeQueue.peekPair();
        }
        finally {
            this.timeQueue.unlock();
        }
        if (pair != null && pair.getFirst() != priority) {
            return oldJob;
        }
        this.awake.release();
        return oldJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean queueLowestTimed(@NotNull Job job) {
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        this.timeQueue.lock();
        try {
            long priority;
            Pair<Long, Job> pair = this.timeQueue.floorPair();
            long l = priority = pair == null ? Long.MAX_VALUE - System.currentTimeMillis() : pair.getFirst();
            if (this.timeQueue.push(priority, job) != null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.timeQueue.unlock();
        }
        this.awake.release();
        return true;
    }

    @Override
    public int pendingJobs() {
        return this.queue.size() + (this.currentJob == null ? 0 : 1);
    }

    @Override
    public int pendingTimedJobs() {
        return this.timeQueue.size() + this.outdatedJobsCount;
    }

    @Override
    @Nullable
    public Job getCurrentJob() {
        return this.currentJob;
    }

    @Override
    public long getCurrentJobStartedAt() {
        return this.currentJobStartedAt;
    }

    @Override
    @NotNull
    public Iterable<Job> getPendingJobs() {
        return this.queue;
    }

    protected void doJobs() {
        boolean jobsQueued;
        try {
            jobsQueued = this.waitForJobs();
        }
        catch (InterruptedException e) {
            return;
        }
        if (!this.isFinished()) {
            if (jobsQueued) {
                Job job;
                this.queue.lock();
                try {
                    job = this.queue.pop();
                }
                finally {
                    this.queue.unlock();
                }
                this.doExecuteJob(job);
            } else {
                this.doTimedJobs();
            }
        }
    }

    protected void clearQueues() {
        this.queue.clear();
        this.timeQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTimedJobs() {
        int count;
        ArrayList<Job> outdatedJobs = new ArrayList<Job>();
        long currentTimePriority = Long.MAX_VALUE - System.currentTimeMillis();
        this.timeQueue.lock();
        try {
            Pair<Long, Job> pair = this.timeQueue.peekPair();
            while (pair != null && pair.getFirst() >= currentTimePriority) {
                outdatedJobs.add(this.timeQueue.pop());
                pair = this.timeQueue.peekPair();
            }
            count = outdatedJobs.size();
        }
        finally {
            this.timeQueue.unlock();
        }
        this.outdatedJobsCount = count;
        for (Job job : outdatedJobs) {
            this.executeImmediateJobsIfAny();
            if (this.isFinished()) break;
            this.doExecuteJob(job);
            --this.outdatedJobsCount;
        }
    }

    private void executeImmediateJobsIfAny() {
        while (!this.isFinished() && this.executeImmediateJobIfAny() != null) {
        }
    }

    private Job executeImmediateJobIfAny() {
        Job urgentImmediateJob = null;
        this.queue.lock();
        try {
            Pair<Priority, Job> peekPair = this.queue.peekPair();
            if (peekPair != null && peekPair.getFirst() == Priority.highest) {
                urgentImmediateJob = this.queue.pop();
            }
        }
        finally {
            this.queue.unlock();
        }
        if (urgentImmediateJob != null) {
            this.doExecuteJob(urgentImmediateJob);
        }
        return urgentImmediateJob;
    }

    protected boolean waitForJobs() throws InterruptedException {
        Pair<Long, Job> peekPair;
        this.timeQueue.lock();
        try {
            peekPair = this.timeQueue.peekPair();
        }
        finally {
            this.timeQueue.unlock();
        }
        if (peekPair == null) {
            this.awake.acquire();
            return true;
        }
        long timeout = Long.MAX_VALUE - peekPair.getFirst() - System.currentTimeMillis();
        if (timeout < 0L) {
            return false;
        }
        return this.awake.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    private void doExecuteJob(Job job) {
        this.currentJob = job;
        this.currentJobStartedAt = System.currentTimeMillis();
        try {
            this.executeJob(job);
        }
        finally {
            this.currentJob = null;
            this.currentJobStartedAt = 0L;
        }
    }

    private static PriorityQueue createQueue() {
        String concurrentQueueProperty = System.getProperty(CONCURRENT_QUEUE_PROPERTY);
        if (concurrentQueueProperty != null && "false".equalsIgnoreCase(concurrentQueueProperty)) {
            return new StablePriorityQueue();
        }
        return new ConcurrentStablePriorityQueue();
    }
}

