/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobHandler;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import jetbrains.exodus.core.execution.JobProcessorQueueAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadJobProcessor
extends JobProcessorQueueAdapter {
    private final String name;
    private final Runnable body;
    private Thread thread;
    private final ClassLoader classLoader = this.getClass().getClassLoader();
    @Nullable
    private final ThreadCreator creator;

    public ThreadJobProcessor(@NotNull String name) {
        this(name, null);
    }

    public ThreadJobProcessor(@NotNull String name, @Nullable ThreadCreator creator) {
        this.name = name;
        this.body = new Runnable(){

            @Override
            public void run() {
                ThreadJobProcessor.this.run();
            }
        };
        this.creator = creator;
        this.createProcessorThread();
    }

    @Override
    public synchronized void start() {
        if (!this.started.getAndSet(true)) {
            this.finished.set(false);
            this.thread.start();
        }
    }

    @Override
    public void finish() {
        if (this.started.get() && !this.finished.getAndSet(true)) {
            this.waitUntilFinished();
            super.finish();
            this.createProcessorThread();
            this.clearQueues();
            this.started.set(false);
        }
    }

    public boolean queueFinish() {
        return new Job(this, Priority.lowest){

            @Override
            protected void execute() {
                ThreadJobProcessor.this.finished.set(true);
            }
        }.wasQueued();
    }

    public void waitUntilFinished() {
        this.awake.release();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.thread.toString();
    }

    public long getId() {
        return this.thread.getId();
    }

    public boolean isCurrentThread() {
        return this.thread == Thread.currentThread();
    }

    public final void run() {
        this.processorStarted();
        while (!this.isFinished()) {
            this.doJobs();
        }
        this.processorFinished();
    }

    private void createProcessorThread() {
        this.thread = this.creator == null ? new Thread(this.body, this.name) : this.creator.createThread(this.body, this.name);
        this.thread.setContextClassLoader(this.classLoader);
        this.thread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeJob(@Nullable Job job) {
        JobProcessor processor;
        if (job != null && (processor = job.getProcessor()) != null && !processor.isFinished()) {
            JobProcessorExceptionHandler exceptionHandler = processor.getExceptionHandler();
            try {
                processor.beforeProcessingJob(job);
                JobHandler.invokeHandlers(this.jobStartingHandlers, job);
                try {
                    this.thread.setContextClassLoader(job.getClass().getClassLoader());
                    job.run(exceptionHandler);
                }
                finally {
                    this.thread.setContextClassLoader(this.classLoader);
                    JobHandler.invokeHandlers(this.jobFinishedHandlers, job);
                }
                processor.afterProcessingJob(job);
            }
            catch (Throwable t) {
                if (exceptionHandler != null) {
                    try {
                        exceptionHandler.handle(this, job, t);
                    }
                    catch (Throwable tt) {
                        t.printStackTrace();
                    }
                }
                t.printStackTrace();
            }
        }
    }

    public static interface ThreadCreator {
        public Thread createThread(Runnable var1, String var2);
    }
}

