/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.ByteArrayOutputStream;
import org.jetbrains.annotations.NotNull;

public final class HexUtil {
    private HexUtil() {
    }

    public static String byteArrayToString(@NotNull byte[] array) {
        return HexUtil.byteArrayToString(array, 0, array.length);
    }

    public static String byteArrayToString(@NotNull byte[] array, int off, int len) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b = array[off + i];
            int digit = b >> 4 & 0xF;
            builder.append((char)(digit < 10 ? digit + 48 : digit - 10 + 97));
            digit = b & 0xF;
            builder.append((char)(digit < 10 ? digit + 48 : digit - 10 + 97));
        }
        return builder.toString();
    }

    public static byte[] stringToByteArray(@NotNull String str) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int b = Character.digit(c, 16) << 4;
            if (i < str.length() - 1) {
                c = str.charAt(++i);
                b |= Character.digit(c, 16);
            }
            stream.write(b);
        }
        return stream.toByteArray();
    }
}

