/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import org.jetbrains.annotations.NotNull;

public class StringInterner {
    private static final int NUMBER_OF_GENERATIONS = 2;
    private static final int INTERNER_SIZE = 24802;
    private static final ConcurrentObjectCache<String, String> cache = new ConcurrentObjectCache(24802, 2);

    private StringInterner() {
    }

    public static String intern(String s) {
        if (s == null) {
            return null;
        }
        String result = cache.tryKey(s);
        if (result != null) {
            return result;
        }
        String copy = new String(s);
        cache.cacheObject(copy, copy);
        return copy;
    }

    public static String intern(@NotNull StringBuilder builder, int maxLen) {
        String result = builder.toString();
        if (builder.length() <= maxLen) {
            String cached = cache.tryKey(result);
            if (cached != null) {
                return cached;
            }
            cache.cacheObject(result, result);
        }
        return result;
    }
}

