/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.oauth2.dnq.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.oauth2.api.OAuth2UserDetailsImpl;
import jetbrains.jetpass.auth.module.oauth2.dnq.client.OAuth2AuthenticationException;
import jetbrains.jetpass.auth.module.oauth2.dnq.persistence.XdOAuth2AuthModule;
import jetbrains.jetpass.auth.module.oauth2.rest.client.api.OAuth2UserDetails;
import jetbrains.jetpass.client.oauth2.OAuth2Client;
import jetbrains.jetpass.client.oauth2.auth.CodeHandler;
import jetbrains.jetpass.client.oauth2.auth.OAuth2CodeFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2CodeResponseFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2TokenFlow;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\n2\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/jetpass/auth/module/oauth2/dnq/client/OAuth2API;", "", "client", "Ljavax/ws/rs/client/Client;", "(Ljavax/ws/rs/client/Client;)V", "convertUserInfoJsonToUserDetails", "Ljetbrains/jetpass/auth/module/oauth2/api/OAuth2UserDetailsImpl;", "authModule", "Ljetbrains/jetpass/auth/module/oauth2/dnq/persistence/XdOAuth2AuthModule;", "json", "Lcom/fasterxml/jackson/databind/JsonNode;", "emailJson", "getClient", "Ljetbrains/jetpass/client/oauth2/OAuth2Client$OAuth2ClientBuilder;", "getCodeFlow", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2CodeFlow;", "landingUrl", "Ljava/net/URI;", "state", "", "additionalScopes", "getToken", "code", "getUserDetails", "Ljetbrains/jetpass/auth/module/oauth2/rest/client/api/OAuth2UserDetails;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "token", "getUserInfoJson", "url", "getValueByPath", "rootNode", "path", "Companion", "jetbrains.jetpass.auth.module.oauth2.dnq"})
public final class OAuth2API {
    private final Client client;
    public static final Companion Companion = new Companion(null);

    private final OAuth2Client.OAuth2ClientBuilder getClient() {
        return OAuth2Client.Companion.builder(this.client);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2CodeFlow getCodeFlow(@NotNull XdOAuth2AuthModule authModule, @NotNull URI landingUrl, @Nullable String state, @Nullable String additionalScopes) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)authModule), (String)"authModule");
        Intrinsics.checkParameterIsNotNull((Object)landingUrl, (String)"landingUrl");
        StringBuilder stringBuilder = new StringBuilder().append(authModule.getScope()).append(" ");
        String string = additionalScopes;
        if (string == null) {
            string = "";
        }
        Iterable iterable = StringsKt.split$default((CharSequence)stringBuilder.append((Object)string).toString(), (char[])new char[]{' ', ','}, (boolean)false, (int)0, (int)6, null);
        void var7_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            CharSequence charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String scope2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        OAuth2Client.OAuth2ClientBuilder oAuth2ClientBuilder = this.getClient().authURI(authModule.getUrl());
        String string2 = authModule.getTokenUrl();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return ((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)oAuth2ClientBuilder.tokenURI(string2).build().codeFlow().addEncodedScope(scope2)).state(state)).redirectUri(landingUrl)).clientId(authModule.getClientId())).build();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OAuth2CodeFlow getCodeFlow$default(OAuth2API oAuth2API, XdOAuth2AuthModule xdOAuth2AuthModule, URI uRI, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return oAuth2API.getCodeFlow(xdOAuth2AuthModule, uRI, string, string2);
    }

    @NotNull
    public final OAuth2UserDetails getUserDetails(@NotNull XdOAuth2AuthModule authModule, @NotNull JetPassDAOContainer container, @NotNull String token) {
        OAuth2UserDetailsImpl oAuth2UserDetailsImpl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)authModule), (String)"authModule");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        String string = authModule.getUserInfoUrl();
        if (string == null) {
            throw (Throwable)((Object)OAuth2AuthenticationException.Companion.cantFetchUser("User data URL is not set"));
        }
        String userInfoUrl2 = string;
        try {
            OAuth2UserDetailsImpl oAuth2UserDetailsImpl2;
            JsonNode jsonNode;
            JsonNode userInfo = this.getUserInfoJson(userInfoUrl2, token);
            if (authModule.getUserEmailUrl() != null && Intrinsics.areEqual((Object)authModule.getUserEmailUrl(), (Object)userInfoUrl2) ^ true) {
                String string2 = authModule.getUserEmailUrl();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                jsonNode = this.getUserInfoJson(string2, token);
            } else {
                jsonNode = userInfo;
            }
            JsonNode email = jsonNode;
            OAuth2UserDetailsImpl $receiver = oAuth2UserDetailsImpl2 = this.convertUserInfoJsonToUserDetails(authModule, userInfo, email);
            $receiver.setAuthModule(container.getJetPassAuthModuleDAO().wrapEntity((XdAuthModule)authModule));
            oAuth2UserDetailsImpl = oAuth2UserDetailsImpl2;
        }
        catch (WebApplicationException ex) {
            throw (Throwable)((Object)OAuth2AuthenticationException.Companion.cantFetchUser((Exception)((Object)ex)));
        }
        catch (JsonProcessingException ex) {
            throw (Throwable)((Object)OAuth2AuthenticationException.Companion.cantFetchUser((Exception)((Object)ex)));
        }
        return (OAuth2UserDetails)oAuth2UserDetailsImpl;
    }

    @NotNull
    public final String getToken(@NotNull XdOAuth2AuthModule authModule, @NotNull URI landingUrl, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)authModule), (String)"authModule");
        Intrinsics.checkParameterIsNotNull((Object)landingUrl, (String)"landingUrl");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        try {
            OAuth2CodeFlow codeFlow = OAuth2API.getCodeFlow$default(this, authModule, landingUrl, null, null, 12, null);
            CodeHandler codeHandler = codeFlow.getCodeHandler();
            String string = authModule.getClientSecret();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            OAuth2CodeResponseFlow codeResponseFlow = codeHandler.exchange(string, code, null, authModule.getFormClientAuth() ? OAuth2TokenFlow.ClientAuth.FORM : OAuth2TokenFlow.ClientAuth.HEADER);
            return codeResponseFlow.getRawToken();
        }
        catch (OAuth2TokenLoadException e) {
            throw (Throwable)((Object)OAuth2AuthenticationException.Companion.cantLoadToken(e));
        }
    }

    private final JsonNode getUserInfoJson(String url, String token) {
        String content = (String)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get(String.class);
        JsonNode jsonNode = new ObjectMapper().readTree(content);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"ObjectMapper().readTree(content)");
        return jsonNode;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode getValueByPath(JsonNode rootNode, String path) {
        JsonNode jsonNode;
        try {
            JsonNode jsonNode2;
            Object object = path;
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null)) != null) {
                Iterable $receiver$iv = (Iterable)object;
                JsonNode accumulator$iv = rootNode;
                for (Object element$iv : $receiver$iv) {
                    void segment;
                    int n;
                    JsonNode jsonNode3;
                    JsonNode jsonNode4;
                    JsonNode it;
                    String string = (String)element$iv;
                    JsonNode node = accumulator$iv;
                    Object object2 = node;
                    if (object2 == null || (object2 = (it = (jsonNode4 = object2)).isArray() ? jsonNode4 : null) == null || (object2 = (jsonNode3 = object2).get(n = Integer.parseInt((String)(jsonNode4 = segment)))) == null) {
                        JsonNode jsonNode5 = node;
                        object2 = jsonNode5 != null ? jsonNode5.get((String)segment) : null;
                    }
                    accumulator$iv = object2;
                }
                jsonNode2 = accumulator$iv;
            } else {
                jsonNode2 = null;
            }
            jsonNode = jsonNode2;
        }
        catch (NumberFormatException e) {
            Companion.getLogger().warn((Throwable)e, (Function0)new Function0<String>(path){
                final /* synthetic */ String $path;

                @NotNull
                public final String invoke() {
                    return "Can't extract a user info value by path [" + this.$path + ']';
                }
                {
                    this.$path = string;
                    super(0);
                }
            });
            jsonNode = null;
        }
        return jsonNode;
    }

    private final OAuth2UserDetailsImpl convertUserInfoJsonToUserDetails(XdOAuth2AuthModule authModule, JsonNode json, JsonNode emailJson) {
        String string;
        String string2;
        String string3;
        Object it;
        OAuth2UserDetailsImpl oAuth2UserDetailsImpl;
        Object object;
        OAuth2UserDetailsImpl oAuth2UserDetailsImpl2;
        OAuth2UserDetailsImpl $receiver = oAuth2UserDetailsImpl2 = new OAuth2UserDetailsImpl();
        JsonNode jsonNode = this.getValueByPath(json, authModule.getUserIdPath());
        if (jsonNode == null) {
            String string4 = authModule.getUserIdPath();
            if (string4 == null) {
                string4 = "";
            }
            throw (Throwable)((Object)OAuth2AuthenticationException.Companion.cantGetUserId(string4));
        }
        JsonNode identifierNode = jsonNode;
        String string5 = identifierNode.textValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"identifierNode.textValue()");
        $receiver.setIdentifier(string5);
        JsonNode jsonNode2 = this.getValueByPath(json, authModule.getUserNamePath());
        $receiver.setFullName(jsonNode2 != null ? jsonNode2.textValue() : null);
        OAuth2UserDetailsImpl oAuth2UserDetailsImpl3 = $receiver;
        Object object2 = this.getValueByPath(emailJson, authModule.getUserEmailPath());
        if (object2 != null && (object2 = object2.textValue()) != null) {
            EmailContactImpl emailContactImpl;
            object = object2;
            oAuth2UserDetailsImpl = oAuth2UserDetailsImpl3;
            it = object;
            EmailContactImpl $receiver2 = emailContactImpl = new EmailContactImpl((String)it);
            JsonNode jsonNode3 = this.getValueByPath(emailJson, authModule.getUserEmailVerifiedPath());
            $receiver2.setVerified(Boolean.valueOf(jsonNode3 != null ? jsonNode3.booleanValue() : authModule.isEmailVerifiedByDefault()));
            string3 = emailContactImpl;
            oAuth2UserDetailsImpl3 = oAuth2UserDetailsImpl;
            string2 = string3;
        } else {
            string2 = null;
        }
        oAuth2UserDetailsImpl3.setEmail((EmailContact)string2);
        OAuth2UserDetailsImpl oAuth2UserDetailsImpl4 = $receiver;
        Object object3 = this.getValueByPath(json, authModule.getUserPictureIdPath());
        if (object3 != null && (object3 = object3.textValue()) != null) {
            object = object3;
            oAuth2UserDetailsImpl = oAuth2UserDetailsImpl4;
            it = object;
            String string6 = authModule.getUserPictureUrlPattern();
            if (string6 == null || (string6 = StringsKt.replace$default((String)string6, (String)"<picture-id>", (String)it, (boolean)false, (int)4, null)) == null) {
                string6 = it;
            }
            string3 = string6;
            oAuth2UserDetailsImpl4 = oAuth2UserDetailsImpl;
            string = string3;
        } else {
            string = null;
        }
        oAuth2UserDetailsImpl4.setAvatar(string);
        return oAuth2UserDetailsImpl2;
    }

    public OAuth2API(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/auth/module/oauth2/dnq/client/OAuth2API$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.auth.module.oauth2.dnq"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

