/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.oauth2.dnq.persistence;

import com.intellij.hub.auth.OAuthClientValidationException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.auth.module.dnq.authentication.FederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.State;
import jetbrains.jetpass.auth.module.oauth2.dnq.client.OAuth2API;
import jetbrains.jetpass.auth.module.oauth2.dnq.client.OAuth2AuthenticationException;
import jetbrains.jetpass.auth.module.oauth2.dnq.persistence.XdOAuth2AuthModule;
import jetbrains.jetpass.auth.module.oauth2.rest.client.api.OAuth2UserDetails;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J5\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\u0019\u0010!\u001a\u0015\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\"0%\u00a2\u0006\u0002\b&H\u0016J(\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Ljetbrains/jetpass/auth/module/oauth2/dnq/persistence/OAuth2FederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/dnq/authentication/FederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/oauth2/rest/client/api/OAuth2UserDetails;", "authModule", "Ljetbrains/jetpass/auth/module/oauth2/dnq/persistence/XdOAuth2AuthModule;", "api", "Ljetbrains/jetpass/auth/module/oauth2/dnq/client/OAuth2API;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/auth/module/oauth2/dnq/persistence/XdOAuth2AuthModule;Ljetbrains/jetpass/auth/module/oauth2/dnq/client/OAuth2API;Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "CODE", "", "getCODE", "()Ljava/lang/String;", "ERROR", "getERROR", "ERROR_DESCRIPTION", "getERROR_DESCRIPTION", "STATE", "getSTATE", "getApi", "()Ljetbrains/jetpass/auth/module/oauth2/dnq/client/OAuth2API;", "getAuthModule", "()Ljetbrains/jetpass/auth/module/oauth2/dnq/persistence/XdOAuth2AuthModule;", "getContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "authenticate", "credentials", "Ljetbrains/jetpass/auth/module/dnq/authentication/ServletRequestCredentials;", "getReturnUri", "Ljava/net/URI;", "authUrl", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "restoreState", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "request", "Ljavax/servlet/http/HttpServletRequest;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "start", "Ljavax/ws/rs/core/Response;", "state", "stateId", "jetbrains.jetpass.auth.module.oauth2.dnq"})
public final class OAuth2FederatedAuthenticationHandler
implements FederatedAuthenticationHandler<OAuth2UserDetails> {
    @NotNull
    private final String CODE = "code";
    @NotNull
    private final String ERROR = "error";
    @NotNull
    private final String ERROR_DESCRIPTION = "error_description";
    @NotNull
    private final String STATE = "state";
    @NotNull
    private final XdOAuth2AuthModule authModule;
    @NotNull
    private final OAuth2API api;
    @NotNull
    private final JetPassDAOContainer container;

    @NotNull
    public final String getCODE() {
        return this.CODE;
    }

    @NotNull
    public final String getERROR() {
        return this.ERROR;
    }

    @NotNull
    public final String getERROR_DESCRIPTION() {
        return this.ERROR_DESCRIPTION;
    }

    @NotNull
    public final String getSTATE() {
        return this.STATE;
    }

    @NotNull
    public Response start(@NotNull HttpServletRequest request, @NotNull State state, @NotNull String stateId, @NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)stateId, (String)"stateId");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        if (state.isProxied()) {
            Map authParams = state.getAuthParameters();
            String string = (String)authParams.get("client_id");
            if (string == null) {
                throw (Throwable)OAuthClientValidationException.Companion.invalidParameter("client_id");
            }
            String clientId = string;
            XdService xdService = XdService.Companion.resolve(clientId);
            if (xdService == null) {
                throw (Throwable)OAuthClientValidationException.Companion.unknownService(clientId);
            }
            XdService clientService = xdService;
            if (!clientService.getTrusted()) {
                throw (Throwable)new RuntimeException("Can't proxy token to untrusted service");
            }
            String redirectUri = URLDecoder.decode((String)authParams.get("redirect_uri"), "UTF-8");
            if (!clientService.matchesRedirectUri(redirectUri)) {
                String string2 = clientService.getName();
                String string3 = redirectUri;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"redirectUri");
                throw (Throwable)OAuthClientValidationException.Companion.unregisteredRedirectURI(string2, string3);
            }
            state.setProxyURI(URI.create(redirectUri));
        }
        String additionalScopes = state.isProxied() ? (String)state.getAuthParameters().get("scope") : null;
        URI startURI = this.api.getCodeFlow(this.authModule, state.getLandingUri(), stateId, additionalScopes).getAuthUri();
        Response response = Response.seeOther((URI)startURI).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(startURI).build()");
        return response;
    }

    @Nullable
    public OAuth2UserDetails authenticate(@NotNull ServletRequestCredentials credentials) {
        OAuth2UserDetails userDetails;
        block2: {
            URI uRI;
            Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
            HttpServletRequest request = credentials.getRequest();
            String string = request.getParameter(this.ERROR);
            if (string != null) {
                String string2;
                String error = string2 = string;
                throw (Throwable)((Object)OAuth2AuthenticationException.Companion.authorizationError(error, request.getParameter(this.ERROR_DESCRIPTION)));
            }
            String code = request.getParameter(this.CODE);
            URI uRI2 = credentials.getState().getLandingUri();
            String string3 = code;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"code");
            String token = this.api.getToken(this.authModule, uRI2, string3);
            userDetails = this.api.getUserDetails(this.authModule, this.container, token);
            State state = credentials.getState();
            URI uRI3 = state.getProxyURI();
            if (uRI3 == null) break block2;
            URI it = uRI = uRI3;
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)it);
            String stateParam = (String)state.getAuthParameters().get("state");
            if (stateParam != null) {
                uriBuilder.queryParam("state", new Object[]{stateParam});
            }
            uriBuilder.queryParam("access_token", new Object[]{token});
            state.setProxyURI(uriBuilder.build(new Object[0]));
        }
        return userDetails;
    }

    @Nullable
    public State restoreState(@NotNull HttpServletRequest request, @NotNull AuthUrl authUrl, @NotNull Function1<? super String, ? extends State> restoreState) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Intrinsics.checkParameterIsNotNull(restoreState, (String)"restoreState");
        String string = request.getParameter(this.STATE);
        return string != null ? (State)restoreState.invoke((Object)string) : null;
    }

    @NotNull
    public URI getReturnUri(@NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        URI uRI = URI.create(this.authModule.getRedirectUri(authUrl));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(authModule.getRedirectUri(authUrl))");
        return uRI;
    }

    @NotNull
    public final XdOAuth2AuthModule getAuthModule() {
        return this.authModule;
    }

    @NotNull
    public final OAuth2API getApi() {
        return this.api;
    }

    @NotNull
    public final JetPassDAOContainer getContainer() {
        return this.container;
    }

    public OAuth2FederatedAuthenticationHandler(@NotNull XdOAuth2AuthModule authModule, @NotNull OAuth2API api, @NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)authModule), (String)"authModule");
        Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.authModule = authModule;
        this.api = api;
        this.container = container;
        this.CODE = "code";
        this.ERROR = "error";
        this.ERROR_DESCRIPTION = "error_description";
        this.STATE = "state";
    }
}

