/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.google.dnq.ui.login;

import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import java.net.URI;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.google.api.user.details.GoogleUserDetailsImpl;
import jetbrains.jetpass.auth.module.google.dnq.ui.login.GoogleAuthenticationException;
import jetbrains.jetpass.auth.module.google.dnq.ui.login.GoogleUser;
import jetbrains.jetpass.auth.module.google.dnq.ui.login.User;
import jetbrains.jetpass.auth.module.google.dnq.xd.XdGoogleAuthModule;
import jetbrains.jetpass.auth.module.google.rest.client.api.GoogleUserDetails;
import jetbrains.jetpass.client.oauth2.OAuth2Client;
import jetbrains.jetpass.client.oauth2.auth.CodeHandler;
import jetbrains.jetpass.client.oauth2.auth.OAuth2CodeFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2CodeResponseFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2TokenFlow;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/jetpass/auth/module/google/dnq/ui/login/GoogleAPI;", "", "client", "Ljavax/ws/rs/client/Client;", "(Ljavax/ws/rs/client/Client;)V", "getCodeFlow", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2CodeFlow;", "xdModule", "Ljetbrains/jetpass/auth/module/google/dnq/xd/XdGoogleAuthModule;", "landingUrl", "Ljava/net/URI;", "state", "", "getGoogleBasicProfile", "Ljetbrains/jetpass/auth/module/google/dnq/ui/login/User;", "token", "getUser", "code", "getUserDetail", "Ljetbrains/jetpass/auth/module/google/rest/client/api/GoogleUserDetails;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "Companion", "jetbrains.jetpass.auth.module.google.dnq"})
public final class GoogleAPI {
    private final Client client;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final OAuth2CodeFlow getCodeFlow(@NotNull XdGoogleAuthModule xdModule, @NotNull URI landingUrl, @Nullable String state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        Intrinsics.checkParameterIsNotNull((Object)landingUrl, (String)"landingUrl");
        return ((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)OAuth2Client.Companion.builder(this.client).authServerURI(xdModule.getUrl()).build().codeFlow().addEncodedScope("profile")).addEncodedScope("email")).state(state)).redirectUri(landingUrl)).clientId(xdModule.getClientId())).build();
    }

    @NotNull
    public final User getUser(@NotNull XdGoogleAuthModule xdModule, @NotNull URI landingUrl, @NotNull String code) throws GoogleAuthenticationException {
        Object codeFlow;
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        Intrinsics.checkParameterIsNotNull((Object)landingUrl, (String)"landingUrl");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        try {
            codeFlow = this.getCodeFlow(xdModule, landingUrl, null);
            CodeHandler codeHandler = codeFlow.getCodeHandler();
            String string = xdModule.getClientSecret();
            if (string == null) {
                string = "";
            }
            OAuth2CodeResponseFlow codeResponseFlow = codeHandler.exchange(string, code, null, OAuth2TokenFlow.ClientAuth.FORM);
            codeFlow = codeResponseFlow.getRawToken();
        }
        catch (OAuth2TokenLoadException e) {
            throw (Throwable)((Object)GoogleAuthenticationException.Companion.cantLoadToken(e));
        }
        Object token = codeFlow;
        try {
            return this.getGoogleBasicProfile((String)token);
        }
        catch (WebApplicationException e) {
            throw (Throwable)((Object)GoogleAuthenticationException.Companion.cantFetchUser((Exception)((Object)e)));
        }
        catch (ProcessingException e) {
            throw (Throwable)((Object)GoogleAuthenticationException.Companion.cantFetchUser((Exception)((Object)e)));
        }
    }

    private final User getGoogleBasicProfile(String token) throws WebApplicationException {
        Object object = this.client.target("https://www.googleapis.com/oauth2/v1/userinfo").queryParam("fields", new Object[]{GoogleUser.Companion.getFIELDS()}).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get(GoogleUser.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"client.target(\"https://w\u2026t(GoogleUser::class.java)");
        return (User)object;
    }

    @NotNull
    public final GoogleUserDetails getUserDetail(@NotNull XdGoogleAuthModule xdModule, @NotNull URI landingUrl, @NotNull String code, @NotNull JetPassDAOContainer container) throws GoogleAuthenticationException {
        EmailContactImpl emailContactImpl;
        GoogleUserDetailsImpl googleUserDetailsImpl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        Intrinsics.checkParameterIsNotNull((Object)landingUrl, (String)"landingUrl");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        User user2 = this.getUser(xdModule, landingUrl, code);
        GoogleUserDetailsImpl $receiver = googleUserDetailsImpl = new GoogleUserDetailsImpl();
        $receiver.setAuthModule(container.getJetPassAuthModuleDAO().wrapEntity((XdAuthModule)xdModule));
        $receiver.setIdentifier(user2.getIdentifier());
        $receiver.setFullName(user2.getFullName());
        GoogleUserDetailsImpl googleUserDetailsImpl2 = $receiver;
        String string = user2.getEmail();
        if (string != null) {
            String string2 = string;
            GoogleUserDetailsImpl googleUserDetailsImpl3 = googleUserDetailsImpl2;
            String it = string2;
            EmailContactImpl emailContactImpl2 = new EmailContactImpl(it, true);
            googleUserDetailsImpl2 = googleUserDetailsImpl3;
            emailContactImpl = emailContactImpl2;
        } else {
            emailContactImpl = null;
        }
        googleUserDetailsImpl2.setEmail((EmailContact)emailContactImpl);
        $receiver.setAvatar(user2.getAvatar());
        return (GoogleUserDetails)googleUserDetailsImpl;
    }

    public GoogleAPI(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/auth/module/google/dnq/ui/login/GoogleAPI$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.auth.module.google.dnq"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

