/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.google.dnq.ui.login;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.dnq.authentication.FederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.State;
import jetbrains.jetpass.auth.module.google.dnq.ui.login.GoogleAPI;
import jetbrains.jetpass.auth.module.google.dnq.xd.XdGoogleAuthModule;
import jetbrains.jetpass.auth.module.google.rest.client.api.GoogleUserDetails;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J5\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0019\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015\u00a2\u0006\u0002\b\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/auth/module/google/dnq/ui/login/GoogleFederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/dnq/authentication/FederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/google/rest/client/api/GoogleUserDetails;", "xdAuthModule", "Ljetbrains/jetpass/auth/module/google/dnq/xd/XdGoogleAuthModule;", "api", "Ljetbrains/jetpass/auth/module/google/dnq/ui/login/GoogleAPI;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/auth/module/google/dnq/xd/XdGoogleAuthModule;Ljetbrains/jetpass/auth/module/google/dnq/ui/login/GoogleAPI;Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "authenticate", "credentials", "Ljetbrains/jetpass/auth/module/dnq/authentication/ServletRequestCredentials;", "getReturnUri", "Ljava/net/URI;", "authUrl", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "restoreState", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "request", "Ljavax/servlet/http/HttpServletRequest;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "start", "Ljavax/ws/rs/core/Response;", "state", "stateId", "Companion", "jetbrains.jetpass.auth.module.google.dnq"})
public final class GoogleFederatedAuthenticationHandler
implements FederatedAuthenticationHandler<GoogleUserDetails> {
    private final XdGoogleAuthModule xdAuthModule;
    private final GoogleAPI api;
    private final JetPassDAOContainer container;
    @NotNull
    private static final String STATE = "state";
    @NotNull
    private static final String CODE = "code";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response start(@NotNull HttpServletRequest request, @NotNull State state, @NotNull String stateId, @NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)STATE);
        Intrinsics.checkParameterIsNotNull((Object)stateId, (String)"stateId");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        URI startURI = this.api.getCodeFlow(this.xdAuthModule, state.getLandingUri(), stateId).getAuthUri();
        Response response = Response.seeOther((URI)startURI).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(startURI).build()");
        return response;
    }

    @Nullable
    public State restoreState(@NotNull HttpServletRequest request, @NotNull AuthUrl authUrl, @NotNull Function1<? super String, ? extends State> restoreState) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Intrinsics.checkParameterIsNotNull(restoreState, (String)"restoreState");
        String string = request.getParameter(STATE);
        return string != null ? (State)restoreState.invoke((Object)string) : null;
    }

    @Nullable
    public GoogleUserDetails authenticate(@NotNull ServletRequestCredentials credentials) throws AuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        String string = credentials.getRequest().getParameter(CODE);
        if (string == null) {
            string = "";
        }
        String code = string;
        return this.api.getUserDetail(this.xdAuthModule, credentials.getState().getLandingUri(), code, this.container);
    }

    @NotNull
    public URI getReturnUri(@NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        URI uRI = URI.create(this.xdAuthModule.getRedirectUri(authUrl));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(xdAuthModule.getRedirectUri(authUrl))");
        return uRI;
    }

    public GoogleFederatedAuthenticationHandler(@NotNull XdGoogleAuthModule xdAuthModule, @NotNull GoogleAPI api, @NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdAuthModule), (String)"xdAuthModule");
        Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.xdAuthModule = xdAuthModule;
        this.api = api;
        this.container = container;
    }

    static {
        STATE = STATE;
        CODE = CODE;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/auth/module/google/dnq/ui/login/GoogleFederatedAuthenticationHandler$Companion;", "", "()V", "CODE", "", "getCODE", "()Ljava/lang/String;", "STATE", "getSTATE", "jetbrains.jetpass.auth.module.google.dnq"})
    public static final class Companion {
        @NotNull
        public final String getSTATE() {
            return STATE;
        }

        @NotNull
        public final String getCODE() {
            return CODE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

