/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.github.dnq.persistence;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubAPI;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubAuthenticationException;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubError;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubUser;
import jetbrains.jetpass.auth.module.github.dnq.xd.XdGithubAuthModule;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J5\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fJ \u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubAPI;", "", "client", "Ljavax/ws/rs/client/Client;", "(Ljavax/ws/rs/client/Client;)V", "jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getAPITarget", "Ljavax/ws/rs/client/WebTarget;", "xdModule", "Ljetbrains/jetpass/auth/module/github/dnq/xd/XdGithubAuthModule;", "getAuthURI", "Ljava/net/URI;", "landingURI", "state", "", "additionalScope", "", "(Ljetbrains/jetpass/auth/module/github/dnq/xd/XdGithubAuthModule;Ljava/net/URI;Ljava/lang/String;[Ljava/lang/String;)Ljava/net/URI;", "getEmail", "Ljetbrains/jetpass/api/authority/profile/EmailContact;", "token", "getErrorMessage", "e", "Ljavax/ws/rs/WebApplicationException;", "getOrganizations", "", "getToken", "code", "getUser", "Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubUser;", "Companion", "jetbrains.jetpass.auth.module.github.dnq"})
public final class GithubAPI {
    private final ObjectMapper jackson;
    private final Client client;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final URI getAuthURI(@NotNull XdGithubAuthModule xdModule, @NotNull URI landingURI, @Nullable String state, @Nullable String[] additionalScope) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        Intrinsics.checkParameterIsNotNull((Object)landingURI, (String)"landingURI");
        Sequence sequence = CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)xdModule.getScope(), (char[])new char[]{' ', ','}, (boolean)false, (int)0, (int)6, null));
        String[] stringArray = additionalScope;
        if (stringArray == null || (stringArray = ArraysKt.asSequence((Object[])stringArray)) == null) {
            stringArray = SequencesKt.emptySequence();
        }
        String scope2 = SequencesKt.joinToString$default((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.plus((Sequence)sequence, (Sequence)stringArray), (Function1)getAuthURI.scope.1.INSTANCE)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        WebTarget webTarget = this.client.target(xdModule.getUrl()).path("login").path("oauth").path("authorize").queryParam("client_id", new Object[]{xdModule.getClientId()}).queryParam("redirect_uri", new Object[]{landingURI.toASCIIString()}).queryParam("scope", new Object[]{scope2}).queryParam("state", new Object[]{UriComponent.encodeTemplateNames((String)state)});
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"client.target(xdModule.u\u2026codeTemplateNames(state))");
        URI uri = webTarget.getUri();
        Companion.getLogger().debug((Function0)new Function0<String>(uri){
            final /* synthetic */ URI $uri;

            @NotNull
            public final String invoke() {
                return "GitHub authorization URL: " + this.$uri;
            }
            {
                this.$uri = uRI;
                super(0);
            }
        });
        URI uRI = uri;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
        return uRI;
    }

    @Nullable
    public final String getToken(@NotNull XdGithubAuthModule xdModule, @NotNull URI landingURI, @NotNull String code) throws GithubAuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        Intrinsics.checkParameterIsNotNull((Object)landingURI, (String)"landingURI");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Companion.getLogger().debug((Function0)getToken.1.INSTANCE);
        Form form = new Form();
        Object object = this.client.target(xdModule.getUrl()).path("login").path("oauth").path("access_token").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Object $receiver = form;
        $receiver.param("client_id", xdModule.getClientId());
        $receiver.param("client_secret", xdModule.getClientSecret());
        $receiver.param("code", code);
        $receiver.param("redirect_uri", landingURI.toASCIIString());
        Object object2 = form;
        Response response = (Response)object.post(Entity.entity((Object)object2, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE), Response.class);
        Companion.getLogger().debug((Function0)new Function0<String>(response){
            final /* synthetic */ Response $response;

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder().append("GitHub authorization code exchange resulted in: ");
                Response response = this.$response;
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"response");
                StringBuilder stringBuilder2 = stringBuilder.append(response.getStatus()).append(": ");
                Response response2 = this.$response;
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
                Response.StatusType statusType = response2.getStatusInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"response.statusInfo");
                return stringBuilder2.append(statusType.getReasonPhrase()).toString();
            }
            {
                this.$response = response;
                super(0);
            }
        });
        Map map = (Map)response.readEntity(Map.class);
        if (map == null) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            throw (Throwable)((Object)GithubAuthenticationException.Companion.emptyResponse(response2.getStatus()));
        }
        Map data = map;
        $receiver = data;
        Object object3 = "error";
        if ($receiver.get(object3) != null) {
            Companion.getLogger().debug((Function0)new Function0<String>(data){
                final /* synthetic */ Map $data;

                @NotNull
                public final String invoke() {
                    return "GitHub authorization code exchange error: " + this.$data;
                }
                {
                    this.$data = map;
                    super(0);
                }
            });
            $receiver = data;
            object3 = "error";
            object = GithubAuthenticationException.Companion;
            Object object4 = object2 = $receiver.get(object3);
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            $receiver = data;
            object3 = "error_description";
            object2 = (String)object4;
            Object v = $receiver.get(object3);
            throw (Throwable)((Object)((GithubAuthenticationException.Companion)object).codeExchangeError((String)object2, (String)v));
        }
        object3 = data;
        String string = "access_token";
        String accessToken = (String)object3.get(string);
        if (accessToken != null) {
            Companion.getLogger().debug((Function0)getToken.4.INSTANCE);
        } else {
            Companion.getLogger().warn((Function0)getToken.5.INSTANCE);
        }
        return accessToken;
    }

    @NotNull
    public final GithubUser getUser(@NotNull XdGithubAuthModule xdModule, @Nullable String token) throws GithubAuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        try {
            Companion.getLogger().debug((Function0)getUser.1.INSTANCE);
            String body = (String)this.getAPITarget(xdModule).path("user").request().header("Authorization", (Object)("Bearer " + token)).accept(new String[]{"application/json"}).get(String.class);
            Companion.getLogger().debug((Function0)new Function0<String>(body){
                final /* synthetic */ String $body;

                @NotNull
                public final String invoke() {
                    return "GitHub user data is " + this.$body;
                }
                {
                    this.$body = string;
                    super(0);
                }
            });
            try {
                Object object = this.jackson.readValue(body, GithubUser.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jackson.readValue(body, GithubUser::class.java)");
                return (GithubUser)object;
            }
            catch (IOException e) {
                String string = body;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"body");
                throw (Throwable)((Object)GithubAuthenticationException.Companion.cantReadUserResponse(string, e));
            }
        }
        catch (WebApplicationException e) {
            String error = this.getErrorMessage(e);
            Companion.getLogger().debug((Function0)new Function0<String>(error){
                final /* synthetic */ String $error;

                @NotNull
                public final String invoke() {
                    return "GitHub user data fetch has failed: " + this.$error;
                }
                {
                    this.$error = string;
                    super(0);
                }
            });
            throw (Throwable)((Object)GithubAuthenticationException.Companion.cantGetUser(error, e));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final EmailContact getEmail(@NotNull XdGithubAuthModule xdModule, @Nullable String token) throws GithubAuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        try {
            EmailContactImpl emailContactImpl;
            Companion.getLogger().debug((Function0)getEmail.1.INSTANCE);
            List emails = (List)this.getAPITarget(xdModule).path("user").path("emails").request().header("Authorization", (Object)("Bearer " + token)).accept(new String[]{"application/json"}).get(List.class);
            Companion.getLogger().debug((Function0)new Function0<String>(emails){
                final /* synthetic */ List $emails;

                @NotNull
                public final String invoke() {
                    return "GitHub user emails: " + this.$emails + ". Picking primary email...";
                }
                {
                    this.$emails = list;
                    super(0);
                }
            });
            List list = emails;
            if (list != null) {
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = list;
                void var6_6 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    EmailContactImpl emailContactImpl2;
                    EmailContactImpl emailContactImpl3;
                    Object element$iv$iv = element$iv$iv$iv;
                    Object it = element$iv$iv;
                    Object t = it;
                    if (!(t instanceof Map)) {
                        t = null;
                    }
                    if ((Map)t != null) {
                        Map map;
                        Map mail;
                        Map map2 = mail = map;
                        Object object = "primary";
                        Object isPrimary = map2.get(object);
                        object = mail;
                        Object object2 = "email";
                        Object email = object.get(object2);
                        object2 = mail;
                        String string = "verified";
                        Object isVerified = object2.get(string);
                        emailContactImpl3 = email instanceof String && isPrimary instanceof Boolean && ((Boolean)isPrimary).booleanValue() ? new EmailContactImpl((String)email, isVerified instanceof Boolean && (Boolean)isVerified != false) : null;
                    } else {
                        emailContactImpl3 = null;
                    }
                    if (emailContactImpl3 == null) continue;
                    EmailContactImpl it$iv$iv = emailContactImpl2 = emailContactImpl3;
                    destination$iv$iv.add(it$iv$iv);
                }
                emailContactImpl = (EmailContactImpl)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            } else {
                emailContactImpl = null;
            }
            EmailContactImpl primaryEmail = emailContactImpl;
            Companion.getLogger().debug((Function0)new Function0<String>(primaryEmail){
                final /* synthetic */ EmailContactImpl $primaryEmail;

                @NotNull
                public final String invoke() {
                    return this.$primaryEmail != null ? "GitHub user primary email: " + this.$primaryEmail.getEmail() + " [" + this.$primaryEmail.isVerified() + ']' : "GitHub user has no primary email";
                }
                {
                    this.$primaryEmail = emailContactImpl;
                    super(0);
                }
            });
            return (EmailContact)primaryEmail;
        }
        catch (WebApplicationException e) {
            String error = this.getErrorMessage(e);
            Companion.getLogger().debug((Function0)new Function0<String>(error){
                final /* synthetic */ String $error;

                @NotNull
                public final String invoke() {
                    return "GitHub user emails fetch has failed: " + this.$error;
                }
                {
                    this.$error = string;
                    super(0);
                }
            });
            throw (Throwable)((Object)GithubAuthenticationException.Companion.cantGetEmail(error, e));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getOrganizations(@NotNull XdGithubAuthModule xdModule, @Nullable String token) throws GithubAuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        try {
            void $receiver$iv$iv;
            void $receiver$iv;
            Companion.getLogger().debug((Function0)getOrganizations.1.INSTANCE);
            List organizations = (List)this.getAPITarget(xdModule).path("user").path("orgs").request().header("Authorization", (Object)("Bearer " + token)).accept(new String[]{"application/json"}).get(List.class);
            Companion.getLogger().debug((Function0)new Function0<String>(organizations){
                final /* synthetic */ List $organizations;

                @NotNull
                public final String invoke() {
                    return "GitHub user organizations: " + this.$organizations;
                }
                {
                    this.$organizations = list;
                    super(0);
                }
            });
            Iterable iterable = organizations;
            List list = iterable;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            iterable = list;
            void var6_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                String string;
                String string2;
                Object element$iv$iv = element$iv$iv$iv;
                Object it = element$iv$iv;
                Object t = it;
                if (!(t instanceof Map)) {
                    t = null;
                }
                if ((Map)t != null) {
                    Map map;
                    Map organization = map;
                    Map map2 = organization;
                    String string3 = "login";
                    Object v = map2.get(string3);
                    if (!(v instanceof String)) {
                        v = null;
                    }
                    string2 = (String)v;
                } else {
                    string2 = null;
                }
                if (string2 == null) continue;
                String it$iv$iv = string = string2;
                destination$iv$iv.add(it$iv$iv);
            }
            List organizationLogins = (List)destination$iv$iv;
            Companion.getLogger().debug((Function0)new Function0<String>(organizationLogins){
                final /* synthetic */ List $organizationLogins;

                @NotNull
                public final String invoke() {
                    return "GitHub user organizations: " + this.$organizationLogins;
                }
                {
                    this.$organizationLogins = list;
                    super(0);
                }
            });
            return organizationLogins;
        }
        catch (WebApplicationException e) {
            String error = this.getErrorMessage(e);
            Companion.getLogger().debug((Function0)new Function0<String>(error){
                final /* synthetic */ String $error;

                @NotNull
                public final String invoke() {
                    return "GitHub user organizations fetch has failed: " + this.$error;
                }
                {
                    this.$error = string;
                    super(0);
                }
            });
            throw (Throwable)((Object)GithubAuthenticationException.Companion.cantGetOrganizations(error, e));
        }
    }

    private final WebTarget getAPITarget(XdGithubAuthModule xdModule) {
        WebTarget webTarget;
        if (StringsKt.startsWith$default((String)xdModule.getUrl(), (String)XdGithubAuthModule.Companion.getURL(), (boolean)false, (int)2, null)) {
            WebTarget webTarget2 = this.client.target("https://api.github.com");
            webTarget = webTarget2;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget2, (String)"client.target(\"https://api.github.com\")");
        } else {
            WebTarget webTarget3 = this.client.target(xdModule.getUrl()).path("api").path("v3");
            webTarget = webTarget3;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget3, (String)"client.target(xdModule.url).path(\"api\").path(\"v3\")");
        }
        return webTarget;
    }

    private final String getErrorMessage(WebApplicationException e) {
        String string;
        String errorRaw = (String)e.getResponse().readEntity(String.class);
        try {
            String string2;
            CharSequence charSequence;
            GithubError githubError = (GithubError)this.jackson.readValue(errorRaw, GithubError.class);
            String message = githubError.getMessage();
            if (message != null && (charSequence = (CharSequence)message).length() == 0) {
                string2 = message;
            } else {
                String string3 = errorRaw;
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"errorRaw");
            }
            string = string2;
        }
        catch (IOException e2) {
            String string4 = errorRaw;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"errorRaw");
            string = string4;
        }
        return string;
    }

    public GithubAPI(@NotNull Client client) {
        ObjectMapper objectMapper;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        ObjectMapper objectMapper2 = new ObjectMapper();
        GithubAPI githubAPI = this;
        ObjectMapper $receiver = objectMapper2;
        $receiver.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        githubAPI.jackson = objectMapper = objectMapper2;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubAPI$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.auth.module.github.dnq"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

