/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.github.dnq.persistence;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B/\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubAuthenticationException;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "code", "", "message", "cause", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "params", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "Companion", "jetbrains.jetpass.auth.module.github.dnq"})
public final class GithubAuthenticationException
extends AuthenticationException {
    @NotNull
    private static final String TOKEN_EXCHANGE_FAILED = "github-token-exchange-failed";
    @NotNull
    private static final String USER_FETCH_FAILED = "github-user-fetch";
    @NotNull
    private static final String BAD_ORG = "github-bad-org";
    public static final Companion Companion = new Companion(null);

    private GithubAuthenticationException(String code, String message, Throwable cause) {
        super(code, message, cause, null, 8, null);
    }

    private GithubAuthenticationException(String code, String message, Map<String, String> params) {
        super(code, message, params);
    }

    /* synthetic */ GithubAuthenticationException(String string, String string2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        this(string, string2, map);
    }

    static {
        TOKEN_EXCHANGE_FAILED = TOKEN_EXCHANGE_FAILED;
        USER_FETCH_FAILED = USER_FETCH_FAILED;
        BAD_ORG = BAD_ORG;
    }

    public /* synthetic */ GithubAuthenticationException(@NotNull String code, @NotNull String message, @NotNull Throwable cause, DefaultConstructorMarker $constructor_marker) {
        this(code, message, cause);
    }

    public /* synthetic */ GithubAuthenticationException(@NotNull String code, @NotNull String message, @Nullable Map params, DefaultConstructorMarker $constructor_marker) {
        this(code, message, params);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001f"}, d2={"Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubAuthenticationException$Companion;", "", "()V", "BAD_ORG", "", "getBAD_ORG", "()Ljava/lang/String;", "TOKEN_EXCHANGE_FAILED", "getTOKEN_EXCHANGE_FAILED", "USER_FETCH_FAILED", "getUSER_FETCH_FAILED", "cantGetEmail", "Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubAuthenticationException;", "errorBody", "e", "Ljavax/ws/rs/WebApplicationException;", "cantGetOrganizations", "cantGetUser", "cantReadUserResponse", "userPayload", "Ljava/io/IOException;", "codeExchangeError", "error", "errorDescription", "emptyResponse", "responseStatus", "", "userDoesntBelongToOrganization", "service", "requiredOrganizations", "", "jetbrains.jetpass.auth.module.github.dnq"})
    public static final class Companion {
        @NotNull
        public final String getTOKEN_EXCHANGE_FAILED() {
            return TOKEN_EXCHANGE_FAILED;
        }

        @NotNull
        public final String getUSER_FETCH_FAILED() {
            return USER_FETCH_FAILED;
        }

        @NotNull
        public final String getBAD_ORG() {
            return BAD_ORG;
        }

        @NotNull
        public final GithubAuthenticationException emptyResponse(int responseStatus) {
            return new GithubAuthenticationException(this.getTOKEN_EXCHANGE_FAILED(), "Hub was unable to exchange code to token from GitHub. GitHub returned no response. Response status: " + responseStatus, null, 4, null);
        }

        @NotNull
        public final GithubAuthenticationException codeExchangeError(@NotNull String error, @Nullable String errorDescription) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            return new GithubAuthenticationException(this.getTOKEN_EXCHANGE_FAILED(), error + ": " + errorDescription, null, 4, null);
        }

        @NotNull
        public final GithubAuthenticationException cantReadUserResponse(@NotNull String userPayload, @NotNull IOException e) {
            Intrinsics.checkParameterIsNotNull((Object)userPayload, (String)"userPayload");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new GithubAuthenticationException(this.getUSER_FETCH_FAILED(), "Cannot parse GitHub user JSON data: " + e.getMessage(), e, null);
        }

        @NotNull
        public final GithubAuthenticationException cantGetUser(@NotNull String errorBody, @NotNull WebApplicationException e) {
            Intrinsics.checkParameterIsNotNull((Object)errorBody, (String)"errorBody");
            Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
            return new GithubAuthenticationException(this.getUSER_FETCH_FAILED(), "Cannot get GitHub user data: " + errorBody, e, null);
        }

        @NotNull
        public final GithubAuthenticationException cantGetEmail(@NotNull String errorBody, @NotNull WebApplicationException e) {
            Intrinsics.checkParameterIsNotNull((Object)errorBody, (String)"errorBody");
            Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
            return new GithubAuthenticationException(this.getUSER_FETCH_FAILED(), "Cannot get email of GitHub user: " + errorBody, e, null);
        }

        @NotNull
        public final GithubAuthenticationException cantGetOrganizations(@NotNull String errorBody, @NotNull WebApplicationException e) {
            Intrinsics.checkParameterIsNotNull((Object)errorBody, (String)"errorBody");
            Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
            return new GithubAuthenticationException(this.getUSER_FETCH_FAILED(), "Cannot get organizations of GitHub user: " + errorBody, e, null);
        }

        @NotNull
        public final GithubAuthenticationException userDoesntBelongToOrganization(@NotNull String service, @NotNull Set<String> requiredOrganizations) {
            Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
            Intrinsics.checkParameterIsNotNull(requiredOrganizations, (String)"requiredOrganizations");
            return new GithubAuthenticationException(this.getBAD_ORG(), "You can't log in with your GitHub account. You don't belong to a GitHub organization " + requiredOrganizations + " that is allowed to use GitHub authentication in " + service + '.', MapsKt.mapOf((Pair)TuplesKt.to((Object)"service", (Object)service)), null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

