/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.github.dnq.persistence;

import com.intellij.hub.auth.OAuthClientValidationException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.dnq.authentication.FederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.State;
import jetbrains.jetpass.auth.module.github.api.user.details.GithubUserDetailsImpl;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubAPI;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubAuthenticationException;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubFederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.github.dnq.persistence.GithubUser;
import jetbrains.jetpass.auth.module.github.dnq.xd.XdGithubAuthModule;
import jetbrains.jetpass.auth.module.github.rest.client.api.GithubUserDetails;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRootService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J5\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0019\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015\u00a2\u0006\u0002\b\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubFederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/dnq/authentication/FederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/github/rest/client/api/GithubUserDetails;", "xdAuthModule", "Ljetbrains/jetpass/auth/module/github/dnq/xd/XdGithubAuthModule;", "api", "Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubAPI;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/auth/module/github/dnq/xd/XdGithubAuthModule;Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubAPI;Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "authenticate", "credentials", "Ljetbrains/jetpass/auth/module/dnq/authentication/ServletRequestCredentials;", "getReturnUri", "Ljava/net/URI;", "authUrl", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "restoreState", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "request", "Ljavax/servlet/http/HttpServletRequest;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "start", "Ljavax/ws/rs/core/Response;", "state", "stateId", "Companion", "jetbrains.jetpass.auth.module.github.dnq"})
public final class GithubFederatedAuthenticationHandler
implements FederatedAuthenticationHandler<GithubUserDetails> {
    private final XdGithubAuthModule xdAuthModule;
    private final GithubAPI api;
    private final JetPassDAOContainer container;
    @NotNull
    private static final String STATE = "state";
    @NotNull
    private static final String CODE = "code";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response start(@NotNull HttpServletRequest request, @NotNull State state, @NotNull String stateId, @NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)STATE);
        Intrinsics.checkParameterIsNotNull((Object)stateId, (String)"stateId");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        URI startURI = this.api.getAuthURI(this.xdAuthModule, state.getLandingUri(), stateId, GithubFederatedAuthenticationHandler.Companion.proxyRequest(state));
        Response response = Response.seeOther((URI)startURI).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(startURI).build()");
        return response;
    }

    @Nullable
    public State restoreState(@NotNull HttpServletRequest request, @NotNull AuthUrl authUrl, @NotNull Function1<? super String, ? extends State> restoreState) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Intrinsics.checkParameterIsNotNull(restoreState, (String)"restoreState");
        String string = request.getParameter(STATE);
        return string != null ? (State)restoreState.invoke((Object)string) : null;
    }

    @Nullable
    public GithubUserDetails authenticate(@NotNull ServletRequestCredentials credentials) throws AuthenticationException {
        GithubUserDetailsImpl githubUserDetailsImpl;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        String string = credentials.getRequest().getParameter(CODE);
        if (string == null) {
            string = "";
        }
        String code = string;
        State state = credentials.getState();
        String token = this.api.getToken(this.xdAuthModule, state.getLandingUri(), code);
        GithubUser user2 = this.api.getUser(this.xdAuthModule, token);
        Object object = this.xdAuthModule.getAllowedOrganizations();
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        Set allowedOrganizations2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null)), (Function1)authenticate.allowedOrganizations.1.INSTANCE));
        object = allowedOrganizations2;
        if (!object.isEmpty()) {
            boolean bl;
            block9: {
                List<String> actualOrganizations = this.api.getOrganizations(this.xdAuthModule, token);
                Iterable $receiver$iv = actualOrganizations;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String string2;
                        String it;
                        String string3 = it = (String)element$iv;
                        Set set = allowedOrganizations2;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                        if (!set.contains(string2)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                githubUserDetailsImpl = XdRootService.Companion.getInstance().getHostService();
                GithubAuthenticationException.Companion companion = GithubAuthenticationException.Companion;
                GithubUserDetailsImpl it = githubUserDetailsImpl;
                String string5 = it.getApplicationName();
                if (string5 == null) {
                    string5 = it.getName();
                }
                String string6 = string5;
                throw (Throwable)((Object)companion.userDoesntBelongToOrganization(string6, allowedOrganizations2));
            }
        }
        GithubUserDetailsImpl $receiver = githubUserDetailsImpl = new GithubUserDetailsImpl();
        $receiver.setAuthModule(this.container.getJetPassAuthModuleDAO().wrapEntity((XdAuthModule)this.xdAuthModule));
        $receiver.setLogin(user2.getLogin());
        $receiver.setFullName(user2.getName());
        $receiver.setAvatar(user2.getAvatar_url());
        $receiver.setEmail(this.api.getEmail(this.xdAuthModule, token));
        GithubUserDetailsImpl details2 = githubUserDetailsImpl;
        GithubFederatedAuthenticationHandler.Companion.proxyResponse(state, token);
        return (GithubUserDetails)details2;
    }

    @NotNull
    public URI getReturnUri(@NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        URI uRI = URI.create(this.xdAuthModule.getRedirectUri(authUrl));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(xdAuthModule.getRedirectUri(authUrl))");
        return uRI;
    }

    public GithubFederatedAuthenticationHandler(@NotNull XdGithubAuthModule xdAuthModule, @NotNull GithubAPI api, @NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdAuthModule), (String)"xdAuthModule");
        Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.xdAuthModule = xdAuthModule;
        this.api = api;
        this.container = container;
    }

    static {
        STATE = STATE;
        CODE = CODE;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/auth/module/github/dnq/persistence/GithubFederatedAuthenticationHandler$Companion;", "", "()V", "CODE", "", "getCODE", "()Ljava/lang/String;", "STATE", "getSTATE", "proxyRequest", "", "state", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "(Ljetbrains/jetpass/auth/module/dnq/authentication/State;)[Ljava/lang/String;", "proxyResponse", "", "token", "jetbrains.jetpass.auth.module.github.dnq"})
    public static final class Companion {
        @NotNull
        public final String getSTATE() {
            return STATE;
        }

        @NotNull
        public final String getCODE() {
            return CODE;
        }

        private final String[] proxyRequest(State state) throws RuntimeException {
            String[] stringArray;
            if (state.isProxied()) {
                Map authParams = state.getAuthParameters();
                String string = (String)authParams.get("client_id");
                if (string == null) {
                    throw (Throwable)OAuthClientValidationException.Companion.invalidParameter("client_id");
                }
                String clientId = string;
                XdService xdService = XdService.Companion.resolve(clientId);
                if (xdService == null) {
                    throw (Throwable)OAuthClientValidationException.Companion.unknownService(clientId);
                }
                XdService clientService = xdService;
                if (!clientService.getTrusted()) {
                    throw (Throwable)new RuntimeException("Can't proxy token to untrusted service");
                }
                String redirectUri = URLDecoder.decode((String)authParams.get("redirect_uri"), "UTF-8");
                if (!clientService.matchesRedirectUri(redirectUri)) {
                    String string2 = clientService.getName();
                    String string3 = redirectUri;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"redirectUri");
                    throw (Throwable)OAuthClientValidationException.Companion.unregisteredRedirectURI(string2, string3);
                }
                state.setProxyURI(URI.create(redirectUri));
                Object object = (String)authParams.get("scope");
                if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null)) != null) {
                    Collection $receiver$iv;
                    Collection collection = $receiver$iv = (Collection)object;
                    if (collection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = collection;
                    String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                    if (stringArray2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    stringArray = stringArray2;
                } else {
                    stringArray = null;
                }
            } else {
                stringArray = null;
            }
            return stringArray;
        }

        private final void proxyResponse(State state, String token) {
            URI proxyUri = state.getProxyURI();
            if (proxyUri != null) {
                UriBuilder uriBuilder = UriBuilder.fromUri((URI)proxyUri);
                String stateParam = (String)state.getAuthParameters().get(GithubFederatedAuthenticationHandler.STATE);
                if (stateParam != null) {
                    uriBuilder.queryParam(GithubFederatedAuthenticationHandler.STATE, new Object[]{stateParam});
                }
                uriBuilder.queryParam("access_token", new Object[]{token});
                state.setProxyURI(uriBuilder.build(new Object[0]));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

