/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.hub2hub.conflicts;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.hub2hub.conflicts.DatabaseConstraints;
import jetbrains.jetpass.hub2hub.conflicts.DatabaseConstraints$applyHostServiceLicense$2$1$1;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDashboardPermission;
import jetbrains.jetpass.userManagement.persistence.dnq.XdLicenseSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUserDashboard;
import jetbrains.jetpass.userManagement.persistence.dnq.XdVCSUserName;
import jetbrains.jetpass.userManagement.persistence.license.LicenseExtensionKt;
import jetbrains.jetpass.userManagement.persistence.migration.RefactoringUtil;
import jetbrains.ring.license.InvalidLicenseException;
import jetbrains.ring.license.License;
import jetbrains.ring.license.reader.LicenseReader;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\tH\u0007J\b\u0010\u0010\u001a\u00020\tH\u0007J\b\u0010\u0011\u001a\u00020\tH\u0007J\b\u0010\u0012\u001a\u00020\tH\u0007J\b\u0010\u0013\u001a\u00020\tH\u0007J0\u0010\u0014\u001a\u00020\t\"\b\b\u0000\u0010\u0015*\u00020\u0016*\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00040\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/jetpass/hub2hub/conflicts/DatabaseConstraints;", "Lmu/KLogging;", "()V", "CHILD_TO_PARENT_LINK_NAME", "", "PACK_SIZE", "", "PARENT_TO_CHILD_LINK_NAME", "applyHostServiceLicense", "", "checkAndFixBackLink", "", "child", "Ljetbrains/exodus/entitystore/Entity;", "type", "fixAggregationBackLinks", "fixJPDashboardPermissions", "fixJPProjectRoles", "fixJPUserDashboards", "fixVCSUserNames", "fixUniqueness", "E", "Lkotlinx/dnq/XdEntity;", "Lkotlinx/dnq/XdEntityType;", "getUniqueValue", "Lkotlin/Function1;", "jetbrains.jetpass.hub2hub.jobs"})
public final class DatabaseConstraints
extends KLogging {
    @NotNull
    public static final String CHILD_TO_PARENT_LINK_NAME = "__CHILD_TO_PARENT_LINK_NAME__";
    @NotNull
    public static final String PARENT_TO_CHILD_LINK_NAME = "__PARENT_TO_CHILD_LINK_NAME__";
    private static final int PACK_SIZE = 5000;
    public static final DatabaseConstraints INSTANCE;

    @JvmStatic
    public static final void applyHostServiceLicense() {
        block5: {
            boolean bl;
            XdLicenseSettings xdLicenseSettings;
            XdService hostService = XdRoots.INSTANCE.getRootService().getHostService();
            String hostServiceName = hostService.getName();
            XdLicenseSettings xdLicenseSettings2 = hostService.getLicense();
            if (xdLicenseSettings2 == null) break block5;
            XdLicenseSettings it = xdLicenseSettings = xdLicenseSettings2;
            try {
                boolean bl2;
                License license = new LicenseReader().read(it.getLicenseName(), it.getLicenseKey());
                Intrinsics.checkExpressionValueIsNotNull((Object)license, (String)"LicenseReader().read(it.\u2026censeName, it.licenseKey)");
                if (LicenseExtensionKt.isUnlimited((License)license)) {
                    INSTANCE.getLogger().info((Function0)new Function0<String>(it, hostServiceName){
                        final /* synthetic */ XdLicenseSettings $it;
                        final /* synthetic */ String $hostServiceName$inlined;
                        {
                            this.$it = xdLicenseSettings;
                            this.$hostServiceName$inlined = string;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "License '" + this.$it.getLicenseName() + "' for '" + this.$hostServiceName$inlined + "' is unlimited. No users assigned with license explicitly.";
                        }
                    });
                    bl2 = false;
                } else {
                    bl2 = true;
                }
                bl = bl2;
            }
            catch (InvalidLicenseException e) {
                INSTANCE.getLogger().warn((Throwable)e, (Function0)new Function0<String>(hostServiceName){
                    final /* synthetic */ String $hostServiceName$inlined;
                    {
                        this.$hostServiceName$inlined = string;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "License for service '" + this.$hostServiceName$inlined + "' is invalid. Users won't be assigned with the license";
                    }
                });
                bl = false;
            }
            if ((xdLicenseSettings2 = bl ? xdLicenseSettings : null) != null) {
                XdLicenseSettings xdLicense = xdLicenseSettings = xdLicenseSettings2;
                RefactoringUtil.INSTANCE.doUnit((Function0)new Function0<Iterable<? extends XdBaseUser>>(xdLicense){
                    final /* synthetic */ XdLicenseSettings $xdLicense;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Iterable<XdBaseUser> invoke() {
                        void value$iv;
                        void $receiver$iv;
                        KProperty1 kProperty1 = (KProperty1)DatabaseConstraints$applyHostServiceLicense$2$1$1.INSTANCE;
                        Comparable comparable = Boolean.valueOf(true);
                        XdQuery xdQuery = XdBaseUser.Companion.all();
                        NodeBase nodeBase = NodeBaseOperationsKt.ne((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdBaseUser.class)), (Comparable)value$iv);
                        return SequencesKt.asIterable((Sequence)XdQueryKt.asSequence((XdQuery)XdQueryKt.exclude((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)nodeBase), (XdQuery)((XdQuery)this.$xdLicense.getUsers()))));
                    }
                    {
                        this.$xdLicense = xdLicenseSettings;
                        super(0);
                    }
                }, (Function1)new Function1<XdBaseUser, Unit>(xdLicense){
                    final /* synthetic */ XdLicenseSettings $xdLicense;

                    public final void invoke(@NotNull XdBaseUser it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        it.getLicenses().add((XdEntity)this.$xdLicense);
                    }
                    {
                        this.$xdLicense = xdLicenseSettings;
                        super(1);
                    }
                }, "Added %d license(s) to users from service: " + hostServiceName);
            }
        }
    }

    @JvmStatic
    public static final void fixVCSUserNames() {
        INSTANCE.fixUniqueness((XdEntityType)XdVCSUserName.Companion, fixVCSUserNames.1.INSTANCE);
    }

    @JvmStatic
    public static final void fixJPProjectRoles() {
        INSTANCE.fixUniqueness((XdEntityType)XdProjectRole.Companion, fixJPProjectRoles.1.INSTANCE);
    }

    @JvmStatic
    public static final void fixJPDashboardPermissions() {
        INSTANCE.fixUniqueness((XdEntityType)XdDashboardPermission.Companion, fixJPDashboardPermissions.1.INSTANCE);
    }

    @JvmStatic
    public static final void fixJPUserDashboards() {
        INSTANCE.fixUniqueness((XdEntityType)XdUserDashboard.Companion, fixJPUserDashboards.1.INSTANCE);
    }

    private final <E extends XdEntity> void fixUniqueness(@NotNull XdEntityType<? extends E> $receiver, Function1<? super E, String> getUniqueValue) {
        Sequence allItems = XdQueryKt.asSequence((XdQuery)$receiver.all());
        HashSet<String> index = new HashSet<String>(SequencesKt.count((Sequence)allItems));
        Sequence $receiver$iv = allItems;
        for (Object element$iv : $receiver$iv) {
            String unique;
            String string;
            XdEntity it = (XdEntity)element$iv;
            String string2 = string = (String)getUniqueValue.invoke((Object)it);
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            if (index.contains(unique)) {
                INSTANCE.getLogger().warn((Function0)new Function0<String>(unique, $receiver, getUniqueValue, index){
                    final /* synthetic */ String $unique;
                    final /* synthetic */ XdEntityType receiver$0$inlined;
                    final /* synthetic */ Function1 $getUniqueValue$inlined;
                    final /* synthetic */ HashSet $index$inlined;
                    {
                        this.$unique = string;
                        this.receiver$0$inlined = xdEntityType;
                        this.$getUniqueValue$inlined = function1;
                        this.$index$inlined = hashSet;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Index corrupted for " + this.receiver$0$inlined.getEntityType() + ':' + this.$unique + " - will be removed";
                    }
                });
                it.delete();
                continue;
            }
            index.add(unique);
        }
    }

    @JvmStatic
    public static final void fixAggregationBackLinks() {
        StoreTransaction storeTransaction = DnqUtils.getCurrentPersistentSession();
        if (storeTransaction == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.PersistentStoreTransaction");
        }
        PersistentStoreTransaction txn = (PersistentStoreTransaction)storeTransaction;
        block0: for (String type2 : txn.getEntityTypes()) {
            int processed = 0;
            int fixed = 0;
            while (true) {
                int inc = 0;
                EntityIterableBase children2 = txn.findWithProp(type2, PARENT_TO_CHILD_LINK_NAME);
                EntityIterator entityIterator = children2.skip(processed).take(5000).iterator();
                while (entityIterator.hasNext()) {
                    Entity child;
                    Entity entity = child = (Entity)entityIterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"child");
                    String string = type2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type");
                    if (INSTANCE.checkAndFixBackLink(entity, string)) {
                        ++fixed;
                    }
                    ++inc;
                }
                if (inc <= 0) continue block0;
                processed += inc;
                if (fixed <= 5000) continue;
                txn.flush();
                fixed = 0;
            }
        }
        txn.flush();
    }

    private final boolean checkAndFixBackLink(Entity child, String type2) throws IllegalStateException {
        String string = (String)((Object)child.getProperty(PARENT_TO_CHILD_LINK_NAME));
        if (string == null) {
            throw (Throwable)new IllegalStateException("__PARENT_TO_CHILD_LINK_NAME__ link " + type2 + " is broken!");
        }
        String parentToChildLinkName = string;
        String string2 = (String)((Object)child.getProperty(CHILD_TO_PARENT_LINK_NAME));
        if (string2 == null) {
            throw (Throwable)new IllegalStateException("__CHILD_TO_PARENT_LINK_NAME__ link " + type2 + " is broken!");
        }
        String childToParentLinkName = string2;
        Entity parent2 = child.getLink(childToParentLinkName);
        if (!EntityOperations.equals((Entity)parent2, null)) {
            EntityIterable myChildren;
            Entity entity = parent2;
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            if (!(myChildren = entity.getLinks(parentToChildLinkName)).contains(child) && !EntityOperations.equals((Entity)child, (Object)parent2.getLink(parentToChildLinkName))) {
                this.getLogger().warn((Function0)new Function0<String>(parent2, parentToChildLinkName, child){
                    final /* synthetic */ Entity $parent;
                    final /* synthetic */ String $parentToChildLinkName;
                    final /* synthetic */ Entity $child;

                    @NotNull
                    public final String invoke() {
                        return this.$parent.getType() + '.' + this.$parentToChildLinkName + " doesn't contain: " + this.$child.getId();
                    }
                    {
                        this.$parent = entity;
                        this.$parentToChildLinkName = string;
                        this.$child = entity2;
                        super(0);
                    }
                });
                this.getLogger().warn((Function0)new Function0<String>(child, parent2, parentToChildLinkName){
                    final /* synthetic */ Entity $child;
                    final /* synthetic */ Entity $parent;
                    final /* synthetic */ String $parentToChildLinkName;

                    @NotNull
                    public final String invoke() {
                        return "Adding child " + this.$child.getId() + " to parent " + this.$parent.getId() + " as " + this.$parentToChildLinkName;
                    }
                    {
                        this.$child = entity;
                        this.$parent = entity2;
                        this.$parentToChildLinkName = string;
                        super(0);
                    }
                });
                return parent2.addLink(parentToChildLinkName, child);
            }
        }
        return false;
    }

    private DatabaseConstraints() {
    }

    static {
        DatabaseConstraints databaseConstraints;
        INSTANCE = databaseConstraints = new DatabaseConstraints();
    }
}

