/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.hub2hub.extract;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import jetbrains.jetpass.userManagement.userJob.CancellationToken;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J:\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u00152\b\b\u0002\u0010\r\u001a\u00020\u000eJ,\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0015H\u0002J\u0015\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH$\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Ljetbrains/jetpass/hub2hub/extract/ArchiveExtractor;", "ArchiveStream", "Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "", "format", "", "(Ljava/lang/String;)V", "getFormat", "()Ljava/lang/String;", "countEntries", "", "inputStream", "Ljava/io/InputStream;", "cancellationToken", "Ljetbrains/jetpass/userManagement/userJob/CancellationToken;", "extract", "", "targetFolder", "Ljava/io/File;", "Lkotlin/Function0;", "updateProgress", "Lkotlin/Function1;", "notifyProgress", "progress", "total", "openArchiveStream", "(Ljava/io/InputStream;)Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "jetbrains.jetpass.hub2hub.jobs"})
public abstract class ArchiveExtractor<ArchiveStream extends ArchiveInputStream> {
    @NotNull
    private final String format;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void extract(@NotNull File targetFolder, @NotNull Function0<? extends InputStream> inputStream, @NotNull Function1<? super Integer, Unit> updateProgress, @NotNull CancellationToken cancellationToken) {
        int total;
        Intrinsics.checkParameterIsNotNull((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkParameterIsNotNull(inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull(updateProgress, (String)"updateProgress");
        Intrinsics.checkParameterIsNotNull((Object)cancellationToken, (String)"cancellationToken");
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        if ((total = this.countEntries((InputStream)inputStream.invoke(), cancellationToken)) == 0) {
            throw (Throwable)new IOException("Input is not in the " + this.format + " format or empty");
        }
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Closeable closeable = (Closeable)this.openArchiveStream((InputStream)inputStream.invoke());
        Throwable throwable = null;
        try {
            void $receiver$iv;
            void progress;
            ArchiveEntry archiveEntry;
            ArchiveInputStream stream = (ArchiveInputStream)closeable;
            if (stream.getNextEntry() == null) {
                ArchiveExtractor archiveExtractor;
                ArchiveExtractor $receiver = archiveExtractor = this;
                updateProgress.invoke((Object)100);
                return;
            }
            ArchiveEntry firstEntry = archiveEntry;
            Sequence sequence = SequencesKt.generateSequence((Object)firstEntry, (Function1)((Function1)new Function1<ArchiveEntry, ArchiveEntry>(stream, this, updateProgress, cancellationToken, targetFolder, (Ref.IntRef)progress, total){
                final /* synthetic */ ArchiveInputStream $stream;
                final /* synthetic */ ArchiveExtractor this$0;
                final /* synthetic */ Function1 $updateProgress$inlined;
                final /* synthetic */ CancellationToken $cancellationToken$inlined;
                final /* synthetic */ File $targetFolder$inlined;
                final /* synthetic */ Ref.IntRef $progress$inlined;
                final /* synthetic */ int $total$inlined;
                {
                    this.$stream = archiveInputStream;
                    this.this$0 = archiveExtractor;
                    this.$updateProgress$inlined = function1;
                    this.$cancellationToken$inlined = cancellationToken;
                    this.$targetFolder$inlined = file;
                    this.$progress$inlined = intRef;
                    this.$total$inlined = n;
                    super(1);
                }

                public final ArchiveEntry invoke(@NotNull ArchiveEntry it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$cancellationToken$inlined.checkCanceled();
                    return this.$stream.getNextEntry();
                }
            }));
            for (Object element$iv : $receiver$iv) {
                ArchiveEntry entry = (ArchiveEntry)element$iv;
                File outputFile = new File(targetFolder, entry.getName());
                if (entry.isDirectory() && !outputFile.exists()) {
                    if (!outputFile.mkdirs()) {
                        throw (Throwable)new IllegalArgumentException("Can't create directory " + outputFile.getAbsolutePath());
                    }
                } else {
                    File parentFile = outputFile.getParentFile();
                    if (!parentFile.exists() && !parentFile.mkdirs()) {
                        StringBuilder stringBuilder = new StringBuilder().append("Can't create directory ");
                        File file = parentFile;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parentFile");
                        throw (Throwable)new IllegalArgumentException(stringBuilder.append(file.getAbsolutePath()).toString());
                    }
                    FileOutputStream fout = new FileOutputStream(outputFile);
                    IOUtils.copy((InputStream)((InputStream)stream), (OutputStream)fout);
                    fout.close();
                }
                Date date = entry.getLastModifiedDate();
                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"entry.lastModifiedDate");
                outputFile.setLastModified(date.getTime());
                void v4 = progress;
                ++v4.element;
                this.notifyProgress(v4.element, total, updateProgress);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* bridge */ /* synthetic */ void extract$default(ArchiveExtractor archiveExtractor, File file, Function0 function0, Function1 function1, CancellationToken cancellationToken, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extract");
        }
        if ((n & 8) != 0) {
            cancellationToken = CancellationToken.Companion.getNOOP();
        }
        archiveExtractor.extract(file, (Function0<InputStream>)function0, (Function1<Integer, Unit>)function1, cancellationToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int countEntries(InputStream inputStream, CancellationToken cancellationToken) {
        Closeable closeable = (Closeable)this.openArchiveStream(inputStream);
        Throwable throwable = null;
        try {
            ArchiveEntry archiveEntry;
            ArchiveInputStream stream = (ArchiveInputStream)closeable;
            if (stream.getNextEntry() == null) {
                int n = 0;
                return n;
            }
            ArchiveEntry firstEntry = archiveEntry;
            int n = SequencesKt.count((Sequence)SequencesKt.generateSequence((Object)firstEntry, (Function1)((Function1)new Function1<ArchiveEntry, ArchiveEntry>(stream, cancellationToken){
                final /* synthetic */ ArchiveInputStream $stream;
                final /* synthetic */ CancellationToken $cancellationToken$inlined;
                {
                    this.$stream = archiveInputStream;
                    this.$cancellationToken$inlined = cancellationToken;
                    super(1);
                }

                public final ArchiveEntry invoke(@NotNull ArchiveEntry it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$cancellationToken$inlined.checkCanceled();
                    return this.$stream.getNextEntry();
                }
            })));
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    protected abstract ArchiveStream openArchiveStream(@NotNull InputStream var1);

    private final void notifyProgress(int progress, int total, Function1<? super Integer, Unit> updateProgress) {
        int o = (int)((double)(progress - 1) * 100.0) / total;
        int n = (int)((double)progress * 100.0) / total;
        if (o < n) {
            updateProgress.invoke((Object)n);
        }
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public ArchiveExtractor(@NotNull String format) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        this.format = format;
    }
}

