/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.openSearch.runtime;

import jetbrains.mps.webr.openSearch.runtime.OpenSearchTemplate;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.SimpleActionController;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.TextBuilder;

public class OpenSearchActionFactory
extends ActionFactory {
    private Class<? extends OpenSearchTemplate> myTemplateClass;

    public OpenSearchActionFactory(String controllerName) {
        super(controllerName);
    }

    public ActionController createAction(String actionName, String windowId) {
        return new Action(actionName, windowId);
    }

    public Class<? extends OpenSearchTemplate> getTemplateClass() {
        return this.myTemplateClass;
    }

    public void setTemplateClass(Class<? extends OpenSearchTemplate> value) {
        this.myTemplateClass = value;
    }

    private class Action
    extends SimpleActionController {
        public Action(String actionName, String windowId) {
            super(actionName, windowId, (ActionFactory)OpenSearchActionFactory.this);
        }

        protected ResponseAction processSimpleAction() {
            try {
                OpenSearchTemplate rssTemplate = OpenSearchActionFactory.this.getTemplateClass().newInstance();
                return ResponseFactory.getInstance().getXmlRenderResponseAction((TextBuilder)rssTemplate, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

