/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.queries;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public abstract class EnumConst {
    private static final String NAME = "__ENUM_CONST_NAME__";
    public final String id;
    public final String className;
    private final Container container;

    public EnumConst(String name, String className, Container container) {
        this.id = name;
        this.className = className;
        this.container = container;
    }

    public final Entity get() {
        TransientEntityStoreImpl store = (TransientEntityStoreImpl)((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
        Entity result = store.getCachedEnumValue(this.className, this.id);
        if (result == null) {
            EntityIterator it = DnqUtils.getCurrentPersistentSession().find(this.className, NAME, (Comparable)((Object)this.id)).iterator();
            if (!it.hasNext()) {
                throw new IllegalStateException("Instance not created: " + this.className + '.' + this.id);
            }
            result = (Entity)it.next();
            store.setCachedEnumValue(this.className, this.id, result);
        }
        return DnqUtils.getCurrentTransientSession().newEntity(result);
    }

    public abstract void update(Entity var1);

    public static void initContainer(Container container) {
        Container[] referenced = container.getReferencedEnums();
        for (int i = 0; i < referenced.length; ++i) {
            EnumConst.initContainer(referenced[i]);
        }
        EnumConst[] consts = container.getAll();
        int length = consts.length;
        if (length > 0) {
            String className = consts[0].className;
            for (int i = 0; i < length; ++i) {
                EnumConst enumConst = consts[i];
                Entity entity = QueryOperations.getFirst((Iterable<Entity>)QueryOperations.query(null, className, (NodeBase)new PropertyEqual(NAME, (Comparable)((Object)enumConst.id))));
                if (entity == null) {
                    entity = DnqUtils.getCurrentTransientSession().newEntity(className);
                    enumConst.update(entity);
                    PrimitiveAssociationSemantics.set((Entity)entity, (String)NAME, (Comparable)((Object)enumConst.id), String.class);
                    continue;
                }
                enumConst.update(entity);
            }
            DnqUtils.getCurrentTransientSession().flush();
        }
    }

    public static interface Container {
        public EnumConst[] getAll();

        public Container[] getReferencedEnums();

        public void initStaticVariables();
    }
}

