/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.accessLog;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.userManagement.accessLog.AccessSaveAction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import webr.framework.controller.BeanContainerAwareSingleThreadDelegatingJobProcessor;

@Component(value="accessLogSaver")
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001\"B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u00020\u001d2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0010J\b\u0010 \u001a\u00020\u001dH\u0007J\b\u0010!\u001a\u00020\u001dH\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ljetbrains/jetpass/userManagement/accessLog/AccessLogSaver;", "", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "(Ljetbrains/jetpass/service/api/HubPrincipalManager;)V", "flushDelayMillis", "", "getFlushDelayMillis", "()I", "setFlushDelayMillis", "(I)V", "getHubPrincipalManager", "()Ljetbrains/jetpass/service/api/HubPrincipalManager;", "itemsToSave", "Ljava/util/HashMap;", "Ljetbrains/jetpass/userManagement/accessLog/AccessSaveAction$Key;", "Ljetbrains/jetpass/userManagement/accessLog/AccessSaveAction;", "jobProcessor", "Lwebr/framework/controller/BeanContainerAwareSingleThreadDelegatingJobProcessor;", "getJobProcessor", "()Lwebr/framework/controller/BeanContainerAwareSingleThreadDelegatingJobProcessor;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "packSize", "getPackSize", "setPackSize", "saveJob", "Ljetbrains/jetpass/userManagement/accessLog/AccessLogSaver$PeriodicFlushJob;", "flush", "", "saveAccess", "action", "startJobProcessor", "stopJobProcessor", "PeriodicFlushJob", "jetbrains.jetpass.userManagement"})
public class AccessLogSaver {
    private HashMap<AccessSaveAction.Key<?>, AccessSaveAction<?>> itemsToSave;
    private final ReentrantLock lock;
    private final PeriodicFlushJob saveJob;
    @NotNull
    private final BeanContainerAwareSingleThreadDelegatingJobProcessor jobProcessor;
    private int packSize;
    private int flushDelayMillis;
    @NotNull
    private final HubPrincipalManager hubPrincipalManager;

    @NotNull
    public final BeanContainerAwareSingleThreadDelegatingJobProcessor getJobProcessor() {
        return this.jobProcessor;
    }

    public final int getPackSize() {
        return this.packSize;
    }

    public final void setPackSize(int n) {
        this.packSize = n;
    }

    public final int getFlushDelayMillis() {
        return this.flushDelayMillis;
    }

    public final void setFlushDelayMillis(int n) {
        this.flushDelayMillis = n;
    }

    @PostConstruct
    public final void startJobProcessor() {
        this.jobProcessor.start();
    }

    @PreDestroy
    public final void stopJobProcessor() {
        this.jobProcessor.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveAccess(@NotNull AccessSaveAction<?> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Lock lock = this.lock;
        lock.lock();
        try {
            Map map = this.itemsToSave;
            Unit unit = action.getKey();
            AccessSaveAction<?> accessSaveAction = action;
            map.put(unit, accessSaveAction);
            unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.jobProcessor.queueIn((Job)this.saveJob, (long)this.flushDelayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void flush() {
        void var4_3;
        Lock lock = this.lock;
        lock.lock();
        try {
            void var3_2;
            HashMap<AccessSaveAction.Key<?>, AccessSaveAction<?>> swap = this.itemsToSave;
            this.itemsToSave = new HashMap(Math.max(16, swap.size()));
            var4_3 = var3_2;
        }
        finally {
            lock.unlock();
        }
        void current = var4_3;
        Iterator iterator = current.entrySet().iterator();
        do {
            TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(this, iterator){
                final /* synthetic */ AccessLogSaver this$0;
                final /* synthetic */ Iterator $iterator;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    int saved = 0;
                    while (this.$iterator.hasNext() && saved++ < this.this$0.getPackSize()) {
                        Map.Entry entry = (Map.Entry)this.$iterator.next();
                        ((AccessSaveAction)entry.getValue()).flush();
                    }
                }
                {
                    this.this$0 = accessLogSaver;
                    this.$iterator = iterator;
                    super(1);
                }
            }, 7, null);
        } while (iterator.hasNext());
    }

    @NotNull
    public final HubPrincipalManager getHubPrincipalManager() {
        return this.hubPrincipalManager;
    }

    @Inject
    public AccessLogSaver(@NotNull HubPrincipalManager hubPrincipalManager) {
        Intrinsics.checkParameterIsNotNull((Object)hubPrincipalManager, (String)"hubPrincipalManager");
        this.hubPrincipalManager = hubPrincipalManager;
        this.itemsToSave = new HashMap();
        this.lock = new ReentrantLock();
        this.saveJob = new PeriodicFlushJob();
        this.jobProcessor = new BeanContainerAwareSingleThreadDelegatingJobProcessor("JetPassAccessLogSaverProcessor");
        this.packSize = 1024;
        this.flushDelayMillis = 1000;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ljetbrains/jetpass/userManagement/accessLog/AccessLogSaver$PeriodicFlushJob;", "Ljetbrains/exodus/core/execution/Job;", "(Ljetbrains/jetpass/userManagement/accessLog/AccessLogSaver;)V", "execute", "", "getName", "", "jetbrains.jetpass.userManagement"})
    private final class PeriodicFlushJob
    extends Job {
        @NotNull
        public String getName() {
            return "Flush user access";
        }

        protected void execute() {
            AccessLogSaver.this.getHubPrincipalManager().runAsRoot((Function0)new Function0<Unit>(this){
                final /* synthetic */ PeriodicFlushJob this$0;

                public final void invoke() {
                    this.this$0.AccessLogSaver.this.flush();
                }
                {
                    this.this$0 = periodicFlushJob;
                    super(0);
                }
            });
        }
    }
}

