/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.authmodule;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdKeyStore;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdExternalAuthModule;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdExternalPasswordAuthModule;
import jetbrains.jetpass.userManagement.persistence.ssl.SSLContextFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="webTargetCache")
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/userManagement/persistence/authmodule/WebTargetCache;", "", "sslContextFactory", "Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory;", "(Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory;)V", "cache", "Ljava/util/HashMap;", "Ljetbrains/exodus/entitystore/EntityId;", "Ljavax/ws/rs/client/Client;", "getSslContextFactory", "()Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory;", "createClient", "module", "Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdExternalAuthModule;", "getOrCreate", "Ljavax/ws/rs/client/WebTarget;", "getOrCreateClient", "remove", "", "settings", "jetbrains.jetpass.userManagement"})
public class WebTargetCache {
    private final HashMap<EntityId, Client> cache;
    @NotNull
    private final SSLContextFactory sslContextFactory;

    @NotNull
    public final WebTarget getOrCreate(@NotNull XdExternalAuthModule module) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)module), (String)"module");
        WebTarget webTarget = this.getOrCreateClient(module).target(module.getUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"getOrCreateClient(module).target(module.url)");
        return webTarget;
    }

    @NotNull
    public final synchronized Client getOrCreateClient(@NotNull XdExternalAuthModule module) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)module), (String)"module");
        EntityId id = module.getEntityId();
        Client client = this.cache.get(id);
        if (client == null) {
            Client client2;
            Client $receiver = client2 = this.createClient(module);
            Map map = this.cache;
            EntityId entityId = id;
            Client client3 = $receiver;
            map.put(entityId, client3);
            client = client2;
        }
        return client;
    }

    private final Client createClient(XdExternalAuthModule module) {
        JerseyClientBuilder builder = new JerseyClientBuilder();
        builder.getConfiguration().connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        builder.property("jersey.config.apache.client.handleCookies", (Object)true);
        builder.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(this, builder, module){
            final /* synthetic */ WebTargetCache this$0;
            final /* synthetic */ JerseyClientBuilder $builder;
            final /* synthetic */ XdExternalAuthModule $module;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$builder.property("jersey.config.client.connectTimeout", (Object)this.$module.getConnectionTimeout());
                this.$builder.property("jersey.config.client.readTimeout", (Object)this.$module.getReadTimeout());
                if (StringsKt.startsWith((String)this.$module.getUrl(), (String)"https", (boolean)true) && this.$module instanceof XdExternalPasswordAuthModule) {
                    XdKeyStore key2 = ((XdExternalPasswordAuthModule)this.$module).getKey();
                    this.$builder.sslContext(this.this$0.getSslContextFactory().getSSLContext(key2));
                }
            }
            {
                this.this$0 = webTargetCache;
                this.$builder = jerseyClientBuilder;
                this.$module = xdExternalAuthModule;
                super(1);
            }
        }, 7, null);
        JerseyClient jerseyClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jerseyClient, (String)"builder.build()");
        return (Client)jerseyClient;
    }

    public final synchronized void remove(@NotNull XdExternalAuthModule settings) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)settings), (String)"settings");
        this.cache.remove(settings.getEntityId());
    }

    @NotNull
    public final SSLContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Inject
    public WebTargetCache(@NotNull SSLContextFactory sslContextFactory) {
        Intrinsics.checkParameterIsNotNull((Object)sslContextFactory, (String)"sslContextFactory");
        this.sslContextFactory = sslContextFactory;
        this.cache = new HashMap();
    }
}

