/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.backup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\f\u001a\u00020\u0000H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u0016J\"\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u001a\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00060\u00060\u0014*\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/userManagement/persistence/backup/FolderBackupStrategy;", "Ljetbrains/exodus/backup/BackupStrategy;", "Ljetbrains/exodus/backup/Backupable;", "prefix", "", "location", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "collect", "", "Ljetbrains/exodus/backup/BackupStrategy$FileDescriptor;", "dir", "getBackupStrategy", "getContents", "Ljetbrains/exodus/backup/VirtualFileDescriptor;", "addDescriptors", "", "", "input", "listSortedFiles", "", "kotlin.jvm.PlatformType", "jetbrains.jetpass.userManagement"})
public final class FolderBackupStrategy
extends BackupStrategy
implements Backupable {
    private final String prefix;
    private final File location;

    @NotNull
    public Iterable<VirtualFileDescriptor> getContents() {
        Iterable iterable;
        if (!this.location.exists()) {
            BackupStrategy backupStrategy = BackupStrategy.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)backupStrategy, (String)"BackupStrategy.EMPTY");
            Iterable iterable2 = backupStrategy.getContents();
            iterable = iterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"BackupStrategy.EMPTY.contents");
        } else {
            iterable = this.location.isDirectory() ? this.collect(this.location, this.prefix) : (Iterable)CollectionsKt.listOf((Object)new BackupStrategy.FileDescriptor(this.location, this.prefix));
        }
        return iterable;
    }

    @NotNull
    public FolderBackupStrategy getBackupStrategy() {
        return this;
    }

    private final Iterable<BackupStrategy.FileDescriptor> collect(File dir, String prefix) {
        ArrayList descriptors = new ArrayList();
        for (File file : this.listSortedFiles(dir)) {
            List list = descriptors;
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            this.addDescriptors(list, prefix, file2);
        }
        return descriptors;
    }

    private final void addDescriptors(@NotNull List<BackupStrategy.FileDescriptor> $receiver, String prefix, File input) {
        if (input.isDirectory()) {
            for (File file : this.listSortedFiles(input)) {
                String string = prefix + File.separator + input.getName();
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                this.addDescriptors($receiver, string, file2);
            }
        } else {
            $receiver.add(new BackupStrategy.FileDescriptor(input, prefix + File.separator));
        }
    }

    private final List<File> listSortedFiles(@NotNull File $receiver) {
        File[] fileArray = $receiver.listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"listFiles()");
        return ArraysKt.sorted((Comparable[])fileArray);
    }

    public FolderBackupStrategy(@NotNull String prefix, @NotNull File location) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.prefix = prefix;
        this.location = location;
    }
}

