/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.dnq;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.SimplePropertyValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityStore;
import jetbrains.mps.internal.collections.runtime.backports.LinkedList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.SystemPropertyUtils;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J;\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00002\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Ljetbrains/jetpass/userManagement/persistence/dnq/FolderConstraint;", "XD", "Lkotlinx/dnq/XdEntity;", "", "entityType", "Lkotlinx/dnq/XdEntityType;", "(Lkotlinx/dnq/XdEntityType;)V", "getEntityType", "()Lkotlinx/dnq/XdEntityType;", "message", "", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "check", "", "xd", "property", "Lkotlin/reflect/KProperty1;", "propertyValue", "persistentEntityStore", "Ljetbrains/exodus/entitystore/EntityStore;", "(Lkotlinx/dnq/XdEntity;Lkotlin/reflect/KProperty1;Ljava/lang/String;Ljetbrains/exodus/entitystore/EntityStore;)V", "getFolder", "Ljava/io/File;", "path", "getOrCreateFolder", "isValid", "", "jetbrains.jetpass.userManagement"})
public final class FolderConstraint<XD extends XdEntity> {
    @NotNull
    private String message;
    @NotNull
    private final XdEntityType<XD> entityType;

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.message = string;
    }

    public final void check(@NotNull XD xd, @NotNull KProperty1<XD, String> property, @Nullable String propertyValue, @NotNull EntityStore persistentEntityStore) {
        Intrinsics.checkParameterIsNotNull(xd, (String)"xd");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)persistentEntityStore, (String)"persistentEntityStore");
        if (!this.isValid(propertyValue, persistentEntityStore)) {
            String propertyName = ReflectionUtilKt.getDBName(property, this.entityType);
            Entity entity = xd.getEntity();
            if (entity == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
            }
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new SimplePropertyValidationException(propertyName + " should be valid folder but was " + propertyValue, this.message, (TransientEntity)entity, propertyName));
        }
    }

    private final boolean isValid(String path, EntityStore persistentEntityStore) {
        Object folder;
        File current;
        CharSequence charSequence;
        if (path == null || (charSequence = (CharSequence)path).length() == 0) {
            return true;
        }
        LinkedList foldersToCreateQueue = new LinkedList();
        for (current = this.getFolder(path, persistentEntityStore); current != null && !current.exists(); current = current.getParentFile()) {
            foldersToCreateQueue.addFirst((Object)current);
        }
        if (current == null || !current.isDirectory()) {
            return false;
        }
        boolean canCreate = true;
        ArrayList<Object> createdFoldersStack = new ArrayList<Object>(foldersToCreateQueue.size());
        Iterator iterator = foldersToCreateQueue.iterator();
        while (iterator.hasNext() && (canCreate = ((File)(folder = (File)iterator.next())).mkdir())) {
            createdFoldersStack.add(folder);
        }
        while (!(folder = (Collection)createdFoldersStack).isEmpty()) {
            folder = (File)createdFoldersStack.remove(CollectionsKt.getLastIndex((List)createdFoldersStack));
            ((File)folder).delete();
        }
        return canCreate;
    }

    @NotNull
    public final File getFolder(@NotNull String path, @NotNull EntityStore persistentEntityStore) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)persistentEntityStore, (String)"persistentEntityStore");
        String resolvedPath = SystemPropertyUtils.resolvePlaceholders((String)path);
        File file = new File(resolvedPath);
        return !file.isAbsolute() ? new File(persistentEntityStore.getLocation(), resolvedPath) : file;
    }

    @NotNull
    public final File getOrCreateFolder(@NotNull String path, @NotNull EntityStore persistentEntityStore) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)persistentEntityStore, (String)"persistentEntityStore");
        File file = this.getFolder(path, persistentEntityStore);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    @NotNull
    public final XdEntityType<XD> getEntityType() {
        return this.entityType;
    }

    public FolderConstraint(@NotNull XdEntityType<? extends XD> entityType) {
        Intrinsics.checkParameterIsNotNull(entityType, (String)"entityType");
        this.entityType = entityType;
        this.message = "is not a valid system folder";
    }
}

