/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.dnq;

import com.mortennobel.imagescaling.MultiStepRescaleOp;
import com.mortennobel.imagescaling.ThumpnailRescaleOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.imageio.ImageIO;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.jetpass.dnq.SpringStoreContainer;
import jetbrains.jetpass.userManagement.persistence.ExceptionUtilKt;
import jetbrains.jetpass.userManagement.persistence.PersistentFileDataURIUtilKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAvatar;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDataAvatar$Companion$resize$1;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDataAvatar$beforeFlush$1;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDataAvatar$beforeFlush$2;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDataAvatarKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdFile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import jetbrains.teamsys.dnq.runtime.files.FileMeta;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import kotlinx.dnq.LinkDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdNaturalEntityType;
import kotlinx.dnq.link.OnDeletePolicy;
import kotlinx.dnq.link.XdToOneRequiredLink;
import kotlinx.dnq.store.container.StoreContainer;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J#\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u0013\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010 R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R+\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000b\u00a8\u0006\""}, d2={"Ljetbrains/jetpass/userManagement/persistence/dnq/XdDataAvatar;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdAvatar;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdFile;", "data", "getData", "()Ljetbrains/jetpass/userManagement/persistence/dnq/XdFile;", "setData", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdFile;)V", "data$delegate", "Lkotlinx/dnq/link/XdToOneRequiredLink;", "etag", "", "getEtag", "()Ljava/lang/String;", "thumbnail", "getThumbnail", "setThumbnail", "thumbnail$delegate", "beforeFlush", "", "getAvatarURL", "size", "", "devicePixelRatio", "", "(Ljava/lang/Integer;Ljava/lang/Double;)Ljava/lang/String;", "width", "height", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljetbrains/jetpass/userManagement/persistence/dnq/XdFile;", "Companion", "jetbrains.jetpass.userManagement"})
public final class XdDataAvatar
extends XdAvatar {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdToOneRequiredLink data$delegate;
    @NotNull
    private final XdToOneRequiredLink thumbnail$delegate;
    private static final int DEFAULT_THUMBNAIL_WIDTH = 128;
    private static final int DEFAULT_THUMBNAIL_HEIGHT = 128;
    private static final String IMAGE_MIME_TYPE = "image/";
    @NotNull
    private static final Set<String> SUPPORTED_MIME_TYPES;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdDataAvatar.class), "data", "getData()Ljetbrains/jetpass/userManagement/persistence/dnq/XdFile;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdDataAvatar.class), "thumbnail", "getThumbnail()Ljetbrains/jetpass/userManagement/persistence/dnq/XdFile;"))};
        Companion = new Companion(null);
        DEFAULT_THUMBNAIL_WIDTH = 128;
        DEFAULT_THUMBNAIL_HEIGHT = 128;
        IMAGE_MIME_TYPE = IMAGE_MIME_TYPE;
        SUPPORTED_MIME_TYPES = SetsKt.setOf((Object[])new String[]{"image/jpg", "image/jpeg", "image/png", "image/gif"});
    }

    @NotNull
    public final XdFile getData() {
        return (XdFile)this.data$delegate.getValue((XdEntity)this, $$delegatedProperties[0]);
    }

    public final void setData(@NotNull XdFile xdFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdFile), (String)"<set-?>");
        this.data$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (XdEntity)xdFile);
    }

    @NotNull
    public final XdFile getThumbnail() {
        return (XdFile)this.thumbnail$delegate.getValue((XdEntity)this, $$delegatedProperties[1]);
    }

    public final void setThumbnail(@NotNull XdFile xdFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdFile), (String)"<set-?>");
        this.thumbnail$delegate.setValue((XdEntity)this, $$delegatedProperties[1], (XdEntity)xdFile);
    }

    /*
     * WARNING - void declaration
     */
    public void beforeFlush() {
        super.beforeFlush();
        if (ReflectionUtilKt.hasChanges((XdEntity)this, (KProperty1)((KProperty1)XdDataAvatar$beforeFlush$1.INSTANCE))) {
            void $receiver$iv;
            Object object;
            String mime = this.getData().getMimeType();
            if (mime == null || (object = (CharSequence)mime).length() == 0) {
                Void void_ = ExceptionUtilKt.throwUserConstraintValidationException(this.getData(), "Image Mime-Type is unknown");
                throw null;
            }
            if (!StringsKt.startsWith((String)mime, (String)IMAGE_MIME_TYPE, (boolean)true)) {
                Void void_ = ExceptionUtilKt.throwUserConstraintValidationException(this.getData(), "Image Mime-Type is not an image/*");
                throw null;
            }
            if (!SUPPORTED_MIME_TYPES.contains(mime)) {
                Void void_ = ExceptionUtilKt.throwUserConstraintValidationException(this.getData(), "Image Mime-Type [" + mime + "] is not supported");
                throw null;
            }
            object = this;
            KProperty1 property$iv = (KProperty1)XdDataAvatar$beforeFlush$2.INSTANCE;
            if (!ReflectionUtilKt.isDefined((XdEntity)$receiver$iv, XdDataAvatar.class, (KProperty1)property$iv) || !this.getThumbnail().isNew()) {
                try {
                    this.setThumbnail(jetbrains.jetpass.userManagement.persistence.dnq.XdDataAvatar$Companion.resize$default(Companion, this.getData(), 0, 0, 6, null));
                }
                catch (RuntimeException ex) {
                    XdEntity xdEntity = this.getData();
                    String string = ex.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    Void void_ = ExceptionUtilKt.throwUserConstraintValidationException(xdEntity, string);
                    throw null;
                }
            }
        }
    }

    @Override
    @Nullable
    public String getAvatarURL(@Nullable Integer size, @Nullable Double devicePixelRatio) {
        XdFile xdFile;
        if (size != null) {
            Double d = devicePixelRatio;
            int scaledSize = (int)((double)size.intValue() * (d != null ? d : 2.0));
            xdFile = this.getThumbnail(scaledSize, scaledSize);
        } else {
            xdFile = this.getData();
        }
        XdFile imageFile = xdFile;
        return PersistentFileDataURIUtilKt.toDataURI(imageFile);
    }

    @Override
    @Nullable
    public String getEtag() {
        return this.getData().getBase64EntityId();
    }

    private final XdFile getThumbnail(Integer width, Integer height) {
        XdFile xdFile;
        int h;
        Integer n = width;
        int w = n != null ? n : DEFAULT_THUMBNAIL_WIDTH;
        Integer n2 = height;
        int n3 = h = n2 != null ? n2 : DEFAULT_THUMBNAIL_HEIGHT;
        if (w <= DEFAULT_THUMBNAIL_WIDTH && h <= DEFAULT_THUMBNAIL_HEIGHT) {
            xdFile = this.getThumbnail();
        } else {
            XdDataAvatarKt.access$getLogger$p().warn("Requested thumbnail: " + w + 'x' + h + ". Return original one");
            xdFile = this.getData();
        }
        return xdFile;
    }

    public XdDataAvatar(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super(entity);
        this.data$delegate = (XdToOneRequiredLink)LinkDelegatesKt.xdLink1$default((XdEntityType)((XdEntityType)XdFile.Companion), null, (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CASCADE.INSTANCE), null, (int)10, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.thumbnail$delegate = (XdToOneRequiredLink)LinkDelegatesKt.xdLink1$default((XdEntityType)((XdEntityType)XdFile.Companion), null, (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CASCADE.INSTANCE), null, (int)10, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0005J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Ljetbrains/jetpass/userManagement/persistence/dnq/XdDataAvatar$Companion;", "Lkotlinx/dnq/XdNaturalEntityType;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdDataAvatar;", "()V", "DEFAULT_THUMBNAIL_HEIGHT", "", "getDEFAULT_THUMBNAIL_HEIGHT", "()I", "DEFAULT_THUMBNAIL_WIDTH", "getDEFAULT_THUMBNAIL_WIDTH", "IMAGE_MIME_TYPE", "", "SUPPORTED_MIME_TYPES", "", "getSUPPORTED_MIME_TYPES", "()Ljava/util/Set;", "new", "user", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdUser;", "file", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdFile;", "resize", "original", "maxWidth", "maxHeight", "scaleImage", "Ljava/awt/image/BufferedImage;", "image", "cropped", "", "width", "height", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends XdNaturalEntityType<XdDataAvatar> {
        public final int getDEFAULT_THUMBNAIL_WIDTH() {
            return DEFAULT_THUMBNAIL_WIDTH;
        }

        public final int getDEFAULT_THUMBNAIL_HEIGHT() {
            return DEFAULT_THUMBNAIL_HEIGHT;
        }

        @NotNull
        public final Set<String> getSUPPORTED_MIME_TYPES() {
            return SUPPORTED_MIME_TYPES;
        }

        @NotNull
        public final XdDataAvatar new(@NotNull XdUser user2, @NotNull XdFile file) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)user2), (String)"user");
            Intrinsics.checkParameterIsNotNull((Object)((Object)file), (String)"file");
            return (XdDataAvatar)this.new((Function1)new Function1<XdDataAvatar, Unit>(user2, file){
                final /* synthetic */ XdUser $user;
                final /* synthetic */ XdFile $file;

                public final void invoke(@NotNull XdDataAvatar $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
                    $receiver.setUser(this.$user);
                    $receiver.setData(this.$file);
                }
                {
                    this.$user = xdUser;
                    this.$file = xdFile;
                    super(1);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public final XdFile resize(@NotNull XdFile original, int maxWidth, int maxHeight) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)original), (String)"original");
            Object object = original;
            KProperty1 property$iv = (KProperty1)XdDataAvatar$Companion$resize$1.INSTANCE;
            if (!ReflectionUtilKt.isDefined((XdEntity)$receiver$iv, XdFile.class, (KProperty1)property$iv)) throw (Throwable)new IllegalStateException("Image content is empty");
            object = original.getContent();
            Throwable throwable = null;
            try {
                InputStream content2 = (InputStream)object;
                try {
                    BufferedImage image = ImageIO.read(content2);
                    if (image != null) {
                        int width = image.getWidth();
                        int height = image.getHeight();
                        if (width <= maxWidth && height <= maxHeight) {
                            XdDataAvatarKt.access$getLogger$p().warn("Provided image is smaller than requested size: " + width + 'x' + height);
                            XdFile xdFile = original;
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            return xdFile;
                        }
                        FileMeta meta = new FileMeta(original.getEntity());
                        meta.usePngAsDefault();
                        BufferedImage thumbImage = Companion.scaleImage(image, maxWidth, maxHeight, false, width, height);
                        LightByteArrayOutputStream out = new LightByteArrayOutputStream();
                        ImageIO.write((RenderedImage)thumbImage, meta.getFormat(), (OutputStream)out);
                        byte[] byteArray = out.toByteArray();
                        out.close();
                        meta.setSize((long)byteArray.length);
                        XdFile xdFile = (XdFile)XdFile.Companion.new((Function1)new Function1<XdFile, Unit>(byteArray, meta){
                            final /* synthetic */ byte[] $byteArray;
                            final /* synthetic */ FileMeta $meta;

                            public final void invoke(@NotNull XdFile $receiver) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
                                $receiver.setContent(new ByteArrayInputStream(this.$byteArray));
                                $receiver.setFileName(this.$meta.getName() + "-thumbnail");
                            }
                            {
                                this.$byteArray = byArray;
                                this.$meta = fileMeta;
                                super(1);
                            }
                        });
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        return xdFile;
                    }
                }
                catch (Exception e) {
                    XdDataAvatarKt.access$getLogger$p().info("Error while creating thumbnail.", (Throwable)e);
                    throw (Throwable)new RuntimeException("Can't resize provided image. Format is not supported or image corrupted.");
                }
                Unit unit = Unit.INSTANCE;
                throw (Throwable)new IllegalStateException("Image content is empty");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        @NotNull
        public static /* bridge */ /* synthetic */ XdFile resize$default(Companion companion, XdFile xdFile, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = companion.getDEFAULT_THUMBNAIL_WIDTH();
            }
            if ((n3 & 4) != 0) {
                n2 = companion.getDEFAULT_THUMBNAIL_HEIGHT();
            }
            return companion.resize(xdFile, n, n2);
        }

        private final BufferedImage scaleImage(BufferedImage image, int maxWidth, int maxHeight, boolean cropped, int width, int height) {
            BufferedImage bufferedImage;
            double xRatio = (double)maxWidth / (double)width;
            double yRatio = (double)maxHeight / (double)height;
            double ratio = Math.min(1.0, cropped ? Math.max(xRatio, yRatio) : Math.min(xRatio, yRatio));
            boolean thumbnail = ratio < FileMeta.MAX_RESAMPLING_RATIO;
            int thumbWidth = (int)((double)width * ratio);
            int thumbHeight = (int)((double)height * ratio);
            int canvasWidth = thumbWidth > maxWidth ? maxWidth : thumbWidth;
            int canvasHeight = thumbHeight > maxHeight ? maxHeight : thumbHeight;
            ColorModel cm = image.getColorModel();
            WritableRaster rs = cm.createCompatibleWritableRaster(thumbWidth, thumbHeight);
            ColorModel colorModel = cm;
            Intrinsics.checkExpressionValueIsNotNull((Object)colorModel, (String)"cm");
            BufferedImage dstImage = new BufferedImage(cm, rs, colorModel.isAlphaPremultiplied(), null);
            BufferedImageOp op = thumbnail ? (BufferedImageOp)new ThumpnailRescaleOp(thumbWidth, thumbHeight) : (BufferedImageOp)new MultiStepRescaleOp(thumbWidth, thumbHeight);
            op.filter(image, dstImage);
            if (cropped) {
                BufferedImage bufferedImage2 = dstImage.getSubimage(0, 0, canvasWidth, canvasHeight);
                bufferedImage = bufferedImage2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage2, (String)"dstImage.getSubimage(0, \u2026anvasWidth, canvasHeight)");
            } else {
                bufferedImage = dstImage;
            }
            return bufferedImage;
        }

        private Companion() {
            super("JPDataAvatar", (StoreContainer)SpringStoreContainer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

