/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.dnq.oauth;

import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.core.security.SecureRandomSingleton;
import jetbrains.jetpass.dnq.SpringStoreContainer;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKey;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKey$updateConstructor$1;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKey$updateConstructor$2;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKeyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.Charsets;
import kotlinx.dnq.PropertyDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdEnumEntity;
import kotlinx.dnq.enum.XdEnumEntityType;
import kotlinx.dnq.simple.XdMutableConstrainedProperty;
import kotlinx.dnq.simple.XdProperty;
import kotlinx.dnq.store.container.StoreContainer;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u000e\u0010,\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006J\u001d\u00100\u001a\u0002012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b2J\u0006\u00103\u001a\u000201J\u0016\u00104\u001a\u0002052\u0006\u0010/\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R+\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R+\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\r\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000bR+\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\r\u001a\u0004\b\u001f\u0010\t\"\u0004\b \u0010\u000bR+\u0010#\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\"8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00067"}, d2={"Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdKey;", "Lkotlinx/dnq/XdEnumEntity;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "", "keyAlgorithm", "getKeyAlgorithm", "()Ljava/lang/String;", "setKeyAlgorithm", "(Ljava/lang/String;)V", "keyAlgorithm$delegate", "Lkotlinx/dnq/simple/XdMutableConstrainedProperty;", "privateKey", "Ljava/security/PrivateKey;", "getPrivateKey", "()Ljava/security/PrivateKey;", "privateKeyB64String", "getPrivateKeyB64String", "setPrivateKeyB64String", "privateKeyB64String$delegate", "publicKey", "Ljava/security/PublicKey;", "getPublicKey", "()Ljava/security/PublicKey;", "publicKeyB64String", "getPublicKeyB64String", "setPublicKeyB64String", "publicKeyB64String$delegate", "signatureAlgorithm", "getSignatureAlgorithm", "setSignatureAlgorithm", "signatureAlgorithm$delegate", "", "version", "getVersion", "()I", "setVersion", "(I)V", "version$delegate", "Lkotlinx/dnq/simple/XdProperty;", "generateKeyPair", "Ljava/security/KeyPair;", "sign", "", "data", "message", "updateConstructor", "", "updateConstructor$jetbrains_jetpass_userManagement", "updateKeys", "verify", "", "Companion", "jetbrains.jetpass.userManagement"})
public final class XdKey
extends XdEnumEntity {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdMutableConstrainedProperty publicKeyB64String$delegate;
    @NotNull
    private final XdMutableConstrainedProperty privateKeyB64String$delegate;
    @NotNull
    private final XdProperty version$delegate;
    @NotNull
    private final XdMutableConstrainedProperty keyAlgorithm$delegate;
    @NotNull
    private final XdMutableConstrainedProperty signatureAlgorithm$delegate;
    private static final SecureRandom RANDOM;
    private static final int DEFAULT_KEY_SIZE = 1024;
    @NotNull
    private static final ReadOnlyProperty dsaKey$delegate;
    @NotNull
    private static final ReadOnlyProperty rsaKey$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdKey.class), "publicKeyB64String", "getPublicKeyB64String()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdKey.class), "privateKeyB64String", "getPrivateKeyB64String()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdKey.class), "version", "getVersion()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdKey.class), "keyAlgorithm", "getKeyAlgorithm()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdKey.class), "signatureAlgorithm", "getSignatureAlgorithm()Ljava/lang/String;"))};
        Companion = new Companion(null);
        RANDOM = SecureRandomSingleton.get();
        DEFAULT_KEY_SIZE = 1024;
        dsaKey$delegate = Companion.enumField("PAIR", Companion.dsaKey.2.INSTANCE).provideDelegate((XdEntityType)Companion, jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKey$Companion.$$delegatedProperties[0]);
        rsaKey$delegate = Companion.enumField("PAIR_RSA", Companion.rsaKey.2.INSTANCE).provideDelegate((XdEntityType)Companion, jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKey$Companion.$$delegatedProperties[1]);
    }

    @NotNull
    public final String getPublicKeyB64String() {
        return (String)this.publicKeyB64String$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setPublicKeyB64String(String string) {
        this.publicKeyB64String$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @NotNull
    public final String getPrivateKeyB64String() {
        return (String)this.privateKeyB64String$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setPrivateKeyB64String(String string) {
        this.privateKeyB64String$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    public final int getVersion() {
        return ((Number)((Object)this.version$delegate.getValue((XdEntity)this, $$delegatedProperties[2]))).intValue();
    }

    private final void setVersion(int n) {
        this.version$delegate.setValue((XdEntity)this, $$delegatedProperties[2], (Comparable)Integer.valueOf(n));
    }

    @NotNull
    public final String getKeyAlgorithm() {
        return (String)this.keyAlgorithm$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setKeyAlgorithm(String string) {
        this.keyAlgorithm$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
    }

    @NotNull
    public final String getSignatureAlgorithm() {
        return (String)this.signatureAlgorithm$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    private final void setSignatureAlgorithm(String string) {
        this.signatureAlgorithm$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)string);
    }

    @NotNull
    public final PublicKey getPublicKey() {
        KeyFactory kf = KeyFactory.getInstance(this.getKeyAlgorithm());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)this.getPublicKeyB64String()));
        PublicKey publicKey = kf.generatePublic(keySpec);
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"kf.generatePublic(keySpec)");
        return publicKey;
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        KeyFactory kf = KeyFactory.getInstance(this.getKeyAlgorithm());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)this.getPrivateKeyB64String()));
        PrivateKey privateKey = kf.generatePrivate(keySpec);
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"kf.generatePrivate(keySpec)");
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] sign(@NotNull byte[] data) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        long start = System.nanoTime();
        try {
            Signature signature;
            Signature $receiver = signature = Signature.getInstance(this.getSignatureAlgorithm());
            $receiver.initSign(this.getPrivateKey(), RANDOM);
            $receiver.update(data);
            Signature signature2 = signature;
            byte[] byArray2 = signature2.sign();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"signature.sign()");
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            XdKeyKt.access$getLogger$p().trace((Function0)new Function0<String>(start){
                final /* synthetic */ long $start;

                @NotNull
                public final String invoke() {
                    return "Token sign took: " + (System.nanoTime() - this.$start) / (long)1000000000 + 's';
                }
                {
                    this.$start = l;
                    super(0);
                }
            });
            throw throwable;
        }
        XdKeyKt.access$getLogger$p().trace((Function0)new /* invalid duplicate definition of identical inner class */);
        return byArray;
    }

    @NotNull
    public final String sign(@NotNull String message2) {
        Signature signature;
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Signature $receiver = signature = Signature.getInstance(this.getSignatureAlgorithm());
        $receiver.initSign(this.getPrivateKey(), RANDOM);
        String string = message2;
        Signature signature2 = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        signature2.update(byArray2);
        Signature signature3 = signature;
        String string2 = Base64.encodeBase64String((byte[])signature3.sign());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeBase64String(signature.sign())");
        return string2;
    }

    public final boolean verify(@NotNull String message2, @NotNull String sign2) {
        Signature signature;
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)sign2, (String)"sign");
        Signature $receiver = signature = Signature.getInstance(this.getSignatureAlgorithm());
        $receiver.initVerify(this.getPublicKey());
        String string = message2;
        Signature signature2 = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        signature2.update(byArray2);
        Signature signature3 = signature;
        return signature3.verify(Base64.decodeBase64((String)sign2));
    }

    private final KeyPair generateKeyPair(String keyAlgorithm) {
        KeyPairGenerator gen = KeyPairGenerator.getInstance(keyAlgorithm);
        gen.initialize(DEFAULT_KEY_SIZE, RANDOM);
        KeyPair keyPair2 = gen.genKeyPair();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPair2, (String)"gen.genKeyPair()");
        return keyPair2;
    }

    public final void updateConstructor$jetbrains_jetpass_userManagement(@NotNull String keyAlgorithm, @NotNull String signatureAlgorithm) {
        XdKey $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)keyAlgorithm, (String)"keyAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        this.setKeyAlgorithm(keyAlgorithm);
        this.setSignatureAlgorithm(signatureAlgorithm);
        XdKey xdKey = this;
        KProperty1 property$iv = (KProperty1)XdKey$updateConstructor$1.INSTANCE;
        if (!ReflectionUtilKt.isDefined((XdEntity)$receiver$iv, XdKey.class, (KProperty1)property$iv) && !ReflectionUtilKt.isDefined((XdEntity)($receiver$iv = this), XdKey.class, (KProperty1)(property$iv = (KProperty1)XdKey$updateConstructor$2.INSTANCE))) {
            this.updateKeys();
        }
    }

    public final void updateKeys() {
        KeyPair pair = this.generateKeyPair(this.getKeyAlgorithm());
        PrivateKey privateKey = pair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"pair.private");
        String string = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])privateKey.getEncoded()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtils.newStringUtf\u202664(pair.private.encoded))");
        this.setPrivateKeyB64String(string);
        PublicKey publicKey = pair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"pair.public");
        String string2 = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])publicKey.getEncoded()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtils.newStringUtf\u2026e64(pair.public.encoded))");
        this.setPublicKeyB64String(string2);
        this.setVersion(this.getVersion() + 1);
    }

    public XdKey(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super(entity);
        this.publicKeyB64String$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, null, null, null, (int)31, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.privateKeyB64String$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, null, null, null, (int)31, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
        this.version$delegate = (XdProperty)PropertyDelegatesKt.xdRequiredIntProp$default(null, (boolean)false, null, (int)7, null).provideDelegate((XdEntity)this, $$delegatedProperties[2]);
        this.keyAlgorithm$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, null, null, null, (int)31, null).provideDelegate((XdEntity)this, $$delegatedProperties[3]);
        this.signatureAlgorithm$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, null, null, null, (int)31, null).provideDelegate((XdEntity)this, $$delegatedProperties[4]);
    }

    @NotNull
    public static final /* synthetic */ String access$getPrivateKeyB64String$p(XdKey $this) {
        return $this.getPrivateKeyB64String();
    }

    public static final /* synthetic */ void access$setPrivateKeyB64String$p(XdKey $this, @NotNull String string) {
        $this.setPrivateKeyB64String(string);
    }

    @NotNull
    public static final /* synthetic */ String access$getPublicKeyB64String$p(XdKey $this) {
        return $this.getPublicKeyB64String();
    }

    public static final /* synthetic */ void access$setPublicKeyB64String$p(XdKey $this, @NotNull String string) {
        $this.setPublicKeyB64String(string);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0012"}, d2={"Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdKey$Companion;", "Lkotlinx/dnq/enum/XdEnumEntityType;", "Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdKey;", "()V", "DEFAULT_KEY_SIZE", "", "getDEFAULT_KEY_SIZE", "()I", "RANDOM", "Ljava/security/SecureRandom;", "dsaKey", "getDsaKey", "()Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdKey;", "dsaKey$delegate", "Lkotlin/properties/ReadOnlyProperty;", "rsaKey", "getRsaKey", "rsaKey$delegate", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends XdEnumEntityType<XdKey> {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "dsaKey", "getDsaKey()Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdKey;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "rsaKey", "getRsaKey()Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdKey;"))};
        }

        public final int getDEFAULT_KEY_SIZE() {
            return DEFAULT_KEY_SIZE;
        }

        @NotNull
        public final XdKey getDsaKey() {
            return (XdKey)((Object)dsaKey$delegate.getValue((Object)this, $$delegatedProperties[0]));
        }

        @NotNull
        public final XdKey getRsaKey() {
            return (XdKey)((Object)rsaKey$delegate.getValue((Object)this, $$delegatedProperties[1]));
        }

        private Companion() {
            super("Key", (StoreContainer)SpringStoreContainer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

