/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.license;

import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.userManagement.persistence.license.HubApplicationDescriptor;
import jetbrains.jetpass.userManagement.persistence.license.LicenseExtensionKt;
import jetbrains.ring.license.License;
import jetbrains.ring.license.checker.ApplicationDescriptor;
import jetbrains.ring.license.checker.LicenseCheckerImpl;
import jetbrains.ring.license.checker.LicenseLimitException;
import jetbrains.ring.license.checker.LicenseUserNumberExceededException;
import jetbrains.ring.license.checker.UpgradeExpiredException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/HostLicenseChecker;", "Ljetbrains/ring/license/checker/LicenseCheckerImpl;", "license", "Ljetbrains/ring/license/License;", "licenseKey", "", "hubApplicationDescriptor", "Ljetbrains/jetpass/userManagement/persistence/license/HubApplicationDescriptor;", "(Ljetbrains/ring/license/License;Ljava/lang/String;Ljetbrains/jetpass/userManagement/persistence/license/HubApplicationDescriptor;)V", "checkAllowsMoreUsers", "", "checkCanChangeLogo", "checkDiskUsage", "checkUpgradeExpiration", "checkUsersLimitNotExceeded", "jetbrains.jetpass.userManagement"})
public class HostLicenseChecker
extends LicenseCheckerImpl {
    private final String licenseKey;
    private final HubApplicationDescriptor hubApplicationDescriptor;

    public void checkUpgradeExpiration() throws UpgradeExpiredException {
        TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HostLicenseChecker this$0;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ApplicationDescriptor applicationDescriptor = this.this$0.getApplicationDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationDescriptor, (String)"applicationDescriptor");
                long releaseDate = applicationDescriptor.getReleaseDate();
                if (releaseDate != Long.MAX_VALUE) {
                    License license2 = this.this$0.getLicense();
                    Intrinsics.checkExpressionValueIsNotNull((Object)license2, (String)"license");
                    long upgradeExpirationTime = license2.getUpgradeExpirationTime();
                    if (upgradeExpirationTime < releaseDate) {
                        HubApplicationDescriptor hubApplicationDescriptor = HostLicenseChecker.access$getHubApplicationDescriptor$p(this.this$0);
                        License license3 = this.this$0.getLicense();
                        Intrinsics.checkExpressionValueIsNotNull((Object)license3, (String)"license");
                        String string = license3.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"license.name");
                        long histReleaseDate = hubApplicationDescriptor.getHistoricalReleaseDate(string, HostLicenseChecker.access$getLicenseKey$p(this.this$0));
                        if (histReleaseDate == Long.MAX_VALUE || upgradeExpirationTime < histReleaseDate) {
                            throw (Throwable)new UpgradeExpiredException(this.this$0.getLicense());
                        }
                    }
                }
            }
            {
                this.this$0 = hostLicenseChecker;
                super(1);
            }
        }, 7, null);
    }

    public final void checkUsersLimitNotExceeded() throws LicenseUserNumberExceededException {
        License license2;
        License license3 = license2 = this.getLicense();
        Intrinsics.checkExpressionValueIsNotNull((Object)license3, (String)"license");
        int licenseUserCount = LicenseExtensionKt.getTotalUserCount(license3);
        if (licenseUserCount != Integer.MAX_VALUE) {
            ApplicationDescriptor applicationDescriptor = this.getApplicationDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationDescriptor, (String)"applicationDescriptor");
            if (applicationDescriptor.getUsersNumber() > licenseUserCount) {
                throw (Throwable)new LicenseUserNumberExceededException(license2);
            }
        }
        this.checkBasicValidity();
    }

    public void checkDiskUsage() throws LicenseLimitException {
        super.checkDiskUsage();
        this.checkBasicValidity();
    }

    public void checkAllowsMoreUsers() throws LicenseUserNumberExceededException {
        super.checkAllowsMoreUsers();
        this.checkBasicValidity();
    }

    public void checkCanChangeLogo() throws LicenseLimitException {
        super.checkCanChangeLogo();
        this.checkBasicValidity();
    }

    public HostLicenseChecker(@NotNull License license2, @NotNull String licenseKey, @NotNull HubApplicationDescriptor hubApplicationDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)license2, (String)"license");
        Intrinsics.checkParameterIsNotNull((Object)licenseKey, (String)"licenseKey");
        Intrinsics.checkParameterIsNotNull((Object)hubApplicationDescriptor, (String)"hubApplicationDescriptor");
        super(license2, (ApplicationDescriptor)hubApplicationDescriptor);
        this.licenseKey = licenseKey;
        this.hubApplicationDescriptor = hubApplicationDescriptor;
    }

    @NotNull
    public static final /* synthetic */ HubApplicationDescriptor access$getHubApplicationDescriptor$p(HostLicenseChecker $this) {
        return $this.hubApplicationDescriptor;
    }

    @NotNull
    public static final /* synthetic */ String access$getLicenseKey$p(HostLicenseChecker $this) {
        return $this.licenseKey;
    }
}

